/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.group;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.group.MapGroupEntity;

public class MapGroupEntityImpl
extends MapGroupEntity.AbstractGroupEntity
implements MapGroupEntity {
    private final DeepCloner cloner;
    private String fId;
    private Map<String, List<String>> fAttributes;
    private Set<String> fGrantedRoles;
    private String fName;
    private String fParentId;
    private String fRealmId;

    public MapGroupEntityImpl() {
        this.cloner = DeepCloner.DUMB_CLONER;
    }

    public MapGroupEntityImpl(DeepCloner cloner) {
        this.cloner = cloner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapGroupEntityImpl)) {
            return false;
        }
        MapGroupEntityImpl other = (MapGroupEntityImpl)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAttributes(), other.getAttributes()) && Objects.equals(this.getGrantedRoles(), other.getGrantedRoles()) && Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getParentId(), other.getParentId()) && Objects.equals(this.getRealmId(), other.getRealmId());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public <V> V deepClone(V obj) {
        return this.cloner.from(obj);
    }

    @Override
    public void removeAttribute(String p0) {
        if (this.fAttributes == null) {
            return;
        }
        boolean removed = this.fAttributes.remove(p0) != null;
        this.updated |= removed;
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        return this.fAttributes;
    }

    @Override
    public void setAttributes(Map<String, List<String>> p0) {
        Map<String, List<String>> map = p0 = p0 == null ? null : (Map<String, List<String>>)p0.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() == null ? null : new LinkedList((Collection)entry.getValue()), (o1, o2) -> o1, HashMap::new));
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        this.updated |= !Objects.equals(this.fAttributes, p0);
        this.fAttributes = p0;
    }

    @Override
    public void setAttribute(String p0, List<String> p1) {
        LinkedList v;
        boolean valueUndefined;
        LinkedList<String> linkedList = p1 = p1 == null ? null : new LinkedList<String>(p1);
        if (p1 != null) {
            p1.removeIf(UndefinedValuesUtils::isUndefined);
        }
        if (valueUndefined = UndefinedValuesUtils.isUndefined(p1)) {
            if (this.fAttributes != null) {
                this.updated |= this.fAttributes.remove(p0) != null;
            }
            return;
        }
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap<String, List<String>>();
        }
        this.updated |= !Objects.equals(v = this.fAttributes.put(p0, p1), p1);
    }

    @Override
    public List<String> getAttribute(String p0) {
        return this.fAttributes == null ? null : this.fAttributes.get(p0);
    }

    @Override
    public void removeGrantedRole(String p0) {
        if (this.fGrantedRoles == null) {
            return;
        }
        boolean removed = this.fGrantedRoles.remove(p0);
        this.updated |= removed;
    }

    @Override
    public void addGrantedRole(String p0) {
        if (UndefinedValuesUtils.isUndefined(p0)) {
            return;
        }
        if (this.fGrantedRoles == null) {
            this.fGrantedRoles = new HashSet<String>();
        }
        this.updated |= this.fGrantedRoles.add(p0);
    }

    @Override
    public void setGrantedRoles(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        this.updated |= !Objects.equals(this.fGrantedRoles, p0);
        this.fGrantedRoles = p0;
    }

    @Override
    public Set<String> getGrantedRoles() {
        return this.fGrantedRoles;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String p0) {
        this.updated |= !Objects.equals(this.fName, p0);
        this.fName = p0;
    }

    @Override
    public void setParentId(String p0) {
        this.updated |= !Objects.equals(this.fParentId, p0);
        this.fParentId = p0;
    }

    @Override
    public String getParentId() {
        return this.fParentId;
    }

    @Override
    public void setRealmId(String p0) {
        this.updated |= !Objects.equals(this.fRealmId, p0);
        this.fRealmId = p0;
    }

    @Override
    public String getRealmId() {
        return this.fRealmId;
    }

    public static class Empty
    extends MapGroupEntity.AbstractGroupEntity
    implements MapGroupEntity {
        public static final Empty INSTANCE = new Empty();

        @Override
        public void setId(String id) {
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public void removeAttribute(String name) {
        }

        @Override
        public Map<String, List<String>> getAttributes() {
            return null;
        }

        @Override
        public void setAttributes(Map<String, List<String>> attributes) {
        }

        @Override
        public void setAttribute(String name, List<String> value) {
        }

        @Override
        public List<String> getAttribute(String name) {
            return null;
        }

        @Override
        public void removeGrantedRole(String role) {
        }

        @Override
        public void addGrantedRole(String role) {
        }

        @Override
        public void setGrantedRoles(Set<String> grantedRoles) {
        }

        @Override
        public Set<String> getGrantedRoles() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public void setName(String name) {
        }

        @Override
        public void setParentId(String parentId) {
        }

        @Override
        public String getParentId() {
            return null;
        }

        @Override
        public void setRealmId(String realmId) {
        }

        @Override
        public String getRealmId() {
            return null;
        }

        @Override
        public boolean isUpdated() {
            return false;
        }
    }
}

