/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.configproperties;

import io.quarkus.arc.config.ConfigProperties;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.util.StringUtil;
import java.util.Iterator;
import java.util.function.BiFunction;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public final class ConfigPropertiesMetadataBuildItem
extends MultiBuildItem {
    private final ClassInfo classInfo;
    private final String prefix;
    private final ConfigProperties.NamingStrategy namingStrategy;
    private final boolean failOnMismatchingMember;
    private final boolean needsQualifier;
    private final InstanceFactory instanceFactory;

    public ConfigPropertiesMetadataBuildItem(ClassInfo classInfo, String prefix, ConfigProperties.NamingStrategy namingStrategy, boolean failOnMismatchingMember, boolean needsQualifier) {
        this.classInfo = classInfo;
        this.prefix = this.sanitisePrefix(prefix);
        this.namingStrategy = namingStrategy;
        this.failOnMismatchingMember = failOnMismatchingMember;
        this.needsQualifier = needsQualifier;
        this.instanceFactory = null;
    }

    public ConfigPropertiesMetadataBuildItem(ClassInfo classInfo, String prefix, ConfigProperties.NamingStrategy namingStrategy, boolean failOnMismatchingMember, boolean needsQualifier, InstanceFactory instanceFactory) {
        this.classInfo = classInfo;
        this.prefix = this.sanitisePrefix(prefix);
        this.namingStrategy = namingStrategy;
        this.failOnMismatchingMember = failOnMismatchingMember;
        this.needsQualifier = needsQualifier;
        this.instanceFactory = instanceFactory;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ConfigProperties.NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public boolean isFailOnMismatchingMember() {
        return this.failOnMismatchingMember;
    }

    public boolean isNeedsQualifier() {
        return this.needsQualifier;
    }

    public InstanceFactory getInstanceFactory() {
        return this.instanceFactory;
    }

    private String sanitisePrefix(String prefix) {
        if (this.isPrefixUnset(prefix)) {
            return this.getPrefixFromClassName(this.classInfo.name());
        }
        return prefix;
    }

    private boolean isPrefixUnset(String prefix) {
        return prefix == null || prefix.trim().isEmpty() || "<< unset >>".equals(prefix.trim());
    }

    private String getPrefixFromClassName(DotName className) {
        String simpleName = className.isInner() ? className.local() : className.withoutPackagePrefix();
        return StringUtil.join((String)"-", (Iterator)StringUtil.withoutSuffix((Iterator)StringUtil.lowerCase((Iterator)StringUtil.camelHumpsIterator((String)simpleName)), (String[])new String[]{"config", "configuration", "properties", "props"}));
    }

    public static interface InstanceFactory
    extends BiFunction<MethodCreator, String, ResultHandle> {
    }
}

