/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.staticmethods;

import io.quarkus.arc.InjectableInterceptor;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.InterceptorResolverBuildItem;
import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.staticmethods.InterceptedStaticMethodBuildItem;
import io.quarkus.arc.deployment.staticmethods.InterceptedStaticMethodsTransformersRegisteredBuildItem;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.InterceptedMethodMetadata;
import io.quarkus.arc.impl.InterceptedStaticMethods;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.runtime.InterceptedStaticMethodsRecorder;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.util.AsmUtil;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.invoke.CallSite;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.InterceptionType;
import javax.interceptor.InvocationContext;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class InterceptedStaticMethodsProcessor {
    private static final Logger LOGGER = Logger.getLogger(InterceptedStaticMethodsProcessor.class);
    static final MethodDescriptor INTERCEPTED_STATIC_METHODS_REGISTER = MethodDescriptor.ofMethod(InterceptedStaticMethods.class, (String)"register", Void.TYPE, (Class[])new Class[]{String.class, InterceptedStaticMethods.InterceptedStaticMethod.class});
    static final MethodDescriptor INTERCEPTED_STATIC_METHODS_AROUND_INVOKE = MethodDescriptor.ofMethod(InterceptedStaticMethods.class, (String)"aroundInvoke", Object.class, (Class[])new Class[]{String.class, Object[].class});
    private static final String ORIGINAL_METHOD_COPY_SUFFIX = "_orig";
    private static final String INITIALIZER_CLASS_SUFFIX = "_InterceptorInitializer";

    @BuildStep
    void collectInterceptedStaticMethods(BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<InterceptedStaticMethodBuildItem> interceptedStaticMethods, InterceptorResolverBuildItem interceptorResolver, TransformedAnnotationsBuildItem transformedAnnotations, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        Set<DotName> interceptorBindings = interceptorResolver.getInterceptorBindings();
        for (ClassInfo clazz : beanArchiveIndex.getIndex().getKnownClasses()) {
            for (MethodInfo method : clazz.methods()) {
                Collection<AnnotationInstance> annotations;
                if (method.isSynthetic() || !Modifier.isStatic(method.flags()) || "<clinit>".equals(method.name()) || (annotations = transformedAnnotations.getAnnotations((AnnotationTarget)method)).isEmpty()) continue;
                HashSet<AnnotationInstance> methodLevelBindings = null;
                for (AnnotationInstance annotationInstance : annotations) {
                    if (annotationInstance.target().kind() != AnnotationTarget.Kind.METHOD || !interceptorBindings.contains(annotationInstance.name())) continue;
                    if (methodLevelBindings == null) {
                        methodLevelBindings = new HashSet<AnnotationInstance>();
                    }
                    methodLevelBindings.add(annotationInstance);
                }
                if (methodLevelBindings == null || methodLevelBindings.isEmpty()) continue;
                if (Modifier.isPrivate(method.flags())) {
                    LOGGER.warnf("Interception of private static methods is not supported; bindings found on %s: %s", (Object)method.declaringClass().name(), (Object)method);
                    continue;
                }
                List interceptors = interceptorResolver.get().resolve(InterceptionType.AROUND_INVOKE, (Set)methodLevelBindings);
                if (interceptors.isEmpty()) continue;
                LOGGER.debugf("Intercepted static method found on %s: %s", (Object)method.declaringClass().name(), (Object)method);
                unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames(interceptors.stream().map(BeanInfo::getBeanClass).map(Object::toString).collect(Collectors.toSet())));
                interceptedStaticMethods.produce((BuildItem)new InterceptedStaticMethodBuildItem(method, methodLevelBindings, interceptors));
            }
        }
    }

    @Produce(value=InterceptedStaticMethodsTransformersRegisteredBuildItem.class)
    @BuildStep
    void processInterceptedStaticMethods(BeanArchiveIndexBuildItem beanArchiveIndex, BeanRegistrationPhaseBuildItem phase, List<InterceptedStaticMethodBuildItem> interceptedStaticMethods, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods) {
        if (interceptedStaticMethods.isEmpty()) {
            return;
        }
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, true);
        HashMap<DotName, Object> interceptedStaticMethodsMap = new HashMap<DotName, Object>();
        for (InterceptedStaticMethodBuildItem interceptedStaticMethod : interceptedStaticMethods) {
            Object list = (List)interceptedStaticMethodsMap.get(interceptedStaticMethod.getTarget().name());
            if (list == null) {
                list = new ArrayList<InterceptedStaticMethodBuildItem>();
                interceptedStaticMethodsMap.put(interceptedStaticMethod.getTarget().name(), list);
            }
            list.add(interceptedStaticMethod);
        }
        HashMap<DotName, CallSite> initializers = new HashMap<DotName, CallSite>();
        String initAllMethodName = "init_static_intercepted_methods";
        for (Map.Entry entry : interceptedStaticMethodsMap.entrySet()) {
            String packageName = DotNames.internalPackageNameWithTrailingSlash((DotName)((DotName)entry.getKey()));
            String initializerName = packageName.replace("/", ".") + ((DotName)entry.getKey()).withoutPackagePrefix() + INITIALIZER_CLASS_SUFFIX;
            initializers.put((DotName)entry.getKey(), (CallSite)((Object)initializerName));
            ClassCreator initializer = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(initializerName).setFinal(true).build();
            ArrayList<String> initMethods = new ArrayList<String>();
            for (InterceptedStaticMethodBuildItem interceptedStaticMethod : (List)entry.getValue()) {
                initMethods.add(this.implementInit(beanArchiveIndex.getIndex(), initializer, interceptedStaticMethod, reflectiveMethods, phase.getBeanProcessor()));
                this.implementForward(initializer, interceptedStaticMethod);
            }
            MethodCreator init = (MethodCreator)initializer.getMethodCreator(initAllMethodName, Void.TYPE, new Class[0]).setModifiers(9);
            for (String initMethod : initMethods) {
                init.invokeStaticMethod(MethodDescriptor.ofMethod((Object)initializer.getClassName(), (String)initMethod, Void.TYPE, (Object[])new Object[0]), new ResultHandle[0]);
            }
            init.returnValue(null);
            initializer.close();
        }
        for (Map.Entry entry : interceptedStaticMethodsMap.entrySet()) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(((DotName)entry.getKey()).toString(), (BiFunction)new InterceptedStaticMethodsEnhancer((String)initializers.get(entry.getKey()), (List)entry.getValue())));
        }
        ClassCreator globalInitializer = ClassCreator.builder().classOutput((ClassOutput)classOutput).className("io.quarkus.arc.runtime.InterceptedStaticMethodsInitializer".replace('.', '/')).setFinal(true).build();
        MethodCreator methodCreator = (MethodCreator)globalInitializer.getMethodCreator("<clinit>", Void.TYPE, new Class[0]).setModifiers(8);
        for (String initializerClass : initializers.values()) {
            methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod((Object)initializerClass, (String)initAllMethodName, Void.TYPE, (Object[])new Object[0]), new ResultHandle[0]);
        }
        methodCreator.returnValue(null);
        globalInitializer.close();
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void callInitializer(BeanContainerBuildItem beanContainer, List<InterceptedStaticMethodBuildItem> interceptedStaticMethods, InterceptedStaticMethodsRecorder recorder) {
        if (interceptedStaticMethods.isEmpty()) {
            return;
        }
        recorder.callInitializer();
    }

    private void implementForward(ClassCreator initializer, InterceptedStaticMethodBuildItem interceptedStaticMethod) {
        MethodInfo method = interceptedStaticMethod.getMethod();
        List params = method.parameterTypes();
        Object[] paramTypes = new String[params.size()];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypes[i] = DescriptorUtils.typeToString((Type)((Type)params.get(i)));
        }
        MethodCreator forward = (MethodCreator)initializer.getMethodCreator(interceptedStaticMethod.getHash(), (Object)DescriptorUtils.typeToString((Type)method.returnType()), paramTypes).setModifiers(25);
        ResultHandle argArray = forward.newArray(Object.class, params.size());
        for (int i = 0; i < params.size(); ++i) {
            forward.writeArrayValue(argArray, i, forward.getMethodParam(i));
        }
        ResultHandle ret = forward.invokeStaticMethod(INTERCEPTED_STATIC_METHODS_AROUND_INVOKE, new ResultHandle[]{forward.load(interceptedStaticMethod.getHash()), argArray});
        forward.returnValue(ret);
    }

    private String implementInit(IndexView index, ClassCreator initializer, InterceptedStaticMethodBuildItem interceptedStaticMethod, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BeanProcessor beanProcessor) {
        ResultHandle bindingsHandle;
        ResultHandle chainHandle;
        MethodInfo method = interceptedStaticMethod.getMethod();
        List<InterceptorInfo> interceptors = interceptedStaticMethod.getInterceptors();
        Set<AnnotationInstance> bindings = interceptedStaticMethod.getBindings();
        String name = "init" + "_" + method.name() + "_" + interceptedStaticMethod.getHash();
        MethodCreator init = (MethodCreator)initializer.getMethodCreator(name, Void.TYPE, new Class[0]).setModifiers(26);
        ResultHandle creationalContext = init.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{init.loadNull()});
        if (interceptors.size() == 1) {
            chainHandle = init.invokeStaticMethod(MethodDescriptors.COLLECTIONS_SINGLETON_LIST, new ResultHandle[]{this.createInterceptorInvocation(interceptors.get(0), (BytecodeCreator)init, creationalContext)});
        } else {
            chainHandle = init.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (InterceptorInfo interceptor : interceptors) {
                init.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, chainHandle, new ResultHandle[]{this.createInterceptorInvocation(interceptor, (BytecodeCreator)init, creationalContext)});
            }
        }
        ResultHandle[] paramsHandles = new ResultHandle[3];
        paramsHandles[0] = init.loadClassFromTCCL(method.declaringClass().name().toString());
        paramsHandles[1] = init.load(method.name());
        if (!method.parameterTypes().isEmpty()) {
            ResultHandle paramsArray = init.newArray(Class.class, init.load(method.parametersCount()));
            ListIterator iterator = method.parameterTypes().listIterator();
            while (iterator.hasNext()) {
                init.writeArrayValue(paramsArray, iterator.nextIndex(), init.loadClassFromTCCL(((Type)iterator.next()).name().toString()));
            }
            paramsHandles[2] = paramsArray;
        } else {
            paramsHandles[2] = init.newArray(Class.class, init.load(0));
        }
        ResultHandle methodHandle = init.invokeStaticMethod(MethodDescriptors.REFLECTIONS_FIND_METHOD, paramsHandles);
        if (bindings.size() == 1) {
            bindingsHandle = init.invokeStaticMethod(MethodDescriptors.COLLECTIONS_SINGLETON, new ResultHandle[]{this.createBindingLiteral(index, (BytecodeCreator)init, bindings.iterator().next(), beanProcessor.getAnnotationLiteralProcessor())});
        } else {
            bindingsHandle = init.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (AnnotationInstance binding : bindings) {
                init.invokeInterfaceMethod(MethodDescriptors.SET_ADD, bindingsHandle, new ResultHandle[]{this.createBindingLiteral(index, (BytecodeCreator)init, binding, beanProcessor.getAnnotationLiteralProcessor())});
            }
        }
        ResultHandle metadataHandle = init.newInstance(MethodDescriptors.INTERCEPTED_METHOD_METADATA_CONSTRUCTOR, new ResultHandle[]{chainHandle, methodHandle, bindingsHandle});
        reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem(method));
        ResultHandle forwardingFunc = this.createForwardingFunction(init, interceptedStaticMethod.getTarget(), method);
        ResultHandle staticMethodHandle = init.newInstance(MethodDescriptor.ofConstructor(InterceptedStaticMethods.InterceptedStaticMethod.class, (Class[])new Class[]{Function.class, InterceptedMethodMetadata.class}), new ResultHandle[]{forwardingFunc, metadataHandle});
        init.invokeStaticMethod(INTERCEPTED_STATIC_METHODS_REGISTER, new ResultHandle[]{init.load(interceptedStaticMethod.getHash()), staticMethodHandle});
        init.returnValue(null);
        return name;
    }

    private ResultHandle createBindingLiteral(IndexView index, BytecodeCreator init, AnnotationInstance binding, AnnotationLiteralProcessor annotationLiterals) {
        ClassInfo bindingClass = index.getClassByName(binding.name());
        return annotationLiterals.create(init, bindingClass, binding);
    }

    private ResultHandle createInterceptorInvocation(InterceptorInfo interceptor, BytecodeCreator init, ResultHandle creationalContext) {
        ResultHandle interceptorBean = this.getInterceptorBean(interceptor, init);
        ResultHandle interceptorInstance = this.createInterceptor(interceptorBean, init, creationalContext);
        return init.invokeStaticMethod(MethodDescriptors.INTERCEPTOR_INVOCATION_AROUND_INVOKE, new ResultHandle[]{interceptorBean, interceptorInstance});
    }

    private ResultHandle getInterceptorBean(InterceptorInfo interceptor, BytecodeCreator creator) {
        ResultHandle containerHandle = creator.invokeStaticMethod(MethodDescriptors.ARC_CONTAINER, new ResultHandle[0]);
        return creator.checkCast(creator.invokeInterfaceMethod(MethodDescriptors.ARC_CONTAINER_BEAN, containerHandle, new ResultHandle[]{creator.load(interceptor.getIdentifier())}), InjectableInterceptor.class);
    }

    private ResultHandle createInterceptor(ResultHandle interceptorBean, BytecodeCreator creator, ResultHandle parentCreationalContext) {
        ResultHandle creationalContext = creator.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD, new ResultHandle[]{parentCreationalContext});
        return creator.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, interceptorBean, new ResultHandle[]{creationalContext});
    }

    private ResultHandle createForwardingFunction(MethodCreator init, ClassInfo target, MethodInfo method) {
        String[] params;
        ResultHandle[] paramHandles;
        FunctionCreator func = init.createFunction(Function.class);
        BytecodeCreator funcBytecode = func.getBytecode();
        List paramTypes = method.parameterTypes();
        if (paramTypes.isEmpty()) {
            paramHandles = new ResultHandle[]{};
            params = new String[]{};
        } else {
            int i;
            paramHandles = new ResultHandle[paramTypes.size()];
            ResultHandle ctxHandle = funcBytecode.getMethodParam(0);
            ResultHandle ctxParamsHandle = funcBytecode.invokeInterfaceMethod(MethodDescriptor.ofMethod(InvocationContext.class, (String)"getParameters", Object[].class, (Class[])new Class[0]), ctxHandle, new ResultHandle[0]);
            for (i = 0; i < paramHandles.length; ++i) {
                paramHandles[i] = funcBytecode.readArrayValue(ctxParamsHandle, i);
            }
            params = new String[paramTypes.size()];
            for (i = 0; i < paramTypes.size(); ++i) {
                params[i] = ((Type)paramTypes.get(i)).name().toString();
            }
        }
        ResultHandle ret = funcBytecode.invokeStaticMethod(MethodDescriptor.ofMethod((String)target.name().toString(), (String)(method.name() + ORIGINAL_METHOD_COPY_SUFFIX), (String)method.returnType().name().toString(), (String[])params), paramHandles);
        if (ret == null) {
            funcBytecode.returnValue(funcBytecode.loadNull());
        } else {
            funcBytecode.returnValue(ret);
        }
        return func.getInstance();
    }

    static class InterceptedStaticMethodsMethodVisitor
    extends MethodVisitor {
        private final String initializerClassName;
        private final InterceptedStaticMethodBuildItem interceptedStaticMethod;
        private final MethodVisitor superVisitor;

        public InterceptedStaticMethodsMethodVisitor(MethodVisitor superVisitor, MethodVisitor copyVisitor, String initializerClassName, InterceptedStaticMethodBuildItem interceptedStaticMethod) {
            super(589824, copyVisitor);
            this.superVisitor = superVisitor;
            this.initializerClassName = initializerClassName;
            this.interceptedStaticMethod = interceptedStaticMethod;
        }

        public void visitEnd() {
            MethodDescriptor descriptor = MethodDescriptor.of((MethodInfo)this.interceptedStaticMethod.getMethod());
            int paramSlot = 0;
            for (Type paramType : this.interceptedStaticMethod.getMethod().parameterTypes()) {
                this.superVisitor.visitIntInsn(AsmUtil.getLoadOpcode((Type)paramType), paramSlot);
                paramSlot += AsmUtil.getParameterSize((Type)paramType);
            }
            this.superVisitor.visitMethodInsn(184, this.initializerClassName.replace('.', '/'), this.interceptedStaticMethod.getHash(), descriptor.getDescriptor().toString(), false);
            this.superVisitor.visitInsn(AsmUtil.getReturnInstruction((Type)this.interceptedStaticMethod.getMethod().returnType()));
            this.superVisitor.visitMaxs(0, 0);
            this.superVisitor.visitEnd();
            super.visitEnd();
        }
    }

    static class InterceptedStaticMethodsClassVisitor
    extends ClassVisitor {
        private final String initializerClassName;
        private final List<InterceptedStaticMethodBuildItem> methods;

        public InterceptedStaticMethodsClassVisitor(String initializerClassName, ClassVisitor outputClassVisitor, List<InterceptedStaticMethodBuildItem> methods) {
            super(589824, outputClassVisitor);
            this.methods = methods;
            this.initializerClassName = initializerClassName;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            InterceptedStaticMethodBuildItem method = this.findMatchingMethod(access, name, descriptor);
            if (method != null) {
                MethodVisitor copy = super.visitMethod(access, name + InterceptedStaticMethodsProcessor.ORIGINAL_METHOD_COPY_SUFFIX, descriptor, signature, exceptions);
                MethodVisitor superVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
                return new InterceptedStaticMethodsMethodVisitor(superVisitor, copy, this.initializerClassName, method);
            }
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }

        private InterceptedStaticMethodBuildItem findMatchingMethod(int access, String name, String descriptor) {
            if (Modifier.isStatic(access)) {
                for (InterceptedStaticMethodBuildItem method : this.methods) {
                    if (!method.getMethod().name().equals(name) || !MethodDescriptor.of((MethodInfo)method.getMethod()).getDescriptor().equals(descriptor)) continue;
                    return method;
                }
            }
            return null;
        }
    }

    static class InterceptedStaticMethodsEnhancer
    implements BiFunction<String, ClassVisitor, ClassVisitor> {
        private final String initializerClassName;
        private final List<InterceptedStaticMethodBuildItem> methods;

        public InterceptedStaticMethodsEnhancer(String initializerClassName, List<InterceptedStaticMethodBuildItem> methods) {
            this.methods = methods;
            this.initializerClassName = initializerClassName;
        }

        @Override
        public ClassVisitor apply(String className, ClassVisitor outputClassVisitor) {
            return new InterceptedStaticMethodsClassVisitor(this.initializerClassName, outputClassVisitor, this.methods);
        }
    }
}

