/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.parser.feature;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;

public class FeatureConfiguration {
    private static final Logger LOG = Logger.getLogger(FeatureConfiguration.class.getName());
    private Map<Feature, Object> featureEnabled = new EnumMap<Feature, Object>(Feature.class);

    public FeatureConfiguration() {
        EnumSet.allOf(Feature.class).stream().filter(Feature::isConfigurable).forEach(feature -> {
            Feature feature2 = feature;
            this.setValue(feature2, feature2.getDefaultValue());
        });
    }

    public FeatureConfiguration setValue(Feature feature, Object object) {
        if (feature.isConfigurable()) {
            this.featureEnabled.put(feature, object);
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.warning(feature.name() + " is not switchable - cannot set enabled = " + object);
        }
        return this;
    }

    public Object getValue(Feature feature) {
        if (feature.isConfigurable()) {
            return this.featureEnabled.get((Object)feature);
        }
        throw new IllegalStateException("The feature " + (Object)((Object)feature) + " is not configurable!");
    }

    public boolean getAsBoolean(Feature feature) {
        return Boolean.valueOf(String.valueOf(this.getValue(feature)));
    }

    public String getAsString(Feature object) {
        if ((object = this.getValue((Feature)((Object)object))) == null) {
            return null;
        }
        return String.valueOf(object);
    }
}

