/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.TransactionCompleted;
import org.infinispan.notifications.cachelistener.cluster.ClusterEvent;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventManager;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.TransactionCompletedEvent;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
@Listener(primaryOnly=true, observation=Listener.Observation.POST)
public class RemoteClusterListener {
    private static final Log log = LogFactory.getLog(RemoteClusterListener.class);
    private final UUID id;
    private final Address origin;
    private final CacheNotifier cacheNotifier;
    private final CacheManagerNotifier cacheManagerNotifier;
    private final ClusterEventManager eventManager;
    private final boolean sync;
    private final ConcurrentMap<GlobalTransaction, Queue<CacheEntryEvent>> transactionChanges = new ConcurrentHashMap<GlobalTransaction, Queue<CacheEntryEvent>>();

    public RemoteClusterListener(UUID id, Address origin, CacheNotifier cacheNotifier, CacheManagerNotifier cacheManagerNotifier, ClusterEventManager eventManager, boolean sync) {
        this.id = id;
        this.origin = origin;
        this.cacheNotifier = cacheNotifier;
        this.cacheManagerNotifier = cacheManagerNotifier;
        this.eventManager = eventManager;
        this.sync = sync;
    }

    public UUID getId() {
        return this.id;
    }

    public Address getOwnerAddress() {
        return this.origin;
    }

    @ViewChanged
    public CompletionStage<Void> viewChange(ViewChangedEvent event) {
        if (!event.getNewMembers().contains(this.origin)) {
            if (log.isTraceEnabled()) {
                log.tracef("Origin %s storing cluster listener is gone, removing local listener", this.origin);
            }
            return this.removeListener();
        }
        return CompletableFutures.completedNull();
    }

    public CompletionStage<Void> removeListener() {
        return CompletionStages.allOf(this.cacheNotifier.removeListenerAsync(this), this.cacheManagerNotifier.removeListenerAsync(this));
    }

    @CacheEntryCreated
    @CacheEntryModified
    @CacheEntryRemoved
    @CacheEntryExpired
    public CompletionStage<Void> handleClusterEvents(CacheEntryEvent event) {
        GlobalTransaction transaction = event.getGlobalTransaction();
        if (transaction != null) {
            Queue otherQueue;
            Queue events = (ConcurrentLinkedQueue<CacheEntryEvent>)this.transactionChanges.get(transaction);
            if (events == null && (otherQueue = (Queue)this.transactionChanges.putIfAbsent(transaction, events = new ConcurrentLinkedQueue<CacheEntryEvent>())) != null) {
                events = otherQueue;
            }
            events.add(event);
        } else {
            if (log.isTraceEnabled()) {
                log.tracef("Passing Event to manager %s to send to %s", event, this.origin);
            }
            this.eventManager.addEvents(Thread.currentThread(), this.origin, this.id, Collections.singleton(ClusterEvent.fromEvent(event)), this.sync);
        }
        return CompletableFutures.completedNull();
    }

    @TransactionCompleted
    public CompletionStage<Void> transactionCompleted(TransactionCompletedEvent event) {
        GlobalTransaction transaction = event.getGlobalTransaction();
        Queue events = (Queue)this.transactionChanges.remove(transaction);
        if (event.isTransactionSuccessful() && events != null) {
            ArrayList eventsToSend = new ArrayList(events.size());
            for (CacheEntryEvent cacheEvent : events) {
                eventsToSend.add(ClusterEvent.fromEvent(cacheEvent));
                if (!log.isTraceEnabled()) continue;
                log.tracef("Passing Event(s) to manager %s to send to %s", eventsToSend, this.origin);
            }
            this.eventManager.addEvents(transaction, this.origin, this.id, eventsToSend, this.sync);
        }
        return CompletableFutures.completedNull();
    }
}

