/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io.json;

import java.io.BufferedReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.configuration.io.AbstractConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationFormatFeature;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationReaderException;
import org.infinispan.commons.configuration.io.ConfigurationResourceResolver;
import org.infinispan.commons.configuration.io.Location;
import org.infinispan.commons.configuration.io.NamingStrategy;
import org.infinispan.commons.configuration.io.PropertyReplacer;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.util.SimpleImmutableEntry;
import org.infinispan.commons.util.Util;

public class JsonConfigurationReader
extends AbstractConfigurationReader {
    private static final String NAMESPACE = "_namespace";
    private final Deque<Iterator<?>> iteratorStack;
    private final Deque<String> nameStack;
    private final BufferedReader reader;
    private final List<Map.Entry<String, Json>> attributes = new ArrayList<Map.Entry<String, Json>>();
    private final String namespace;
    private String name;
    private Json element;
    private ConfigurationReader.ElementType type;

    public JsonConfigurationReader(BufferedReader reader, ConfigurationResourceResolver resourceResolver, Properties properties, PropertyReplacer replacer, NamingStrategy namingStrategy) {
        super(resourceResolver, properties, replacer, namingStrategy);
        this.reader = reader;
        try (Stream<String> lines = this.reader.lines();){
            Map<String, Json> json = Json.read(lines.collect(Collectors.joining())).asJsonMap();
            Json namespace = json.remove(NAMESPACE);
            this.namespace = namespace == null ? "" : namespace.asString();
            this.iteratorStack = new ArrayDeque();
            this.iteratorStack.push(json.entrySet().iterator());
            this.nameStack = new ArrayDeque<String>();
            this.type = ConfigurationReader.ElementType.START_DOCUMENT;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ConfigurationReader.ElementType nextElement() {
        Iterator<?> iterator = this.iteratorStack.peek();
        if (iterator == null) {
            return null;
        }
        if (iterator.hasNext()) {
            Object item = iterator.next();
            if (item instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)item;
                Json value = (Json)e.getValue();
                if (value.isPrimitive()) {
                    throw new IllegalStateException("Primitive attribute should have been detected as attribute: " + (String)e.getKey());
                }
                if (value.isObject()) {
                    this.processObject(value);
                } else if (value.isArray()) {
                    this.processArray((String)e.getKey(), value);
                } else if (value.isNull()) {
                    this.attributes.clear();
                    this.iteratorStack.push(Collections.emptyIterator());
                }
                this.name = (String)e.getKey();
                this.nameStack.push(this.name);
                this.type = ConfigurationReader.ElementType.START_ELEMENT;
                return this.type;
            }
            if (!(item instanceof ElementEntry)) throw new IllegalStateException(item.toString());
            ElementEntry entry = (ElementEntry)item;
            this.name = entry.k;
            this.type = entry.type;
            if (this.type == ConfigurationReader.ElementType.START_ELEMENT) {
                this.nameStack.push(this.name);
                this.element = entry.v;
                if (this.element.isObject()) {
                    this.processObject(this.element);
                    return this.type;
                } else {
                    if (!this.element.isArray()) throw new IllegalStateException("Element is neither an object nor an array: " + entry.k);
                    this.processArray(this.name, this.element);
                }
                return this.type;
            } else {
                this.nameStack.pop();
                this.iteratorStack.pop();
                this.element = null;
            }
            return this.type;
        }
        this.iteratorStack.pop();
        this.element = null;
        this.attributes.clear();
        if (this.nameStack.isEmpty()) {
            this.type = ConfigurationReader.ElementType.END_DOCUMENT;
            return this.type;
        }
        this.name = this.nameStack.pop();
        this.type = ConfigurationReader.ElementType.END_ELEMENT;
        return this.type;
    }

    private void processArray(String name, Json value) {
        boolean primitive;
        this.attributes.clear();
        List<Json> list = value.asJsonList();
        ArrayList<ElementEntry> array = new ArrayList<ElementEntry>(list.size() * 2 + 2);
        boolean bl = primitive = list.size() > 0 && list.get(0).isPrimitive();
        if (!primitive) {
            array.add(new ElementEntry(name, null, ConfigurationReader.ElementType.START_ELEMENT));
        }
        for (Json json : list) {
            array.add(new ElementEntry(name, json, ConfigurationReader.ElementType.START_ELEMENT));
        }
        if (!primitive) {
            array.add(new ElementEntry(name, null, ConfigurationReader.ElementType.END_ELEMENT));
        }
        Iterator it = array.iterator();
        this.iteratorStack.push(it);
        this.element = ((ElementEntry)it.next()).v;
    }

    private void processObject(Json value) {
        this.attributes.clear();
        Map<String, Json> map = value.asJsonMap();
        Iterator<Map.Entry<String, Json>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Json> entry = it.next();
            if (entry.getValue().isPrimitive()) {
                this.attributes.add(entry);
                it.remove();
                continue;
            }
            if (!this.isArrayOfPrimitives(entry.getValue())) continue;
            this.attributes.add(entry);
            it.remove();
        }
        this.iteratorStack.push(map.entrySet().iterator());
    }

    private boolean isArrayOfPrimitives(Json json) {
        if (json.isArray()) {
            List<Json> list = json.asJsonList();
            if (list.isEmpty()) {
                return false;
            }
            for (Json item : list) {
                if (item.isPrimitive()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Location getLocation() {
        return Location.of(1, 0);
    }

    @Override
    public String getAttributeName(int index, NamingStrategy strategy) {
        String name = this.attributes.get(index).getKey();
        return this.basename(strategy, name);
    }

    private String basename(NamingStrategy strategy, String name) {
        int colon = name.lastIndexOf(58);
        return strategy.convert(colon < 0 ? name : name.substring(colon + 1));
    }

    @Override
    public String getLocalName(NamingStrategy strategy) {
        return this.basename(strategy, this.name);
    }

    @Override
    public String getAttributeNamespace(int index) {
        String name = this.attributes.get(index).getKey();
        int colon = name.lastIndexOf(58);
        return colon < 0 ? "" : name.substring(0, colon);
    }

    @Override
    public String getAttributeValue(String name, NamingStrategy strategy) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            Map.Entry<String, Json> attribute = this.attributes.get(i);
            if (!name.equals(this.basename(strategy, attribute.getKey()))) continue;
            return attribute.getValue().asString();
        }
        return null;
    }

    @Override
    public String[] getListAttributeValue(int index) {
        Json value = this.attributes.get(index).getValue();
        if (value.isArray()) {
            List<Json> list = value.asJsonList();
            String[] array = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                array[i] = this.replaceProperties(list.get(i).asString());
            }
            return array;
        }
        return this.replaceProperties(value.isString() ? value.asString() : value.toString()).split("\\s+");
    }

    @Override
    public String getAttributeValue(int index) {
        Json value = this.attributes.get(index).getValue();
        return this.replaceProperties(value.isString() ? value.asString() : value.toString());
    }

    @Override
    public String getElementText() {
        String text = this.element != null && this.element.isPrimitive() ? this.element.asString() : null;
        this.nextElement();
        return text;
    }

    @Override
    public String getNamespace() {
        int colon = this.name.lastIndexOf(58);
        return colon < 0 ? this.namespace : this.name.substring(0, colon);
    }

    @Override
    public boolean hasNext() {
        return !this.iteratorStack.isEmpty();
    }

    @Override
    public int getAttributeCount() {
        return this.attributes.size();
    }

    @Override
    public void require(ConfigurationReader.ElementType type, String namespace, String name) {
        if (type != this.type || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getLocalName())) {
            throw new ConfigurationReaderException("Expected event " + (Object)((Object)type) + (name != null ? " with name '" + name + "'" : "") + (namespace != null && name != null ? " and" : "") + (namespace != null ? " with namespace '" + namespace + "'" : "") + " but got" + (type != this.type ? " " + (Object)((Object)this.type) : "") + (name != null && this.getLocalName() != null && !name.equals(this.getLocalName()) ? " name '" + this.getLocalName() + "'" : "") + (namespace != null && name != null && this.getLocalName() != null && !name.equals(this.getLocalName()) && this.getNamespace() != null && !namespace.equals(this.getNamespace()) ? " and" : "") + (namespace != null && this.getNamespace() != null && !namespace.equals(this.getNamespace()) ? " namespace '" + this.getNamespace() + "'" : ""), Location.of(1, 1));
        }
    }

    @Override
    public Map.Entry<String, String> getMapItem(String nameAttribute) {
        String name = this.getLocalName(NamingStrategy.IDENTITY);
        this.nextElement();
        String type = this.getLocalName();
        return new SimpleImmutableEntry<String, String>(name, type);
    }

    @Override
    public void endMapItem() {
        this.nextElement();
    }

    @Override
    public String[] readArray(String outer, String inner) {
        Iterator<?> iterator = this.iteratorStack.peek();
        ArrayList<String> array = new ArrayList<String>();
        while (iterator.hasNext()) {
            ElementEntry next = (ElementEntry)iterator.next();
            if (next.type != ConfigurationReader.ElementType.END_ELEMENT) continue;
            array.add(next.v.asString());
        }
        this.nextElement();
        this.require(ConfigurationReader.ElementType.END_ELEMENT, null, outer);
        return (String[])array.stream().toArray(String[]::new);
    }

    @Override
    public boolean hasFeature(ConfigurationFormatFeature feature) {
        return false;
    }

    @Override
    public void close() {
        Util.close((AutoCloseable)this.reader);
    }

    private static class ElementEntry {
        final String k;
        final Json v;
        final ConfigurationReader.ElementType type;

        ElementEntry(String k, Json v, ConfigurationReader.ElementType type) {
            this.k = k;
            this.v = v;
            this.type = type;
        }
    }
}

