/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.okhttp;

import com.openshift.internal.restclient.authorization.AuthorizationDetails;
import com.openshift.internal.restclient.okhttp.BasicChallengeHandler;
import com.openshift.internal.restclient.okhttp.OpenShiftRequestBuilder;
import com.openshift.internal.restclient.okhttp.ResponseCodeInterceptor;
import com.openshift.internal.util.URIUtils;
import com.openshift.restclient.IClient;
import com.openshift.restclient.authorization.IAuthorizationContext;
import com.openshift.restclient.authorization.IAuthorizationDetails;
import com.openshift.restclient.authorization.UnauthorizedException;
import com.openshift.restclient.http.IHttpConstants;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;

public class AuthenticatorInterceptor
implements Interceptor,
IHttpConstants {
    public static final String ACCESS_TOKEN = "access_token";
    private static final String CSRF_TOKEN = "X-CSRF-Token";
    private static final String ERROR = "error";
    private static final String ERROR_DETAILS = "error_details";
    private IClient client;

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String url = request.url().toString();
        if (AuthAttempHeader.isContainedIn(request.headers()) || this.isUrlWithoutAuthorization(url)) {
            return chain.proceed(request);
        }
        IAuthorizationContext authorizationContext = this.client.getAuthorizationContext();
        if (StringUtils.isBlank((String)authorizationContext.getToken())) {
            request = this.createAuthorizationRequest(request, url, authorizationContext);
        }
        return chain.proceed(request);
    }

    private Request createAuthorizationRequest(Request request, String url, IAuthorizationContext authorizationContext) throws IOException {
        try (Response authResponse = this.authenticate();){
            if (authResponse != null) {
                if (!authResponse.isSuccessful()) {
                    throw new UnauthorizedException(this.getAuthorizationDetails(url), ResponseCodeInterceptor.getStatus(authResponse.body().string()));
                }
                String token = this.getToken(authResponse);
                this.setToken(token, this.client.getAuthorizationContext());
                request = new OpenShiftRequestBuilder(request.newBuilder()).acceptJson().authorization(authorizationContext).build();
            }
            Request request2 = request;
            return request2;
        }
    }

    private boolean isUrlWithoutAuthorization(String url) {
        return url.endsWith("version/openshift") || url.endsWith("version") || url.endsWith("healthz") || url.endsWith(".well-known/oauth-authorization-server") || this.isAuthorizationEndpoint(url, this.client.getAuthorizationEndpoint());
    }

    private boolean isAuthorizationEndpoint(String url, URL authEndpoint) {
        return authEndpoint != null && url.startsWith(authEndpoint.toString());
    }

    private Response authenticate() throws IOException {
        OkHttpClient okClient = this.client.adapt(OkHttpClient.class);
        if (okClient == null) {
            return null;
        }
        URL endpoint = this.client.getAuthorizationEndpoint();
        if (endpoint == null) {
            return null;
        }
        Request authRequest = this.appendAuthorization(this.client.getAuthorizationContext(), new Request.Builder().addHeader(CSRF_TOKEN, "1").url(new URL(endpoint.toExternalForm() + "?response_type=token&client_id=openshift-challenging-client").toString()));
        return okClient.newBuilder().followRedirects(false).build().newCall(authRequest).execute();
    }

    private IAuthorizationDetails getAuthorizationDetails(String url) {
        AuthorizationDetails details = null;
        Map<String, String> pairs = URIUtils.splitFragment(url);
        if (pairs.containsKey(ERROR)) {
            details = new AuthorizationDetails(pairs.get(ERROR), pairs.get(ERROR_DETAILS));
        }
        return details;
    }

    private String getToken(Response response) {
        if (response == null) {
            return null;
        }
        String token = null;
        Map<String, String> pairs = URIUtils.splitFragment(response.header("Location"));
        if (pairs.containsKey(ACCESS_TOKEN)) {
            token = pairs.get(ACCESS_TOKEN);
        }
        return token;
    }

    private void setToken(String token, IAuthorizationContext authorizationContext) {
        if (authorizationContext != null) {
            authorizationContext.setToken(token);
        }
    }

    public void setClient(IClient client) {
        this.client = client;
    }

    private Request appendAuthorization(IAuthorizationContext context, Request.Builder builder) {
        AuthAttempHeader.add(builder);
        return new BasicChallengeHandler(context).handleChallenge(builder).build();
    }

    private static class AuthAttempHeader {
        private static final String AUTH_ATTEMPTS = "X-OPENSHIFT-AUTH-ATTEMPTS";

        private AuthAttempHeader() {
        }

        public static void add(Request.Builder builder) {
            builder.header(AUTH_ATTEMPTS, "1");
        }

        public static boolean isContainedIn(Headers headers) {
            return headers != null && headers.get(AUTH_ATTEMPTS) != null;
        }
    }
}

