/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URI;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.ExplainedVerificationException;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionContextResult;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.authentication.actiontoken.ActionTokenHandler;
import org.keycloak.authentication.actiontoken.DefaultActionToken;
import org.keycloak.authentication.actiontoken.ExplainedTokenVerificationException;
import org.keycloak.authentication.actiontoken.resetcred.ResetCredentialsActionTokenHandler;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Time;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.exceptions.TokenNotActiveException;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.DefaultActionTokenKey;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SingleUseObjectKeyModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.AuthenticationFlowResolver;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.SystemClientUtil;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.oidc.utils.OIDCResponseMode;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.LoginActionsServiceChecks;
import org.keycloak.services.resources.LoginActionsServiceException;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.SessionCodeChecks;
import org.keycloak.services.util.AuthenticationFlowURLHelper;
import org.keycloak.services.util.BrowserHistoryHelper;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.services.util.LocaleUtil;
import org.keycloak.sessions.AuthenticationSessionCompoundId;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class LoginActionsService {
    private static final Logger logger = Logger.getLogger(LoginActionsService.class);
    public static final String AUTHENTICATE_PATH = "authenticate";
    public static final String REGISTRATION_PATH = "registration";
    public static final String RESET_CREDENTIALS_PATH = "reset-credentials";
    public static final String REQUIRED_ACTION = "required-action";
    public static final String FIRST_BROKER_LOGIN_PATH = "first-broker-login";
    public static final String POST_BROKER_LOGIN_PATH = "post-broker-login";
    public static final String RESTART_PATH = "restart";
    public static final String FORWARDED_ERROR_MESSAGE_NOTE = "forwardedErrorMessage";
    public static final String SESSION_CODE = "session_code";
    public static final String AUTH_SESSION_ID = "auth_session_id";
    public static final String CANCEL_AIA = "cancel-aia";
    private RealmModel realm;
    @Context
    private HttpRequest request;
    @Context
    protected HttpHeaders headers;
    @Context
    private ClientConnection clientConnection;
    @Context
    protected Providers providers;
    @Context
    protected KeycloakSession session;
    private EventBuilder event;

    public static UriBuilder loginActionsBaseUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return LoginActionsService.loginActionsBaseUrl(baseUriBuilder);
    }

    public static UriBuilder authenticationFormProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "authenticateForm");
    }

    public static UriBuilder requiredActionProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "requiredActionPOST");
    }

    public static UriBuilder actionTokenProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "executeActionToken");
    }

    public static UriBuilder registrationFormProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "processRegister");
    }

    public static UriBuilder firstBrokerLoginProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "firstBrokerLoginGet");
    }

    public static UriBuilder postBrokerLoginProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "postBrokerLoginGet");
    }

    public static UriBuilder loginActionsBaseUrl(UriBuilder baseUriBuilder) {
        return baseUriBuilder.path(RealmsResource.class).path(RealmsResource.class, "getLoginActionsService");
    }

    public LoginActionsService(RealmModel realm, EventBuilder event) {
        this.realm = realm;
        this.event = event;
        CacheControlUtil.noBackButtonCacheControlHeader();
    }

    private boolean checkSsl() {
        if (this.session.getContext().getUri().getBaseUri().getScheme().equals("https")) {
            return true;
        }
        return !this.realm.getSslRequired().isRequired(this.clientConnection);
    }

    private SessionCodeChecks checksForCode(String authSessionId, String code, String execution, String clientId, String tabId, String flowPath) {
        SessionCodeChecks res = new SessionCodeChecks(this.realm, (UriInfo)this.session.getContext().getUri(), this.request, this.clientConnection, this.session, this.event, authSessionId, code, execution, clientId, tabId, flowPath);
        res.initialVerify();
        return res;
    }

    protected URI getLastExecutionUrl(String flowPath, String executionId, String clientId, String tabId) {
        return new AuthenticationFlowURLHelper(this.session, this.realm, (UriInfo)this.session.getContext().getUri()).getLastExecutionUrl(flowPath, executionId, clientId, tabId);
    }

    @Path(value="restart")
    @GET
    public Response restartSession(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId) {
        UserSessionModel userSession;
        this.event.event(EventType.RESTART_AUTHENTICATION);
        SessionCodeChecks checks = new SessionCodeChecks(this.realm, (UriInfo)this.session.getContext().getUri(), this.request, this.clientConnection, this.session, this.event, authSessionId, null, null, clientId, tabId, null);
        AuthenticationSessionModel authSession = checks.initialVerifyAuthSession();
        if (authSession == null) {
            return checks.getResponse();
        }
        String flowPath = authSession.getClientNote("APP_INITIATED_FLOW");
        if (flowPath == null) {
            flowPath = AUTHENTICATE_PATH;
        }
        if ((userSession = new AuthenticationSessionManager(this.session).getUserSession(authSession)) != null) {
            logger.debugf("Logout of user session %s when restarting flow during re-authentication", (Object)userSession.getId());
            AuthenticationManager.backchannelLogout(this.session, userSession, false);
        }
        AuthenticationProcessor.resetFlow(authSession, flowPath);
        URI redirectUri = this.getLastExecutionUrl(flowPath, null, authSession.getClient().getClientId(), tabId);
        logger.debugf("Flow restart requested. Redirecting to %s", (Object)redirectUri);
        return Response.status((Response.Status)Response.Status.FOUND).location(redirectUri).build();
    }

    @Path(value="authenticate")
    @GET
    public Response authenticate(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId) {
        this.event.event(EventType.LOGIN);
        SessionCodeChecks checks = this.checksForCode(authSessionId, code, execution, clientId, tabId, AUTHENTICATE_PATH);
        if (!checks.verifyActiveAndValidAction(CommonClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
            return checks.getResponse();
        }
        AuthenticationSessionModel authSession = checks.getAuthenticationSession();
        boolean actionRequest = checks.isActionRequest();
        this.processLocaleParam(authSession);
        return this.processAuthentication(actionRequest, execution, authSession, null);
    }

    protected void processLocaleParam(AuthenticationSessionModel authSession) {
        LocaleUtil.processLocaleParam(this.session, this.realm, authSession);
    }

    protected Response processAuthentication(boolean action, String execution, AuthenticationSessionModel authSession, String errorMessage) {
        return this.processFlow(action, execution, authSession, AUTHENTICATE_PATH, AuthenticationFlowResolver.resolveBrowserFlow((AuthenticationSessionModel)authSession), errorMessage, new AuthenticationProcessor());
    }

    protected Response processFlow(boolean action, String execution, AuthenticationSessionModel authSession, String flowPath, AuthenticationFlowModel flow, String errorMessage, AuthenticationProcessor processor) {
        Response response;
        String forwardedErrorMessage;
        processor.setAuthenticationSession(authSession).setFlowPath(flowPath).setBrowserFlow(true).setFlowId(flow.getId()).setConnection(this.clientConnection).setEventBuilder(this.event).setRealm(this.realm).setSession(this.session).setUriInfo((UriInfo)this.session.getContext().getUri()).setRequest(this.request);
        if (errorMessage != null) {
            processor.setForwardedErrorMessage(new FormMessage(null, errorMessage));
        }
        if ((forwardedErrorMessage = authSession.getAuthNote(FORWARDED_ERROR_MESSAGE_NOTE)) != null) {
            authSession.removeAuthNote(FORWARDED_ERROR_MESSAGE_NOTE);
            processor.setForwardedErrorMessage(new FormMessage(null, forwardedErrorMessage));
        }
        try {
            response = action ? processor.authenticationAction(execution) : processor.authenticate();
        }
        catch (WebApplicationException e) {
            response = e.getResponse();
            authSession = processor.getAuthenticationSession();
        }
        catch (Exception e) {
            response = processor.handleBrowserException(e);
            authSession = processor.getAuthenticationSession();
        }
        return BrowserHistoryHelper.getInstance().saveResponseAndRedirect(this.session, authSession, response, action, this.request);
    }

    @Path(value="authenticate")
    @POST
    public Response authenticateForm(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId) {
        return this.authenticate(authSessionId, code, execution, clientId, tabId);
    }

    @Path(value="reset-credentials")
    @POST
    public Response resetCredentialsPOST(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId, @QueryParam(value="key") String key) {
        if (key != null) {
            return this.handleActionToken(key, execution, clientId, tabId);
        }
        this.event.event(EventType.RESET_PASSWORD);
        return this.resetCredentials(authSessionId, code, execution, clientId, tabId);
    }

    @Path(value="reset-credentials")
    @GET
    public Response resetCredentialsGET(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId) {
        ClientModel client = this.realm.getClientByClientId(clientId);
        AuthenticationSessionModel authSession = new AuthenticationSessionManager(this.session).getCurrentAuthenticationSession(this.realm, client, tabId);
        this.processLocaleParam(authSession);
        if (authSession == null && code == null) {
            if (!this.realm.isResetPasswordAllowed()) {
                this.event.event(EventType.RESET_PASSWORD);
                this.event.error("not_allowed");
                return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "resetCredentialNotAllowedMessage", new Object[0]);
            }
            authSession = this.createAuthenticationSessionForClient(clientId);
            return this.processResetCredentials(false, null, authSession, null);
        }
        this.event.event(EventType.RESET_PASSWORD);
        return this.resetCredentials(authSessionId, code, execution, clientId, tabId);
    }

    AuthenticationSessionModel createAuthenticationSessionForClient(String clientID) throws UriBuilderException, IllegalArgumentException {
        String redirectUri;
        ClientModel client = this.session.clients().getClientByClientId(this.realm, clientID);
        if (client == null) {
            client = SystemClientUtil.getSystemClient((RealmModel)this.realm);
            redirectUri = Urls.accountBase(this.session.getContext().getUri().getBaseUri()).path("/").build(new Object[]{this.realm.getName()}).toString();
        } else {
            redirectUri = RedirectUtils.getFirstValidRedirectUri(this.session, client.getRootUrl(), client.getRedirectUris());
        }
        RootAuthenticationSessionModel rootAuthSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, true);
        AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(client);
        authSession.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
        authSession.setProtocol("openid-connect");
        authSession.setRedirectUri(redirectUri);
        authSession.setClientNote("response_type", "code");
        authSession.setClientNote("redirect_uri", redirectUri);
        authSession.setClientNote("iss", Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
        return authSession;
    }

    protected Response resetCredentials(String authSessionId, String code, String execution, String clientId, String tabId) {
        SessionCodeChecks checks = this.checksForCode(authSessionId, code, execution, clientId, tabId, RESET_CREDENTIALS_PATH);
        if (!checks.verifyActiveAndValidAction(CommonClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.USER)) {
            return checks.getResponse();
        }
        AuthenticationSessionModel authSession = checks.getAuthenticationSession();
        if (!this.realm.isResetPasswordAllowed()) {
            this.event.error("not_allowed");
            return ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, "resetCredentialNotAllowedMessage", new Object[0]);
        }
        return this.processResetCredentials(checks.isActionRequest(), execution, authSession, null);
    }

    @Path(value="action-token")
    @GET
    public Response executeActionToken(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="key") String key, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId) {
        return this.handleActionToken(key, execution, clientId, tabId);
    }

    protected <T extends JsonWebToken> Response handleActionToken(String tokenString, String execution, String clientId, String tabId) {
        JsonWebToken token;
        ActionTokenHandler<Object> handler;
        String eventError = null;
        String defaultErrorMessage = null;
        AuthenticationSessionModel authSession = null;
        ClientModel client = null;
        if (clientId != null) {
            client = this.realm.getClientByClientId(clientId);
        }
        AuthenticationSessionManager authenticationSessionManager = new AuthenticationSessionManager(this.session);
        if (client != null) {
            this.session.getContext().setClient(client);
            authSession = authenticationSessionManager.getCurrentAuthenticationSession(this.realm, client, tabId);
        }
        this.event.event(EventType.EXECUTE_ACTION_TOKEN);
        try {
            if (tokenString == null) {
                throw new ExplainedTokenVerificationException(null, "not_allowed", "invalidRequestMessage");
            }
            TokenVerifier tokenVerifier = TokenVerifier.create((String)tokenString, DefaultActionTokenKey.class);
            DefaultActionTokenKey aToken = (DefaultActionTokenKey)tokenVerifier.getToken();
            this.event.detail("token_id", aToken.getId()).detail("action", aToken.getActionId()).user(aToken.getUserId());
            handler = this.resolveActionTokenHandler(aToken.getActionId());
            eventError = handler.getDefaultEventError();
            defaultErrorMessage = handler.getDefaultErrorMessage();
            if (!this.realm.isEnabled()) {
                throw new ExplainedTokenVerificationException((JsonWebToken)aToken, "realm_disabled", "realmNotEnabledMessage");
            }
            if (!this.checkSsl()) {
                throw new ExplainedTokenVerificationException((JsonWebToken)aToken, "ssl_required", "httpsRequiredMessage");
            }
            TokenVerifier verifier = tokenVerifier.withChecks(new TokenVerifier.Predicate[]{TokenVerifier.IS_ACTIVE, new TokenVerifier.RealmUrlCheck(Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName())), DefaultActionToken.ACTION_TOKEN_BASIC_CHECKS});
            String kid = verifier.getHeader().getKeyId();
            String algorithm = verifier.getHeader().getAlgorithm().name();
            SignatureVerifierContext signatureVerifier = ((SignatureProvider)this.session.getProvider(SignatureProvider.class, algorithm)).verifier(kid);
            verifier.verifierContext(signatureVerifier);
            verifier.verify();
            token = TokenVerifier.create((String)tokenString, handler.getTokenClass()).getToken();
        }
        catch (TokenNotActiveException ex) {
            if (authSession != null) {
                this.event.clone().error("expired_code");
                String flowPath = authSession.getClientNote("APP_INITIATED_FLOW");
                if (flowPath == null) {
                    flowPath = AUTHENTICATE_PATH;
                }
                AuthenticationProcessor.resetFlow(authSession, flowPath);
                return this.processFlowFromPath(flowPath, authSession, "expiredActionTokenSessionExistsMessage");
            }
            return this.handleActionTokenVerificationException(null, (VerificationException)((Object)ex), "expired_code", "expiredActionTokenNoSessionMessage");
        }
        catch (ExplainedTokenVerificationException ex) {
            return this.handleActionTokenVerificationException(null, (VerificationException)((Object)ex), ex.getErrorEvent(), ex.getMessage());
        }
        catch (ExplainedVerificationException ex) {
            return this.handleActionTokenVerificationException(null, ex, ex.getErrorEvent(), ex.getMessage());
        }
        catch (VerificationException ex) {
            return this.handleActionTokenVerificationException(null, ex, eventError, defaultErrorMessage);
        }
        ActionTokenContext<T> tokenContext = new ActionTokenContext<T>(this.session, this.realm, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.request, this.event, handler, execution, this::processFlow, this::brokerLoginFlow);
        try {
            String tokenAuthSessionCompoundId = handler.getAuthenticationSessionIdFromToken(token, tokenContext, authSession);
            if (tokenAuthSessionCompoundId != null) {
                String sessionId = AuthenticationSessionCompoundId.encoded((String)tokenAuthSessionCompoundId).getRootSessionId();
                LoginActionsServiceChecks.checkNotLoggedInYet(tokenContext, authSession, sessionId);
            }
            if (authSession == null) {
                authSession = handler.startFreshAuthenticationSession(token, tokenContext);
                tokenContext.setAuthenticationSession(authSession, true);
            } else if (tokenAuthSessionCompoundId == null || !LoginActionsServiceChecks.doesAuthenticationSessionFromCookieMatchOneFromToken(tokenContext, authSession, tokenAuthSessionCompoundId)) {
                logger.debugf("Authentication session in progress but no authentication session ID was found in action token %s, restarting.", (Object)token.getId());
                authenticationSessionManager.removeAuthenticationSession(this.realm, authSession, false);
                authSession = handler.startFreshAuthenticationSession(token, tokenContext);
                tokenContext.setAuthenticationSession(authSession, true);
                this.processLocaleParam(authSession);
            }
            this.initLoginEvent(authSession);
            this.event.event(handler.eventType());
            LoginActionsServiceChecks.checkIsUserValid(token, tokenContext);
            LoginActionsServiceChecks.checkIsClientValid(token, tokenContext);
            this.session.getContext().setClient(authSession.getClient());
            TokenVerifier.createWithoutSignature((JsonWebToken)token).withChecks(handler.getVerifiers(tokenContext)).verify();
            authSession = tokenContext.getAuthenticationSession();
            this.event = tokenContext.getEvent();
            this.event.event(handler.eventType());
            if (!handler.canUseTokenRepeatedly(token, tokenContext)) {
                LoginActionsServiceChecks.checkTokenWasNotUsedYet(token, tokenContext);
                authSession.setAuthNote("INVALIDATE_ACTION_TOKEN", ((SingleUseObjectKeyModel)token).serializeKey());
            }
            authSession.setAuthNote("ACTION_TOKEN_USER", ((SingleUseObjectKeyModel)token).getUserId());
            authSession.setAuthNote("key", tokenString);
            return handler.handleToken(token, tokenContext);
        }
        catch (ExplainedTokenVerificationException ex) {
            return this.handleActionTokenVerificationException(tokenContext, (VerificationException)((Object)ex), ex.getErrorEvent(), ex.getMessage());
        }
        catch (LoginActionsServiceException ex) {
            Response response = ex.getResponse();
            return response == null ? this.handleActionTokenVerificationException(tokenContext, ex, eventError, defaultErrorMessage) : response;
        }
        catch (VerificationException ex) {
            return this.handleActionTokenVerificationException(tokenContext, ex, eventError, defaultErrorMessage);
        }
    }

    private Response processFlowFromPath(String flowPath, AuthenticationSessionModel authSession, String errorMessage) {
        if (AUTHENTICATE_PATH.equals(flowPath)) {
            return this.processAuthentication(false, null, authSession, errorMessage);
        }
        if (REGISTRATION_PATH.equals(flowPath)) {
            return this.processRegistration(false, null, authSession, errorMessage);
        }
        if (RESET_CREDENTIALS_PATH.equals(flowPath)) {
            return this.processResetCredentials(false, null, authSession, errorMessage);
        }
        return ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, errorMessage == null ? "invalidRequestMessage" : errorMessage, new Object[0]);
    }

    private <T extends JsonWebToken> ActionTokenHandler<T> resolveActionTokenHandler(String actionId) throws VerificationException {
        if (actionId == null) {
            throw new VerificationException("Action token operation not set");
        }
        ActionTokenHandler handler = (ActionTokenHandler)this.session.getProvider(ActionTokenHandler.class, actionId);
        if (handler == null) {
            throw new VerificationException("Invalid action token operation");
        }
        return handler;
    }

    private Response handleActionTokenVerificationException(ActionTokenContext<?> tokenContext, VerificationException ex, String eventError, String errorMessage) {
        if (tokenContext != null && tokenContext.getAuthenticationSession() != null) {
            new AuthenticationSessionManager(this.session).removeAuthenticationSession(this.realm, tokenContext.getAuthenticationSession(), true);
        }
        this.event.detail("reason", ex == null ? "<unknown>" : ex.getMessage()).error(eventError == null ? "invalid_code" : eventError);
        return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, errorMessage == null ? "invalidCodeMessage" : errorMessage, new Object[0]);
    }

    protected Response processResetCredentials(boolean actionRequest, String execution, AuthenticationSessionModel authSession, String errorMessage) {
        ResetCredentialsActionTokenHandler.ResetCredsAuthenticationProcessor authProcessor = new ResetCredentialsActionTokenHandler.ResetCredsAuthenticationProcessor();
        return this.processFlow(actionRequest, execution, authSession, RESET_CREDENTIALS_PATH, this.realm.getResetCredentialsFlow(), errorMessage, authProcessor);
    }

    protected Response processRegistration(boolean action, String execution, AuthenticationSessionModel authSession, String errorMessage) {
        return this.processFlow(action, execution, authSession, REGISTRATION_PATH, this.realm.getRegistrationFlow(), errorMessage, new AuthenticationProcessor());
    }

    @Path(value="registration")
    @GET
    public Response registerPage(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId) {
        return this.registerRequest(authSessionId, code, execution, clientId, tabId, false);
    }

    @Path(value="registration")
    @POST
    public Response processRegister(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId) {
        return this.registerRequest(authSessionId, code, execution, clientId, tabId, true);
    }

    private Response registerRequest(String authSessionId, String code, String execution, String clientId, String tabId, boolean isPostRequest) {
        this.event.event(EventType.REGISTER);
        if (!this.realm.isRegistrationAllowed()) {
            this.event.error("registration_disabled");
            return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "registrationNotAllowedMessage", new Object[0]);
        }
        SessionCodeChecks checks = this.checksForCode(authSessionId, code, execution, clientId, tabId, REGISTRATION_PATH);
        if (!checks.verifyActiveAndValidAction(CommonClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
            return checks.getResponse();
        }
        AuthenticationSessionModel authSession = checks.getAuthenticationSession();
        this.processLocaleParam(authSession);
        AuthenticationManager.expireIdentityCookie(this.realm, (UriInfo)this.session.getContext().getUri(), this.clientConnection);
        return this.processRegistration(checks.isActionRequest(), execution, authSession, null);
    }

    @Path(value="first-broker-login")
    @GET
    public Response firstBrokerLoginGet(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId) {
        return this.brokerLoginFlow(authSessionId, code, execution, clientId, tabId, FIRST_BROKER_LOGIN_PATH);
    }

    @Path(value="first-broker-login")
    @POST
    public Response firstBrokerLoginPost(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId) {
        return this.brokerLoginFlow(authSessionId, code, execution, clientId, tabId, FIRST_BROKER_LOGIN_PATH);
    }

    @Path(value="post-broker-login")
    @GET
    public Response postBrokerLoginGet(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId) {
        return this.brokerLoginFlow(authSessionId, code, execution, clientId, tabId, POST_BROKER_LOGIN_PATH);
    }

    @Path(value="post-broker-login")
    @POST
    public Response postBrokerLoginPost(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId) {
        return this.brokerLoginFlow(authSessionId, code, execution, clientId, tabId, POST_BROKER_LOGIN_PATH);
    }

    protected Response brokerLoginFlow(String authSessionId, String code, String execution, String clientId, String tabId, String flowPath) {
        String flowId;
        final boolean firstBrokerLogin = flowPath.equals(FIRST_BROKER_LOGIN_PATH);
        EventType eventType = firstBrokerLogin ? EventType.IDENTITY_PROVIDER_FIRST_LOGIN : EventType.IDENTITY_PROVIDER_POST_LOGIN;
        this.event.event(eventType);
        SessionCodeChecks checks = this.checksForCode(authSessionId, code, execution, clientId, tabId, flowPath);
        if (!checks.verifyActiveAndValidAction(CommonClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
            return checks.getResponse();
        }
        this.event.detail("code_id", code);
        final AuthenticationSessionModel authSession = checks.getAuthenticationSession();
        this.processLocaleParam(authSession);
        String noteKey = firstBrokerLogin ? "BROKERED_CONTEXT" : "PBL_BROKERED_IDENTITY_CONTEXT";
        SerializedBrokeredIdentityContext serializedCtx = SerializedBrokeredIdentityContext.readFromAuthenticationSession(authSession, noteKey);
        if (serializedCtx == null) {
            ServicesLogger.LOGGER.notFoundSerializedCtxInClientSession(noteKey);
            throw new WebApplicationException(ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, "Not found serialized context in authenticationSession.", new Object[0]));
        }
        BrokeredIdentityContext brokerContext = serializedCtx.deserialize(this.session, authSession);
        final String identityProviderAlias = brokerContext.getIdpConfig().getAlias();
        String string = flowId = firstBrokerLogin ? brokerContext.getIdpConfig().getFirstBrokerLoginFlowId() : brokerContext.getIdpConfig().getPostBrokerLoginFlowId();
        if (flowId == null) {
            ServicesLogger.LOGGER.flowNotConfigForIDP(identityProviderAlias);
            throw new WebApplicationException(ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, "Flow not configured for identity provider", new Object[0]));
        }
        AuthenticationFlowModel brokerLoginFlow = this.realm.getAuthenticationFlowById(flowId);
        if (brokerLoginFlow == null) {
            ServicesLogger.LOGGER.flowNotFoundForIDP(flowId, identityProviderAlias);
            throw new WebApplicationException(ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, "Flow not found for identity provider", new Object[0]));
        }
        this.event.detail("identity_provider", identityProviderAlias).detail("identity_provider_identity", brokerContext.getUsername());
        AuthenticationProcessor processor = new AuthenticationProcessor(){

            @Override
            public Response authenticateOnly() throws AuthenticationFlowException {
                Response challenge = super.authenticateOnly();
                if (challenge != null && "true".equals(this.authenticationSession.getAuthNote("forwarded.passive.login"))) {
                    logger.errorf("Challenge encountered when executing %s flow. Auth requests with prompt=none are incompatible with challenges", (Object)this.flowPath);
                    LoginProtocol protocol = (LoginProtocol)this.session.getProvider(LoginProtocol.class, authSession.getProtocol());
                    protocol.setRealm(this.realm).setHttpHeaders(LoginActionsService.this.headers).setUriInfo((UriInfo)this.session.getContext().getUri()).setEventBuilder(this.event);
                    return protocol.sendError(authSession, LoginProtocol.Error.PASSIVE_INTERACTION_REQUIRED);
                }
                return challenge;
            }

            @Override
            protected Response authenticationComplete() {
                if (firstBrokerLogin) {
                    authSession.setAuthNote("FIRST_BROKER_LOGIN_SUCCESS", identityProviderAlias);
                } else {
                    String authStateNoteKey = "PBL_AUTH_STATE." + identityProviderAlias;
                    authSession.setAuthNote(authStateNoteKey, "true");
                }
                return LoginActionsService.this.redirectToAfterBrokerLoginEndpoint(authSession, firstBrokerLogin);
            }
        };
        return this.processFlow(checks.isActionRequest(), execution, authSession, flowPath, brokerLoginFlow, null, processor);
    }

    private Response redirectToAfterBrokerLoginEndpoint(AuthenticationSessionModel authSession, boolean firstBrokerLogin) {
        return LoginActionsService.redirectToAfterBrokerLoginEndpoint(this.session, this.realm, (UriInfo)this.session.getContext().getUri(), authSession, firstBrokerLogin);
    }

    public static Response redirectToAfterBrokerLoginEndpoint(KeycloakSession session, RealmModel realm, UriInfo uriInfo, AuthenticationSessionModel authSession, boolean firstBrokerLogin) {
        ClientSessionCode<AuthenticationSessionModel> accessCode = new ClientSessionCode<AuthenticationSessionModel>(session, realm, authSession);
        authSession.getParentSession().setTimestamp(Time.currentTime());
        String clientId = authSession.getClient().getClientId();
        String tabId = authSession.getTabId();
        URI redirect = firstBrokerLogin ? Urls.identityProviderAfterFirstBrokerLogin(uriInfo.getBaseUri(), realm.getName(), accessCode.getOrGenerateCode(), clientId, tabId) : Urls.identityProviderAfterPostBrokerLogin(uriInfo.getBaseUri(), realm.getName(), accessCode.getOrGenerateCode(), clientId, tabId);
        logger.debugf("Redirecting to '%s' ", (Object)redirect);
        return Response.status((int)302).location(redirect).build();
    }

    @Path(value="consent")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processConsent() {
        MultivaluedMap formData = this.request.getDecodedFormParameters();
        this.event.event(EventType.LOGIN);
        String code = (String)formData.getFirst((Object)SESSION_CODE);
        String clientId = (String)this.session.getContext().getUri().getQueryParameters().getFirst((Object)"client_id");
        String tabId = (String)this.session.getContext().getUri().getQueryParameters().getFirst((Object)"tab_id");
        SessionCodeChecks checks = this.checksForCode(null, code, null, clientId, tabId, REQUIRED_ACTION);
        if (!checks.verifyRequiredAction(CommonClientSessionModel.Action.OAUTH_GRANT.name())) {
            return checks.getResponse();
        }
        AuthenticationSessionModel authSession = checks.getAuthenticationSession();
        this.initLoginEvent(authSession);
        UserModel user = authSession.getAuthenticatedUser();
        ClientModel client = authSession.getClient();
        if (formData.containsKey((Object)"cancel")) {
            LoginProtocol protocol = (LoginProtocol)this.session.getProvider(LoginProtocol.class, authSession.getProtocol());
            protocol.setRealm(this.realm).setHttpHeaders(this.headers).setUriInfo((UriInfo)this.session.getContext().getUri()).setEventBuilder(this.event);
            Response response = protocol.sendError(authSession, LoginProtocol.Error.CONSENT_DENIED);
            this.event.error("rejected_by_user");
            return response;
        }
        UserConsentModel grantedConsent = this.session.users().getConsentByClient(this.realm, user.getId(), client.getId());
        if (grantedConsent == null) {
            grantedConsent = new UserConsentModel(client);
            this.session.users().addConsent(this.realm, user.getId(), grantedConsent);
        }
        boolean updateConsentRequired = false;
        for (String clientScopeId : authSession.getClientScopes()) {
            ClientScopeModel clientScope = KeycloakModelUtils.findClientScopeById((RealmModel)this.realm, (ClientModel)client, (String)clientScopeId);
            if (clientScope != null) {
                if (grantedConsent.isClientScopeGranted(clientScope) || !clientScope.isDisplayOnConsentScreen()) continue;
                grantedConsent.addGrantedClientScope(clientScope);
                updateConsentRequired = true;
                continue;
            }
            logger.warnf("Client scope or client with ID '%s' not found", (Object)clientScopeId);
        }
        if (updateConsentRequired) {
            this.session.users().updateConsent(this.realm, user.getId(), grantedConsent);
        }
        this.event.detail("consent", "consent_granted");
        this.event.success();
        ClientSessionContext clientSessionCtx = AuthenticationProcessor.attachSession(authSession, null, this.session, this.realm, this.clientConnection, this.event);
        return AuthenticationManager.redirectAfterSuccessfulFlow(this.session, this.realm, clientSessionCtx.getClientSession().getUserSession(), clientSessionCtx, this.request, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.event, authSession);
    }

    private void initLoginEvent(AuthenticationSessionModel authSession) {
        String rememberMe;
        String attemptedUsername;
        String responseType = authSession.getClientNote("response_type");
        if (responseType == null) {
            responseType = "code";
        }
        String respMode = authSession.getClientNote("response_mode");
        OIDCResponseMode responseMode = OIDCResponseMode.parse(respMode, OIDCResponseType.parse(responseType));
        this.event.event(EventType.LOGIN).client(authSession.getClient()).detail("code_id", authSession.getParentSession().getId()).detail("redirect_uri", authSession.getRedirectUri()).detail("auth_method", authSession.getProtocol()).detail("response_type", responseType).detail("response_mode", responseMode.toString().toLowerCase());
        UserModel authenticatedUser = authSession.getAuthenticatedUser();
        if (authenticatedUser != null) {
            this.event.user(authenticatedUser).detail("username", authenticatedUser.getUsername());
        }
        if ((attemptedUsername = authSession.getAuthNote("ATTEMPTED_USERNAME")) != null) {
            this.event.detail("username", attemptedUsername);
        }
        if ((rememberMe = authSession.getAuthNote("remember_me")) == null || !rememberMe.equalsIgnoreCase("true")) {
            rememberMe = "false";
        }
        this.event.detail("remember_me", rememberMe);
        Map userSessionNotes = authSession.getUserSessionNotes();
        String identityProvider = (String)userSessionNotes.get("identity_provider");
        if (identityProvider != null) {
            this.event.detail("identity_provider", identityProvider).detail("identity_provider_identity", (String)userSessionNotes.get("identity_provider_identity"));
        }
    }

    @Path(value="required-action")
    @POST
    public Response requiredActionPOST(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String action, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId) {
        return this.processRequireAction(authSessionId, code, action, clientId, tabId);
    }

    @Path(value="required-action")
    @GET
    public Response requiredActionGET(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String action, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId) {
        return this.processRequireAction(authSessionId, code, action, clientId, tabId);
    }

    private Response processRequireAction(String authSessionId, String code, String action, String clientId, String tabId) {
        Response response;
        this.event.event(EventType.CUSTOM_REQUIRED_ACTION);
        SessionCodeChecks checks = this.checksForCode(authSessionId, code, action, clientId, tabId, REQUIRED_ACTION);
        if (!checks.verifyRequiredAction(action)) {
            return checks.getResponse();
        }
        AuthenticationSessionModel authSession = checks.getAuthenticationSession();
        this.processLocaleParam(authSession);
        if (!checks.isActionRequest()) {
            this.initLoginEvent(authSession);
            this.event.event(EventType.CUSTOM_REQUIRED_ACTION);
            return AuthenticationManager.nextActionAfterAuthentication(this.session, authSession, this.clientConnection, this.request, (UriInfo)this.session.getContext().getUri(), this.event);
        }
        this.initLoginEvent(authSession);
        this.event.event(EventType.CUSTOM_REQUIRED_ACTION);
        this.event.detail("custom_required_action", action);
        RequiredActionFactory factory = (RequiredActionFactory)this.session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, action);
        if (factory == null) {
            ServicesLogger.LOGGER.actionProviderNull();
            this.event.error("invalid_code");
            throw new WebApplicationException(ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, "invalidCodeMessage", new Object[0]));
        }
        RequiredActionContextResult context = new RequiredActionContextResult(authSession, this.realm, this.event, this.session, this.request, authSession.getAuthenticatedUser(), factory){

            @Override
            public void ignore() {
                throw new RuntimeException("Cannot call ignore within processAction()");
            }
        };
        RequiredActionProvider provider = null;
        try {
            provider = AuthenticationManager.createRequiredAction(context);
        }
        catch (AuthenticationFlowException e) {
            if (e.getResponse() != null) {
                return e.getResponse();
            }
            throw new WebApplicationException(ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, "displayUnsupported", new Object[0]));
        }
        if (this.isCancelAppInitiatedAction(factory.getId(), authSession, context)) {
            provider.initiatedActionCanceled(this.session, authSession);
            AuthenticationManager.setKcActionStatus(factory.getId(), RequiredActionContext.KcActionStatus.CANCELLED, authSession);
            context.success();
        } else {
            provider.processAction((RequiredActionContext)context);
        }
        if (action != null) {
            authSession.setAuthNote("last.processed.execution", action);
        }
        if (context.getStatus() == RequiredActionContext.Status.SUCCESS) {
            this.event.clone().success();
            this.initLoginEvent(authSession);
            this.event.event(EventType.LOGIN);
            authSession.removeRequiredAction(factory.getId());
            authSession.getAuthenticatedUser().removeRequiredAction(factory.getId());
            authSession.removeAuthNote("current.authentication.execution");
            AuthenticationManager.setKcActionStatus(factory.getId(), RequiredActionContext.KcActionStatus.SUCCESS, authSession);
            response = AuthenticationManager.nextActionAfterAuthentication(this.session, authSession, this.clientConnection, this.request, (UriInfo)this.session.getContext().getUri(), this.event);
        } else if (context.getStatus() == RequiredActionContext.Status.CHALLENGE) {
            response = context.getChallenge();
        } else if (context.getStatus() == RequiredActionContext.Status.FAILURE) {
            response = this.interruptionResponse(context, authSession, action, LoginProtocol.Error.CONSENT_DENIED);
        } else {
            throw new RuntimeException("Unreachable");
        }
        return BrowserHistoryHelper.getInstance().saveResponseAndRedirect(this.session, authSession, response, true, this.request);
    }

    private Response interruptionResponse(RequiredActionContextResult context, AuthenticationSessionModel authSession, String action, LoginProtocol.Error error) {
        LoginProtocol protocol = (LoginProtocol)context.getSession().getProvider(LoginProtocol.class, authSession.getProtocol());
        protocol.setRealm(context.getRealm()).setHttpHeaders(context.getHttpRequest().getHttpHeaders()).setUriInfo(context.getUriInfo()).setEventBuilder(this.event);
        this.event.detail("custom_required_action", action);
        this.event.error("rejected_by_user");
        return protocol.sendError(authSession, error);
    }

    private boolean isCancelAppInitiatedAction(String providerId, AuthenticationSessionModel authSession, RequiredActionContextResult context) {
        if (providerId.equals(authSession.getClientNote("kc_action_executing"))) {
            MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
            boolean userRequestedCancelAIA = formData.getFirst((Object)CANCEL_AIA) != null;
            return userRequestedCancelAIA;
        }
        return false;
    }
}

