/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderEventManager;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ProviderManagerDeployer;
import org.keycloak.provider.ProviderManagerRegistry;
import org.keycloak.provider.Spi;
import org.keycloak.quarkus.runtime.themes.QuarkusJarThemeProviderFactory;
import org.keycloak.services.DefaultKeycloakSessionFactory;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.theme.ClasspathThemeProviderFactory;

public final class QuarkusKeycloakSessionFactory
extends DefaultKeycloakSessionFactory {
    private static QuarkusKeycloakSessionFactory INSTANCE;
    private final Boolean reaugmented;
    private final Map<Spi, Map<Class<? extends Provider>, Map<String, Class<? extends ProviderFactory>>>> factories;
    private Map<String, ProviderFactory> preConfiguredProviders;

    public static QuarkusKeycloakSessionFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new QuarkusKeycloakSessionFactory();
        }
        return INSTANCE;
    }

    public static void setInstance(QuarkusKeycloakSessionFactory instance) {
        INSTANCE = instance;
    }

    public QuarkusKeycloakSessionFactory(Map<Spi, Map<Class<? extends Provider>, Map<String, Class<? extends ProviderFactory>>>> factories, Map<Class<? extends Provider>, String> defaultProviders, Map<String, ProviderFactory> preConfiguredProviders, List<ClasspathThemeProviderFactory.ThemesRepresentation> themes, Boolean reaugmented) {
        this.provider = defaultProviders;
        this.factories = factories;
        this.preConfiguredProviders = preConfiguredProviders;
        this.reaugmented = reaugmented;
        this.serverStartupTimestamp = System.currentTimeMillis();
        this.spis = factories.keySet();
        for (Spi spi : this.spis) {
            for (Map<String, Class<? extends ProviderFactory>> factoryClazz : factories.get(spi).values()) {
                for (Map.Entry<String, Class<? extends ProviderFactory>> entry : factoryClazz.entrySet()) {
                    ProviderFactory factory = preConfiguredProviders.get(entry.getKey());
                    if (factory == null) {
                        factory = this.lookupProviderFactory(entry.getValue());
                    }
                    if (factory instanceof QuarkusJarThemeProviderFactory) {
                        ((QuarkusJarThemeProviderFactory)factory).setThemes(themes);
                    }
                    Config.Scope scope = Config.scope((String[])new String[]{spi.getName(), factory.getId()});
                    factory.init(scope);
                    this.factoriesMap.computeIfAbsent(spi.getProviderClass(), k -> new HashMap()).put(factory.getId(), factory);
                }
            }
        }
    }

    private QuarkusKeycloakSessionFactory() {
        this.reaugmented = false;
        this.factories = Collections.emptyMap();
    }

    public void init() {
        this.updateComponentFactoryProviderFactory();
        if (this.componentFactoryPF != null) {
            this.componentFactoryPF.postInit((KeycloakSessionFactory)this);
        }
        for (Map f : this.factoriesMap.values()) {
            for (ProviderFactory factory : f.values()) {
                if (factory == this.componentFactoryPF) continue;
                factory.postInit((KeycloakSessionFactory)this);
            }
        }
        AdminPermissions.registerListener((ProviderEventManager)this);
        ProviderManagerRegistry.SINGLETON.setDeployer((ProviderManagerDeployer)this);
    }

    private ProviderFactory lookupProviderFactory(Class<? extends ProviderFactory> factoryClazz) {
        ProviderFactory factory;
        try {
            factory = factoryClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return factory;
    }
}

