/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.federated;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.Provider;

public interface UserFederatedUserCredentialStore
extends Provider {
    public void updateCredential(RealmModel var1, String var2, CredentialModel var3);

    public CredentialModel createCredential(RealmModel var1, String var2, CredentialModel var3);

    public boolean removeStoredCredential(RealmModel var1, String var2, String var3);

    public CredentialModel getStoredCredentialById(RealmModel var1, String var2, String var3);

    @Deprecated
    public List<CredentialModel> getStoredCredentials(RealmModel var1, String var2);

    default public Stream<CredentialModel> getStoredCredentialsStream(RealmModel realm, String userId) {
        List<CredentialModel> value = this.getStoredCredentials(realm, userId);
        return value != null ? value.stream() : Stream.empty();
    }

    @Deprecated
    public List<CredentialModel> getStoredCredentialsByType(RealmModel var1, String var2, String var3);

    default public Stream<CredentialModel> getStoredCredentialsByTypeStream(RealmModel realm, String userId, String type) {
        List<CredentialModel> value = this.getStoredCredentialsByType(realm, userId, type);
        return value != null ? value.stream() : Stream.empty();
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel var1, String var2, String var3, String var4);

    public static interface Streams
    extends UserFederatedUserCredentialStore {
        @Override
        default public List<CredentialModel> getStoredCredentials(RealmModel realm, String userId) {
            return this.getStoredCredentialsStream(realm, userId).collect(Collectors.toList());
        }

        @Override
        public Stream<CredentialModel> getStoredCredentialsStream(RealmModel var1, String var2);

        @Override
        default public List<CredentialModel> getStoredCredentialsByType(RealmModel realm, String userId, String type) {
            return this.getStoredCredentialsByTypeStream(realm, userId, type).collect(Collectors.toList());
        }

        @Override
        public Stream<CredentialModel> getStoredCredentialsByTypeStream(RealmModel var1, String var2, String var3);
    }
}

