/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.role;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.RoleProvider;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.role.MapRoleAdapter;
import org.keycloak.models.map.role.MapRoleEntity;
import org.keycloak.models.map.role.MapRoleEntityImpl;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.provider.InvalidationHandler;

public class MapRoleProvider
implements RoleProvider {
    private static final Logger LOG = Logger.getLogger(MapRoleProvider.class);
    private final KeycloakSession session;
    final MapKeycloakTransaction<MapRoleEntity, RoleModel> tx;

    public MapRoleProvider(KeycloakSession session, MapStorage<MapRoleEntity, RoleModel> roleStore) {
        this.session = session;
        this.tx = roleStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
    }

    private Function<MapRoleEntity, RoleModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapRoleAdapter(this.session, realm, (MapRoleEntity)origEntity);
    }

    public RoleModel addRealmRole(RealmModel realm, String id, String name) {
        if (this.getRealmRole(realm, name) != null) {
            throw new ModelDuplicateException("Role with the same name exists: " + name + " for realm " + realm.getName());
        }
        LOG.tracef("addRealmRole(%s, %s, %s)%s", new Object[]{realm, id, name, StackUtil.getShortStackTrace()});
        MapRoleEntity entity = new MapRoleEntityImpl();
        entity.setId(id);
        entity.setRealmId(realm.getId());
        entity.setName(name);
        entity.setClientRole(false);
        if (entity.getId() != null && this.tx.read(entity.getId()) != null) {
            throw new ModelDuplicateException("Role exists: " + id);
        }
        entity = this.tx.create(entity);
        return this.entityToAdapterFunc(realm).apply(entity);
    }

    public Stream<RoleModel> getRealmRolesStream(RealmModel realm, Integer first, Integer max) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(RoleModel.SearchableFields.IS_CLIENT_ROLE, ModelCriteriaBuilder.Operator.NE, new Object[]{true});
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(first, max, RoleModel.SearchableFields.NAME)).map(this.entityToAdapterFunc(realm));
    }

    public Stream<RoleModel> getRolesStream(RealmModel realm, Stream<String> ids, String search, Integer first, Integer max) {
        LOG.tracef("getRolesStream(%s, %s, %s, %d, %d)%s", new Object[]{realm, ids, search, first, max, StackUtil.getShortStackTrace()});
        if (ids == null) {
            return Stream.empty();
        }
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)((DefaultModelCriteria)mcb).compare(RoleModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.IN, new Object[]{ids})).compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        if (search != null) {
            mcb = ((DefaultModelCriteria)mcb).compare(RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + search + "%"});
        }
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(first, max, RoleModel.SearchableFields.NAME)).map(this.entityToAdapterFunc(realm));
    }

    public Stream<RoleModel> getRealmRolesStream(RealmModel realm) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(RoleModel.SearchableFields.IS_CLIENT_ROLE, ModelCriteriaBuilder.Operator.NE, new Object[]{true});
        return this.tx.read(QueryParameters.withCriteria(mcb).orderBy(RoleModel.SearchableFields.NAME, QueryParameters.Order.ASCENDING)).map(this.entityToAdapterFunc(realm));
    }

    public RoleModel addClientRole(ClientModel client, String id, String name) {
        if (this.getClientRole(client, name) != null) {
            throw new ModelDuplicateException("Role with the same name exists: " + name + " for client " + client.getClientId());
        }
        LOG.tracef("addClientRole(%s, %s, %s)%s", new Object[]{client, id, name, StackUtil.getShortStackTrace()});
        MapRoleEntity entity = new MapRoleEntityImpl();
        entity.setId(id);
        entity.setRealmId(client.getRealm().getId());
        entity.setName(name);
        entity.setClientRole(true);
        entity.setClientId(client.getId());
        if (entity.getId() != null && this.tx.read(entity.getId()) != null) {
            throw new ModelDuplicateException("Role exists: " + id);
        }
        entity = this.tx.create(entity);
        return this.entityToAdapterFunc(client.getRealm()).apply(entity);
    }

    public Stream<RoleModel> getClientRolesStream(ClientModel client, Integer first, Integer max) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getRealm().getId()})).compare(RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getId()});
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(first, max, RoleModel.SearchableFields.NAME)).map(this.entityToAdapterFunc(client.getRealm()));
    }

    public Stream<RoleModel> getClientRolesStream(ClientModel client) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getRealm().getId()})).compare(RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getId()});
        return this.tx.read(QueryParameters.withCriteria(mcb).orderBy(RoleModel.SearchableFields.NAME, QueryParameters.Order.ASCENDING)).map(this.entityToAdapterFunc(client.getRealm()));
    }

    public boolean removeRole(RoleModel role) {
        LOG.tracef("removeRole(%s(%s))%s", (Object)role.getName(), (Object)role.getId(), StackUtil.getShortStackTrace());
        RealmModel realm = role.isClientRole() ? ((ClientModel)role.getContainer()).getRealm() : (RealmModel)role.getContainer();
        this.session.invalidate((InvalidationHandler.InvalidableObjectType)AbstractMapProviderFactory.MapProviderObjectType.ROLE_BEFORE_REMOVE, new Object[]{realm, role});
        this.tx.delete(role.getId());
        this.session.invalidate((InvalidationHandler.InvalidableObjectType)AbstractMapProviderFactory.MapProviderObjectType.ROLE_AFTER_REMOVE, new Object[]{realm, role});
        return true;
    }

    public void removeRoles(RealmModel realm) {
        this.getRealmRolesStream(realm).forEach(this::removeRole);
    }

    public void removeRoles(ClientModel client) {
        this.getClientRolesStream(client).forEach(this::removeRole);
    }

    public RoleModel getRealmRole(RealmModel realm, String name) {
        if (name == null) {
            return null;
        }
        LOG.tracef("getRealmRole(%s, %s)%s", (Object)realm, (Object)name, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(RoleModel.SearchableFields.IS_CLIENT_ROLE, ModelCriteriaBuilder.Operator.NE, new Object[]{true})).compare(RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{name});
        return this.tx.read(QueryParameters.withCriteria(mcb)).map(this.entityToAdapterFunc(realm)).findFirst().orElse(null);
    }

    public RoleModel getClientRole(ClientModel client, String name) {
        if (name == null) {
            return null;
        }
        LOG.tracef("getClientRole(%s, %s)%s", (Object)client, (Object)name, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getRealm().getId()})).compare(RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getId()})).compare(RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{name});
        return this.tx.read(QueryParameters.withCriteria(mcb)).map(this.entityToAdapterFunc(client.getRealm())).findFirst().orElse(null);
    }

    public RoleModel getRoleById(RealmModel realm, String id) {
        if (id == null || realm == null || realm.getId() == null) {
            return null;
        }
        LOG.tracef("getRoleById(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        MapRoleEntity entity = this.tx.read(id);
        String realmId = realm.getId();
        return entity == null || entity.getRealmId() != null && !Objects.equals(realmId, entity.getRealmId()) ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    public Stream<RoleModel> searchForRolesStream(RealmModel realm, String search, Integer first, Integer max) {
        if (search == null) {
            return Stream.empty();
        }
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(RoleModel.SearchableFields.IS_CLIENT_ROLE, ModelCriteriaBuilder.Operator.NE, new Object[]{true})).or(new DefaultModelCriteria[]{mcb.compare(RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + search + "%"}), mcb.compare(RoleModel.SearchableFields.DESCRIPTION, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + search + "%"})});
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(first, max, RoleModel.SearchableFields.NAME)).map(this.entityToAdapterFunc(realm));
    }

    public Stream<RoleModel> searchForClientRolesStream(ClientModel client, String search, Integer first, Integer max) {
        if (search == null) {
            return Stream.empty();
        }
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getRealm().getId()})).compare(RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getId()})).or(new DefaultModelCriteria[]{mcb.compare(RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + search + "%"}), mcb.compare(RoleModel.SearchableFields.DESCRIPTION, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + search + "%"})});
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(first, max, RoleModel.SearchableFields.NAME)).map(this.entityToAdapterFunc(client.getRealm()));
    }

    public void preRemove(RealmModel realm) {
        LOG.tracef("preRemove(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        this.tx.delete(QueryParameters.withCriteria(mcb));
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(RoleModel.SearchableFields.COMPOSITE_ROLE, ModelCriteriaBuilder.Operator.EQ, new Object[]{role.getId()});
        this.tx.read(QueryParameters.withCriteria(mcb)).forEach(mapRoleEntity -> mapRoleEntity.removeCompositeRole(role.getId()));
    }

    public void close() {
    }
}

