/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata;

import java.util.function.Consumer;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.UnexpectedValidationException;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationContext;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationException;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.MetadataContext;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.Named;

public interface DatabaseMetaDataValidation
extends ValidationCapability {
    public static final String NAME = "meta data";

    @Override
    default public void validate(ValidationContext validationContext, Consumer<ValidationException> consumer) {
        Named named = validationContext.get(MetadataContext.named, Named.class);
        boolean bl2 = validationContext.get(MetadataContext.exists, Boolean.class);
        try {
            if (this.exists(named) ^ bl2) {
                consumer.accept(this.getErrorMessage(named, bl2));
            }
            return;
        }
        catch (ValidationException validationException) {
            consumer.accept(validationException);
            return;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            consumer.accept(new ValidationException("This Operation " + named.toString() + "  is not supported yet.", unsupportedOperationException));
            return;
        }
        catch (Exception exception) {
            consumer.accept(this.getUnexpectedErrorMessage(named, exception));
            return;
        }
    }

    public boolean exists(Named var1);

    default public ValidationException getErrorMessage(Named named, boolean bl2) {
        return this.toError(String.format("%s does %sexist.", named.getFqn(), bl2 ? "not " : ""));
    }

    default public ValidationException getUnexpectedErrorMessage(Named named, Exception exception) {
        return new UnexpectedValidationException(named.getFqn() + ": cannot validate " + (Object)((Object)named.getNamedObject()) + "-name. detail: " + exception.getMessage(), exception);
    }

    @Override
    default public String getName() {
        return NAME;
    }
}

