/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.policy;

import org.keycloak.models.KeycloakContext;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PolicyError;

public class MaximumLengthPasswordPolicyProvider
implements PasswordPolicyProvider {
    private static final String ERROR_MESSAGE = "invalidPasswordMaxLengthMessage";
    private final KeycloakContext context;

    public MaximumLengthPasswordPolicyProvider(KeycloakContext context) {
        this.context = context;
    }

    @Override
    public PolicyError validate(String username, String password) {
        int max = (Integer)this.context.getRealm().getPasswordPolicy().getPolicyConfig("maxLength");
        return password.length() > max ? new PolicyError(ERROR_MESSAGE, max) : null;
    }

    @Override
    public PolicyError validate(RealmModel realm, UserModel user, String password) {
        return this.validate(user.getUsername(), password);
    }

    @Override
    public Object parseConfig(String value) {
        return this.parseInteger(value, 64);
    }

    @Override
    public void close() {
    }
}

