/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault;

import io.quarkus.vault.VaultSystemBackendReactiveEngine;
import io.quarkus.vault.sys.EnableEngineOptions;
import io.quarkus.vault.sys.VaultHealth;
import io.quarkus.vault.sys.VaultHealthStatus;
import io.quarkus.vault.sys.VaultInit;
import io.quarkus.vault.sys.VaultSealStatus;
import io.quarkus.vault.sys.VaultSecretEngine;
import io.quarkus.vault.sys.VaultSecretEngineInfo;
import io.quarkus.vault.sys.VaultTuneInfo;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class VaultSystemBackendEngine {
    private final VaultSystemBackendReactiveEngine engine;

    public VaultSystemBackendEngine() {
    }

    @Inject
    public VaultSystemBackendEngine(VaultSystemBackendReactiveEngine engine) {
        this.engine = engine;
    }

    public VaultInit init(int secretShares, int secretThreshold) {
        return (VaultInit)this.engine.init(secretShares, secretThreshold).await().indefinitely();
    }

    public VaultHealth health() {
        return (VaultHealth)this.engine.health().await().indefinitely();
    }

    public VaultHealthStatus healthStatus() {
        return (VaultHealthStatus)this.engine.healthStatus().await().indefinitely();
    }

    public VaultSealStatus sealStatus() {
        return (VaultSealStatus)this.engine.sealStatus().await().indefinitely();
    }

    public String getPolicyRules(String name) {
        return (String)this.engine.getPolicyRules(name).await().indefinitely();
    }

    public void createUpdatePolicy(String name, String rules) {
        this.engine.createUpdatePolicy(name, rules).await().indefinitely();
    }

    public void deletePolicy(String name) {
        this.engine.deletePolicy(name).await().indefinitely();
    }

    public List<String> getPolicies() {
        return (List)this.engine.getPolicies().await().indefinitely();
    }

    public VaultTuneInfo getTuneInfo(String mount) {
        return (VaultTuneInfo)this.engine.getTuneInfo(mount).await().indefinitely();
    }

    public VaultSecretEngineInfo getSecretEngineInfo(String mount) {
        return (VaultSecretEngineInfo)this.engine.getSecretEngineInfo(mount).await().indefinitely();
    }

    public void updateTuneInfo(String mount, VaultTuneInfo tuneInfo) {
        this.engine.updateTuneInfo(mount, tuneInfo).await().indefinitely();
    }

    public boolean isEngineMounted(String mount) {
        return (Boolean)this.engine.isEngineMounted(mount).await().indefinitely();
    }

    public void enable(VaultSecretEngine engine, String mount, String description, EnableEngineOptions options) {
        this.engine.enable(engine, mount, description, options).await().indefinitely();
    }

    public void enable(String engineType, String mount, String description, EnableEngineOptions options) {
        this.engine.enable(engineType, mount, description, options).await().indefinitely();
    }

    public void disable(String mount) {
        this.engine.disable(mount).await().indefinitely();
    }
}

