/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.InputStreamList;

public class CommandLineResourceAccessor
extends ClassLoaderResourceAccessor {
    public CommandLineResourceAccessor(ClassLoader loader) {
        super(loader);
    }

    @Override
    public InputStreamList openStreams(String relativeTo, String streamPath) throws IOException {
        InputStreamList resourcesAsStream = super.openStreams(relativeTo, streamPath);
        if (resourcesAsStream != null) {
            return resourcesAsStream;
        }
        for (String altPath : this.getAlternatePaths(streamPath)) {
            InputStreamList altResourcesAsStream = super.openStreams(relativeTo, altPath);
            if (altResourcesAsStream == null) continue;
            return altResourcesAsStream;
        }
        return null;
    }

    @Override
    public SortedSet<String> list(String relativeTo, String path, boolean includeFiles, boolean includeDirectories, boolean recursive) throws IOException {
        TreeSet<String> contents = new TreeSet<String>();
        SortedSet<String> superList = super.list(relativeTo, path, includeFiles, includeDirectories, recursive);
        if (superList != null) {
            contents.addAll(superList);
        }
        for (String altPath : this.getAlternatePaths(path)) {
            contents.addAll(super.list(relativeTo, altPath, includeFiles, includeDirectories, recursive));
        }
        if (contents.isEmpty()) {
            return new TreeSet<String>();
        }
        return contents;
    }

    protected List<String> getAlternatePaths(String path) {
        ArrayList<String> alternatePaths = new ArrayList<String>();
        if (path.startsWith("/")) {
            alternatePaths.add(path.substring(1));
        }
        return alternatePaths;
    }
}

