/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.server;

import com.openshift.restclient.IClient;
import com.openshift.restclient.capability.server.IConsole;
import com.openshift.restclient.model.IConfigMap;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public class Console
implements IConsole {
    public static final String CONFIGMAP_DATA_CONSOLE_URL = "consoleURL";
    public static final String NAMESPACE_OPENSHIFT_CONFIG_MANAGED = "openshift-config-managed";
    public static final String CONFIGMAP_CONSOLE_PUBLIC = "console-public";
    private IClient client;

    public Console(IClient client) {
        this.client = client;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getConsoleUrl() {
        switch (this.client.getOpenShiftMajorVersion()) {
            case 3: {
                return this.getOpenShift3ConsoleUrl();
            }
            case 4: {
                return this.getOpenShift4ConsoleUrl();
            }
        }
        return null;
    }

    @Override
    public <R extends IResource> String getConsoleUrl(R resource) {
        switch (this.client.getOpenShiftMajorVersion()) {
            case 3: {
                return this.getOpenShift3ConsoleUrl(resource);
            }
            case 4: {
                return this.getOpenShift4ConsoleUrl(resource);
            }
        }
        return null;
    }

    private String getOpenShift3ConsoleUrl() {
        return this.client.getBaseURL() + "/console";
    }

    private <R extends IResource> String getOpenShift3ConsoleUrl(R resource) {
        String consoleResourceUrl;
        String projectName;
        StringBuilder builder = new StringBuilder(this.getOpenShift3ConsoleUrl());
        String string = projectName = resource == null ? null : resource.getNamespaceName();
        if (projectName != null) {
            builder.append("/project/").append(projectName);
        }
        if (resource != null && !(resource instanceof IProject) && (consoleResourceUrl = this.getOpenShiftResourceURL(resource, Arrays.stream(OpenShiftConsoleResourceUrls.values()).filter(resourceUrl -> resourceUrl.getVersion() == 3))) != null) {
            builder.append(consoleResourceUrl);
        }
        return builder.toString();
    }

    private String getOpenShift4ConsoleUrl() {
        IConfigMap configMap = (IConfigMap)this.client.get("ConfigMap", CONFIGMAP_CONSOLE_PUBLIC, NAMESPACE_OPENSHIFT_CONFIG_MANAGED);
        if (configMap == null) {
            return null;
        }
        Map<String, String> data = configMap.getData();
        if (data == null || data.isEmpty()) {
            return null;
        }
        return data.get(CONFIGMAP_DATA_CONSOLE_URL);
    }

    private <R extends IResource> String getOpenShift4ConsoleUrl(R resource) {
        StringBuilder builder = new StringBuilder(this.getOpenShift4ConsoleUrl());
        if (resource == null) {
            return builder.toString();
        }
        String projectName = resource.getNamespaceName();
        if (resource.getKind().equals("Project")) {
            builder.append("/overview/ns/").append(projectName);
        } else {
            String consoleResourceUrl = this.getOpenShiftResourceURL(resource, Arrays.stream(OpenShiftConsoleResourceUrls.values()).filter(resourceUrl -> resourceUrl.getVersion() == 4));
            if (consoleResourceUrl != null) {
                builder.append("/k8s/ns/").append(projectName).append(consoleResourceUrl);
            } else {
                builder.append("/overview/ns/").append(projectName);
            }
        }
        return builder.toString();
    }

    protected String getOpenShiftResourceURL(IResource resource, Stream<OpenShiftConsoleResourceUrls> resourceUrls) {
        return resourceUrls.filter(resUrl -> resUrl.getResType().equals(resource.getKind())).findAny().map(resUrl -> resUrl.getUrlPart() + resUrl.getEndUrlFunc().apply(resource)).orElse(null);
    }

    protected static enum OpenShiftConsoleResourceUrls {
        V3_BUILD(3, "Build", "/browse/builds/", r -> String.join((CharSequence)"/", r.getLabels().get("buildconfig"), r.getName())),
        V3_BUILDCONFIG(3, "BuildConfig", "/browse/builds/", IResource::getName),
        V3_DEPLOYMENT(3, "ReplicationController", "/browse/rc/", IResource::getName),
        V3_DEPLOYMENTCONFIG(3, "DeploymentConfig", "/browse/deployments/", IResource::getName),
        V3_EVENT(3, "Event", "/browse/events/", r -> ""),
        V3_IMAGESTREAM(3, "ImageStream", "/browse/images/", IResource::getName),
        V3_PERSISTENTVOLUMECLAIM(3, "PersistentVolumeClaim", "/browse/persistentvolumeclaims/", IResource::getName),
        V3_POD(3, "Pod", "/browse/pods/", IResource::getName),
        V3_ROUTES(3, "Route", "/browse/routes/", IResource::getName),
        V3_SERVICE(3, "Service", "/browse/services/", IResource::getName),
        V4_BUILDCONFIG(4, "BuildConfig", "/buildconfigs/", IResource::getName),
        V4_BUILD(4, "Build", "/builds/", IResource::getName),
        V4_DEPLOYMENT(4, "ReplicationController", "/replicationcontrollers/", IResource::getName),
        V4_DEPLOYMENTCONFIG(4, "DeploymentConfig", "/deploymentconfigs/", IResource::getName),
        V4_EVENT(4, "Event", "/events/", r -> ""),
        V4_IMAGESTREAM(4, "ImageStream", "/imagestreams/", IResource::getName),
        V4_PERSISTENTVOLUMECLAIM(4, "PersistentVolumeClaim", "/persistentvolumeclaims/", IResource::getName),
        V4_POD(4, "Pod", "/pods/", IResource::getName),
        V4_ROUTES(4, "Route", "/routes/", IResource::getName),
        V4_SERVICE(4, "Service", "/services/", IResource::getName);

        private int openShiftVersion;
        private final String resourceKind;
        private final String urlPart;
        private final Function<IResource, String> endUrlFunc;

        private OpenShiftConsoleResourceUrls(int version, String resourceKind, String urlPart, Function<IResource, String> endUrlFunc) {
            this.openShiftVersion = version;
            this.resourceKind = resourceKind;
            this.urlPart = urlPart;
            this.endUrlFunc = endUrlFunc;
        }

        public int getVersion() {
            return this.openShiftVersion;
        }

        public String getResType() {
            return this.resourceKind;
        }

        public String getUrlPart() {
            return this.urlPart;
        }

        public Function<IResource, String> getEndUrlFunc() {
            return this.endUrlFunc;
        }
    }
}

