/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import org.keycloak.Config;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.GroupProvider;
import org.keycloak.models.GroupProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.jpa.JpaRealmProvider;

public class JpaGroupProviderFactory
implements GroupProviderFactory {
    private Set<String> groupSearchableAttributes = null;

    public void init(Config.Scope config) {
        String[] searchableAttrsArr = config.getArray("searchableAttributes");
        if (searchableAttrsArr == null) {
            String s = System.getProperty("keycloak.group.searchableAttributes");
            searchableAttrsArr = s == null ? null : s.split("\\s*,\\s*");
        }
        this.groupSearchableAttributes = searchableAttrsArr != null ? Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(searchableAttrsArr))) : Collections.emptySet();
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return "jpa";
    }

    public GroupProvider create(KeycloakSession session) {
        EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        return new JpaRealmProvider(session, em, null, this.groupSearchableAttributes);
    }

    public void close() {
    }

    public int order() {
        return 1;
    }
}

