/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.vault.VaultException;
import io.quarkus.vault.VaultPKISecretReactiveEngine;
import io.quarkus.vault.pki.CAChainData;
import io.quarkus.vault.pki.CRLData;
import io.quarkus.vault.pki.CSRData;
import io.quarkus.vault.pki.CertificateData;
import io.quarkus.vault.pki.CertificateExtendedKeyUsage;
import io.quarkus.vault.pki.CertificateKeyType;
import io.quarkus.vault.pki.CertificateKeyUsage;
import io.quarkus.vault.pki.ConfigCRLOptions;
import io.quarkus.vault.pki.ConfigURLsOptions;
import io.quarkus.vault.pki.DataFormat;
import io.quarkus.vault.pki.GenerateCertificateOptions;
import io.quarkus.vault.pki.GenerateIntermediateCSROptions;
import io.quarkus.vault.pki.GenerateRootOptions;
import io.quarkus.vault.pki.GeneratedCertificate;
import io.quarkus.vault.pki.GeneratedIntermediateCSRResult;
import io.quarkus.vault.pki.GeneratedRootCertificate;
import io.quarkus.vault.pki.PrivateKeyData;
import io.quarkus.vault.pki.PrivateKeyEncoding;
import io.quarkus.vault.pki.RoleOptions;
import io.quarkus.vault.pki.SignIntermediateCAOptions;
import io.quarkus.vault.pki.SignedCertificate;
import io.quarkus.vault.pki.TidyOptions;
import io.quarkus.vault.runtime.VaultAuthManager;
import io.quarkus.vault.runtime.VaultPKIManager;
import io.quarkus.vault.runtime.client.VaultClient;
import io.quarkus.vault.runtime.client.VaultClientException;
import io.quarkus.vault.runtime.client.dto.AbstractVaultDTO;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKICRLRotateData;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKICertificateData;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKICertificateListData;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIConfigCABody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIConfigCRLData;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIConfigURLsData;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIGenerateCertificateBody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIGenerateCertificateData;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIGenerateIntermediateCSRBody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIGenerateIntermediateCSRData;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIGenerateRootBody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIGenerateRootData;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIRevokeCertificateBody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIRevokeCertificateData;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIRoleOptionsData;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIRolesListData;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKISetSignedIntermediateCABody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKISignCertificateRequestBody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKISignCertificateRequestData;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKISignIntermediateCABody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKITidyBody;
import io.quarkus.vault.runtime.client.secretengine.VaultInternalPKISecretEngine;
import io.smallrye.mutiny.Uni;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class VaultPKIManager
implements VaultPKISecretReactiveEngine {
    private final VaultClient vaultClient;
    private final String mount;
    private final VaultAuthManager vaultAuthManager;
    private final VaultInternalPKISecretEngine vaultInternalPKISecretEngine;

    public VaultPKIManager() {
    }

    @Inject
    public VaultPKIManager(VaultClient vaultClient, VaultAuthManager vaultAuthManager, VaultInternalPKISecretEngine vaultInternalPKISecretEngine) {
        this(vaultClient, "pki", vaultAuthManager, vaultInternalPKISecretEngine);
    }

    VaultPKIManager(VaultClient vaultClient, String mount, VaultAuthManager vaultAuthManager, VaultInternalPKISecretEngine vaultInternalPKISecretEngine) {
        this.vaultClient = vaultClient;
        this.mount = mount;
        this.vaultAuthManager = vaultAuthManager;
        this.vaultInternalPKISecretEngine = vaultInternalPKISecretEngine;
    }

    public Uni<CertificateData.PEM> getCertificateAuthority() {
        return this.getCertificateAuthority(DataFormat.PEM).map(r -> (CertificateData.PEM)r);
    }

    public Uni<CertificateData> getCertificateAuthority(DataFormat format) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> {
            String vaultFormat = format == DataFormat.PEM ? format.name().toLowerCase(Locale.ROOT) : null;
            return this.vaultInternalPKISecretEngine.getCertificateAuthority(this.vaultClient, token, this.mount, vaultFormat).map(data -> {
                switch (1.$SwitchMap$io$quarkus$vault$pki$DataFormat[format.ordinal()]) {
                    case 1: {
                        return new CertificateData.PEM(data.toString(StandardCharsets.UTF_8));
                    }
                    case 2: {
                        return new CertificateData.DER(data.getBytes());
                    }
                }
                throw new VaultException("Unsupported Data Format");
            });
        });
    }

    public Uni<Void> configCertificateAuthority(String pemBundle) {
        VaultPKIConfigCABody body = new VaultPKIConfigCABody();
        body.pemBundle = pemBundle;
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.configCertificateAuthority(this.vaultClient, token, this.mount, body));
    }

    public Uni<Void> configURLs(ConfigURLsOptions options) {
        VaultPKIConfigURLsData body = new VaultPKIConfigURLsData();
        body.issuingCertificates = options.issuingCertificates;
        body.crlDistributionPoints = options.crlDistributionPoints;
        body.ocspServers = options.ocspServers;
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.configURLs(this.vaultClient, token, this.mount, body));
    }

    public Uni<ConfigURLsOptions> readURLsConfig() {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.readURLs(this.vaultClient, token, this.mount).map(internalResult -> {
            this.checkDataValid((AbstractVaultDTO<?, ?>)internalResult);
            VaultPKIConfigURLsData internalResultData = (VaultPKIConfigURLsData)internalResult.data;
            ConfigURLsOptions result = new ConfigURLsOptions();
            result.issuingCertificates = internalResultData.issuingCertificates;
            result.crlDistributionPoints = internalResultData.crlDistributionPoints;
            result.ocspServers = internalResultData.ocspServers;
            return result;
        }));
    }

    public Uni<Void> configCRL(ConfigCRLOptions options) {
        VaultPKIConfigCRLData body = new VaultPKIConfigCRLData();
        body.expiry = options.expiry;
        body.disable = options.disable;
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.configCRL(this.vaultClient, token, this.mount, body));
    }

    public Uni<ConfigCRLOptions> readCRLConfig() {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.readCRL(this.vaultClient, token, this.mount).map(internalResult -> {
            this.checkDataValid((AbstractVaultDTO<?, ?>)internalResult);
            VaultPKIConfigCRLData internalResultData = (VaultPKIConfigCRLData)internalResult.data;
            ConfigCRLOptions result = new ConfigCRLOptions();
            result.expiry = internalResultData.expiry;
            result.disable = internalResultData.disable;
            return result;
        }));
    }

    public Uni<CAChainData.PEM> getCertificateAuthorityChain() {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.getCertificateAuthorityChain(this.vaultClient, token, this.mount).map(data -> new CAChainData.PEM(data.toString(StandardCharsets.UTF_8))));
    }

    public Uni<CRLData.PEM> getCertificateRevocationList() {
        return this.getCertificateRevocationList(DataFormat.PEM).map(r -> (CRLData.PEM)r);
    }

    public Uni<CRLData> getCertificateRevocationList(DataFormat format) {
        String vaultFormat = format == DataFormat.PEM ? format.name().toLowerCase(Locale.ROOT) : null;
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.getCertificateRevocationList(this.vaultClient, token, this.mount, vaultFormat).map(data -> {
            switch (1.$SwitchMap$io$quarkus$vault$pki$DataFormat[format.ordinal()]) {
                case 1: {
                    return new CRLData.PEM(data.toString(StandardCharsets.UTF_8));
                }
                case 2: {
                    return new CRLData.DER(data.getBytes());
                }
            }
            throw new VaultException("Unsupported Data Format");
        }));
    }

    public Uni<Boolean> rotateCertificateRevocationList() {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.rotateCertificateRevocationList(this.vaultClient, token, this.mount).map(internalResult -> {
            this.checkDataValid((AbstractVaultDTO<?, ?>)internalResult);
            return ((VaultPKICRLRotateData)internalResult.data).success;
        }));
    }

    public Uni<List<String>> getCertificates() {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.listCertificates(this.vaultClient, token, this.mount).map(internalResult -> {
            this.checkDataValid((AbstractVaultDTO<?, ?>)internalResult);
            return ((VaultPKICertificateListData)internalResult.data).keys.stream().map(serial -> serial.replaceAll("-", ":")).collect(Collectors.toList());
        }));
    }

    public Uni<CertificateData.PEM> getCertificate(String serial) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.getCertificate(this.vaultClient, token, this.mount, serial).map(internalResult -> {
            this.checkDataValid((AbstractVaultDTO<?, ?>)internalResult);
            return new CertificateData.PEM(((VaultPKICertificateData)internalResult.data).certificate);
        }));
    }

    public Uni<GeneratedCertificate> generateCertificate(String role, GenerateCertificateOptions options) {
        VaultPKIGenerateCertificateBody body = new VaultPKIGenerateCertificateBody();
        body.format = this.dataFormatToFormat(options.format);
        body.privateKeyFormat = this.privateKeyFormat(options.format, options.privateKeyEncoding);
        body.subjectCommonName = options.subjectCommonName;
        body.subjectAlternativeNames = this.stringListToCommaString(options.subjectAlternativeNames);
        body.ipSubjectAlternativeNames = this.stringListToCommaString(options.ipSubjectAlternativeNames);
        body.uriSubjectAlternativeNames = this.stringListToCommaString(options.uriSubjectAlternativeNames);
        body.otherSubjectAlternativeNames = options.otherSubjectAlternativeNames;
        body.timeToLive = options.timeToLive;
        body.excludeCommonNameFromSubjectAlternativeNames = options.excludeCommonNameFromSubjectAlternativeNames;
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.generateCertificate(this.vaultClient, token, this.mount, role, body).map(internalResult -> {
            this.checkDataValid((AbstractVaultDTO<?, ?>)internalResult);
            VaultPKIGenerateCertificateData internalResultData = (VaultPKIGenerateCertificateData)internalResult.data;
            GeneratedCertificate result = new GeneratedCertificate();
            result.certificate = this.createCertificateData(internalResultData.certificate, body.format);
            result.issuingCA = this.createCertificateData(internalResultData.issuingCA, body.format);
            result.caChain = this.createCertificateDataList(internalResultData.caChain, body.format);
            result.serialNumber = internalResultData.serialNumber;
            result.privateKeyType = this.stringToCertificateKeyType(internalResultData.privateKeyType);
            result.privateKey = this.createPrivateKeyData(internalResultData.privateKey, body.format, body.privateKeyFormat);
            return result;
        }));
    }

    public Uni<SignedCertificate> signRequest(String role, String pemSigningRequest, GenerateCertificateOptions options) {
        VaultPKISignCertificateRequestBody body = new VaultPKISignCertificateRequestBody();
        body.format = this.dataFormatToFormat(options.format);
        body.csr = pemSigningRequest;
        body.subjectCommonName = options.subjectCommonName;
        body.subjectAlternativeNames = this.stringListToCommaString(options.subjectAlternativeNames);
        body.ipSubjectAlternativeNames = this.stringListToCommaString(options.ipSubjectAlternativeNames);
        body.uriSubjectAlternativeNames = this.stringListToCommaString(options.uriSubjectAlternativeNames);
        body.otherSubjectAlternativeNames = options.otherSubjectAlternativeNames;
        body.timeToLive = options.timeToLive;
        body.excludeCommonNameFromSubjectAlternativeNames = options.excludeCommonNameFromSubjectAlternativeNames;
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.signCertificate(this.vaultClient, token, this.mount, role, body).map(internalResult -> {
            this.checkDataValid((AbstractVaultDTO<?, ?>)internalResult);
            VaultPKISignCertificateRequestData internalResultData = (VaultPKISignCertificateRequestData)internalResult.data;
            SignedCertificate result = new SignedCertificate();
            result.certificate = this.createCertificateData(internalResultData.certificate, body.format);
            result.issuingCA = this.createCertificateData(internalResultData.issuingCA, body.format);
            result.caChain = this.createCertificateDataList(internalResultData.caChain, body.format);
            result.serialNumber = internalResultData.serialNumber;
            return result;
        }));
    }

    public Uni<OffsetDateTime> revokeCertificate(String serialNumber) {
        VaultPKIRevokeCertificateBody body = new VaultPKIRevokeCertificateBody();
        body.serialNumber = serialNumber;
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.revokeCertificate(this.vaultClient, token, this.mount, body).map(internalResult -> {
            this.checkDataValid((AbstractVaultDTO<?, ?>)internalResult);
            return ((VaultPKIRevokeCertificateData)internalResult.data).revocationTime;
        }));
    }

    public Uni<Void> updateRole(String role, RoleOptions options) {
        VaultPKIRoleOptionsData body = new VaultPKIRoleOptionsData();
        body.timeToLive = options.timeToLive;
        body.maxTimeToLive = options.maxTimeToLive;
        body.allowLocalhost = options.allowLocalhost;
        body.allowedDomains = options.allowedDomains;
        body.allowTemplatesInAllowedDomains = options.allowTemplatesInAllowedDomains;
        body.allowBareDomains = options.allowBareDomains;
        body.allowSubdomains = options.allowSubdomains;
        body.allowGlobsInAllowedDomains = options.allowGlobsInAllowedDomains;
        body.allowAnyName = options.allowAnyName;
        body.enforceHostnames = options.enforceHostnames;
        body.allowIpSubjectAlternativeNames = options.allowIpSubjectAlternativeNames;
        body.allowedUriSubjectAlternativeNames = options.allowedUriSubjectAlternativeNames;
        body.allowedOtherSubjectAlternativeNames = options.allowedOtherSubjectAlternativeNames;
        body.serverFlag = options.serverFlag;
        body.clientFlag = options.clientFlag;
        body.codeSigningFlag = options.codeSigningFlag;
        body.emailProtectionFlag = options.emailProtectionFlag;
        body.keyType = this.certificateKeyTypeToString(options.keyType);
        body.keyBits = options.keyBits;
        body.keyUsages = this.enumListToStringList(options.keyUsages, Enum::name);
        body.extendedKeyUsages = this.enumListToStringList(options.extendedKeyUsages, Enum::name);
        body.extendedKeyUsageOIDs = options.extendedKeyUsageOIDs;
        body.useCSRCommonName = options.useCSRCommonName;
        body.useCSRSubjectAlternativeNames = options.useCSRSubjectAlternativeNames;
        body.subjectOrganization = this.commaStringToStringList(options.subjectOrganization);
        body.subjectOrganizationalUnit = this.commaStringToStringList(options.subjectOrganizationalUnit);
        body.subjectStreetAddress = this.commaStringToStringList(options.subjectStreetAddress);
        body.subjectPostalCode = this.commaStringToStringList(options.subjectPostalCode);
        body.subjectLocality = this.commaStringToStringList(options.subjectLocality);
        body.subjectProvince = this.commaStringToStringList(options.subjectProvince);
        body.subjectCountry = this.commaStringToStringList(options.subjectCountry);
        body.allowedSubjectSerialNumbers = options.allowedSubjectSerialNumbers;
        body.generateLease = options.generateLease;
        body.noStore = options.noStore;
        body.requireCommonName = options.requireCommonName;
        body.policyOIDs = options.policyOIDs;
        body.basicConstraintsValidForNonCA = options.basicConstraintsValidForNonCA;
        body.notBeforeDuration = options.notBeforeDuration;
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.updateRole(this.vaultClient, token, this.mount, role, body));
    }

    public Uni<RoleOptions> getRole(String role) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.readRole(this.vaultClient, token, this.mount, role).map(internalResult -> {
            this.checkDataValid((AbstractVaultDTO<?, ?>)internalResult);
            VaultPKIRoleOptionsData internalResultData = (VaultPKIRoleOptionsData)internalResult.data;
            RoleOptions result = new RoleOptions();
            result.timeToLive = internalResultData.timeToLive;
            result.maxTimeToLive = internalResultData.maxTimeToLive;
            result.allowLocalhost = internalResultData.allowLocalhost;
            result.allowedDomains = internalResultData.allowedDomains;
            result.allowTemplatesInAllowedDomains = internalResultData.allowTemplatesInAllowedDomains;
            result.allowBareDomains = internalResultData.allowBareDomains;
            result.allowSubdomains = internalResultData.allowSubdomains;
            result.allowGlobsInAllowedDomains = internalResultData.allowGlobsInAllowedDomains;
            result.allowAnyName = internalResultData.allowAnyName;
            result.enforceHostnames = internalResultData.enforceHostnames;
            result.allowIpSubjectAlternativeNames = internalResultData.allowIpSubjectAlternativeNames;
            result.allowedUriSubjectAlternativeNames = internalResultData.allowedUriSubjectAlternativeNames;
            result.allowedOtherSubjectAlternativeNames = internalResultData.allowedOtherSubjectAlternativeNames;
            result.serverFlag = internalResultData.serverFlag;
            result.clientFlag = internalResultData.clientFlag;
            result.codeSigningFlag = internalResultData.codeSigningFlag;
            result.emailProtectionFlag = internalResultData.emailProtectionFlag;
            result.keyType = this.stringToCertificateKeyType(internalResultData.keyType);
            result.keyBits = internalResultData.keyBits;
            result.keyUsages = this.stringListToEnumList(internalResultData.keyUsages, CertificateKeyUsage::valueOf);
            result.extendedKeyUsages = this.stringListToEnumList(internalResultData.extendedKeyUsages, CertificateExtendedKeyUsage::valueOf);
            result.extendedKeyUsageOIDs = internalResultData.extendedKeyUsageOIDs;
            result.useCSRCommonName = internalResultData.useCSRCommonName;
            result.useCSRSubjectAlternativeNames = internalResultData.useCSRSubjectAlternativeNames;
            result.subjectOrganization = this.stringListToCommaString(internalResultData.subjectOrganization);
            result.subjectOrganizationalUnit = this.stringListToCommaString(internalResultData.subjectOrganizationalUnit);
            result.subjectStreetAddress = this.stringListToCommaString(internalResultData.subjectStreetAddress);
            result.subjectPostalCode = this.stringListToCommaString(internalResultData.subjectPostalCode);
            result.subjectLocality = this.stringListToCommaString(internalResultData.subjectLocality);
            result.subjectProvince = this.stringListToCommaString(internalResultData.subjectProvince);
            result.subjectCountry = this.stringListToCommaString(internalResultData.subjectCountry);
            result.allowedSubjectSerialNumbers = internalResultData.allowedSubjectSerialNumbers;
            result.generateLease = internalResultData.generateLease;
            result.noStore = internalResultData.noStore;
            result.requireCommonName = internalResultData.requireCommonName;
            result.policyOIDs = internalResultData.policyOIDs;
            result.basicConstraintsValidForNonCA = internalResultData.basicConstraintsValidForNonCA;
            result.notBeforeDuration = internalResultData.notBeforeDuration;
            return result;
        }));
    }

    public Uni<List<String>> getRoles() {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.listRoles(this.vaultClient, token, this.mount).map(internalResult -> {
            this.checkDataValid((AbstractVaultDTO<?, ?>)internalResult);
            return ((VaultPKIRolesListData)internalResult.data).keys;
        }).onFailure(VaultClientException.class).recoverWithUni(x -> {
            VaultClientException vx = (VaultClientException)x;
            if (vx.getStatus() == 404) {
                return Uni.createFrom().item(Collections.emptyList());
            }
            return Uni.createFrom().failure(x);
        }));
    }

    public Uni<Void> deleteRole(String role) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.deleteRole(this.vaultClient, token, this.mount, role));
    }

    public Uni<GeneratedRootCertificate> generateRoot(GenerateRootOptions options) {
        String type = options.exportPrivateKey ? "exported" : "internal";
        VaultPKIGenerateRootBody body = new VaultPKIGenerateRootBody();
        body.format = this.dataFormatToFormat(options.format);
        body.privateKeyFormat = this.privateKeyFormat(options.format, options.privateKeyEncoding);
        body.subjectCommonName = options.subjectCommonName;
        body.subjectAlternativeNames = this.stringListToCommaString(options.subjectAlternativeNames);
        body.ipSubjectAlternativeNames = this.stringListToCommaString(options.ipSubjectAlternativeNames);
        body.uriSubjectAlternativeNames = this.stringListToCommaString(options.uriSubjectAlternativeNames);
        body.otherSubjectAlternativeNames = options.otherSubjectAlternativeNames;
        body.timeToLive = options.timeToLive;
        body.keyType = this.certificateKeyTypeToString(options.keyType);
        body.keyBits = options.keyBits;
        body.maxPathLength = options.maxPathLength;
        body.excludeCommonNameFromSubjectAlternativeNames = options.excludeCommonNameFromSubjectAlternativeNames;
        body.permittedDnsDomains = options.permittedDnsDomains;
        body.subjectOrganization = options.subjectOrganization;
        body.subjectOrganizationalUnit = options.subjectOrganizationalUnit;
        body.subjectStreetAddress = options.subjectStreetAddress;
        body.subjectPostalCode = options.subjectPostalCode;
        body.subjectLocality = options.subjectLocality;
        body.subjectProvince = options.subjectProvince;
        body.subjectCountry = options.subjectCountry;
        body.subjectSerialNumber = options.subjectSerialNumber;
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.generateRoot(this.vaultClient, token, this.mount, type, body).map(internalResult -> {
            this.checkDataValid((AbstractVaultDTO<?, ?>)internalResult);
            VaultPKIGenerateRootData internalResultData = (VaultPKIGenerateRootData)internalResult.data;
            GeneratedRootCertificate result = new GeneratedRootCertificate();
            result.certificate = this.createCertificateData(internalResultData.certificate, body.format);
            result.issuingCA = this.createCertificateData(internalResultData.issuingCA, body.format);
            result.serialNumber = internalResultData.serialNumber;
            result.privateKeyType = this.stringToCertificateKeyType(internalResultData.privateKeyType);
            result.privateKey = this.createPrivateKeyData(internalResultData.privateKey, body.format, body.privateKeyFormat);
            return result;
        }));
    }

    public Uni<Void> deleteRoot() {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.deleteRoot(this.vaultClient, token, this.mount));
    }

    public Uni<SignedCertificate> signIntermediateCA(String pemSigningRequest, SignIntermediateCAOptions options) {
        VaultPKISignIntermediateCABody body = new VaultPKISignIntermediateCABody();
        body.format = this.dataFormatToFormat(options.format);
        body.csr = pemSigningRequest;
        body.subjectCommonName = options.subjectCommonName;
        body.subjectAlternativeNames = this.stringListToCommaString(options.subjectAlternativeNames);
        body.ipSubjectAlternativeNames = this.stringListToCommaString(options.ipSubjectAlternativeNames);
        body.uriSubjectAlternativeNames = this.stringListToCommaString(options.uriSubjectAlternativeNames);
        body.otherSubjectAlternativeNames = options.otherSubjectAlternativeNames;
        body.timeToLive = options.timeToLive;
        body.maxPathLength = options.maxPathLength;
        body.excludeCommonNameFromSubjectAlternativeNames = options.excludeCommonNameFromSubjectAlternativeNames;
        body.useCSRValues = options.useCSRValues;
        body.permittedDnsDomains = options.permittedDnsDomains;
        body.subjectOrganization = options.subjectOrganization;
        body.subjectOrganizationalUnit = options.subjectOrganizationalUnit;
        body.subjectStreetAddress = options.subjectStreetAddress;
        body.subjectPostalCode = options.subjectPostalCode;
        body.subjectLocality = options.subjectLocality;
        body.subjectProvince = options.subjectProvince;
        body.subjectCountry = options.subjectCountry;
        body.subjectSerialNumber = options.subjectSerialNumber;
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.signIntermediateCA(this.vaultClient, token, this.mount, body).map(internalResult -> {
            this.checkDataValid((AbstractVaultDTO<?, ?>)internalResult);
            VaultPKISignCertificateRequestData internalResultData = (VaultPKISignCertificateRequestData)internalResult.data;
            SignedCertificate result = new SignedCertificate();
            result.certificate = this.createCertificateData(internalResultData.certificate, body.format);
            result.issuingCA = this.createCertificateData(internalResultData.issuingCA, body.format);
            result.caChain = this.createCertificateDataList(internalResultData.caChain, body.format);
            result.serialNumber = internalResultData.serialNumber;
            return result;
        }));
    }

    public Uni<GeneratedIntermediateCSRResult> generateIntermediateCSR(GenerateIntermediateCSROptions options) {
        String type = options.exportPrivateKey ? "exported" : "internal";
        VaultPKIGenerateIntermediateCSRBody body = new VaultPKIGenerateIntermediateCSRBody();
        body.format = this.dataFormatToFormat(options.format);
        body.privateKeyFormat = this.privateKeyFormat(options.format, options.privateKeyEncoding);
        body.subjectCommonName = options.subjectCommonName;
        body.subjectAlternativeNames = this.stringListToCommaString(options.subjectAlternativeNames);
        body.ipSubjectAlternativeNames = this.stringListToCommaString(options.ipSubjectAlternativeNames);
        body.uriSubjectAlternativeNames = this.stringListToCommaString(options.uriSubjectAlternativeNames);
        body.otherSubjectAlternativeNames = options.otherSubjectAlternativeNames;
        body.keyType = this.certificateKeyTypeToString(options.keyType);
        body.keyBits = options.keyBits;
        body.excludeCommonNameFromSubjectAlternativeNames = options.excludeCommonNameFromSubjectAlternativeNames;
        body.subjectOrganization = options.subjectOrganization;
        body.subjectOrganizationalUnit = options.subjectOrganizationalUnit;
        body.subjectStreetAddress = options.subjectStreetAddress;
        body.subjectPostalCode = options.subjectPostalCode;
        body.subjectLocality = options.subjectLocality;
        body.subjectProvince = options.subjectProvince;
        body.subjectCountry = options.subjectCountry;
        body.subjectSerialNumber = options.subjectSerialNumber;
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.generateIntermediateCSR(this.vaultClient, token, this.mount, type, body).map(internalResult -> {
            VaultPKIGenerateIntermediateCSRData internalResultData = (VaultPKIGenerateIntermediateCSRData)internalResult.data;
            GeneratedIntermediateCSRResult result = new GeneratedIntermediateCSRResult();
            result.csr = this.createCSRData(internalResultData.csr, body.format);
            result.privateKeyType = this.stringToCertificateKeyType(internalResultData.privateKeyType);
            result.privateKey = this.createPrivateKeyData(internalResultData.privateKey, body.format, body.privateKeyFormat);
            return result;
        }));
    }

    public Uni<Void> setSignedIntermediateCA(String pemCert) {
        VaultPKISetSignedIntermediateCABody body = new VaultPKISetSignedIntermediateCABody();
        body.certificate = pemCert;
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.setSignedIntermediateCA(this.vaultClient, token, this.mount, body));
    }

    public Uni<Void> tidy(TidyOptions options) {
        VaultPKITidyBody body = new VaultPKITidyBody();
        body.tidyCertStore = options.tidyCertStore;
        body.tidyRevokedCerts = options.tidyRevokedCerts;
        body.safetyBuffer = options.safetyBuffer;
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalPKISecretEngine.tidy(this.vaultClient, token, this.mount, body));
    }

    private String stringListToCommaString(List<String> values) {
        if (values == null) {
            return null;
        }
        return String.join((CharSequence)",", values);
    }

    private List<String> commaStringToStringList(String value) {
        if (value == null) {
            return null;
        }
        return Arrays.asList(value.split(","));
    }

    private CertificateKeyType stringToCertificateKeyType(String value) {
        if (value == null) {
            return null;
        }
        return CertificateKeyType.valueOf((String)value.toUpperCase());
    }

    private String certificateKeyTypeToString(CertificateKeyType value) {
        if (value == null) {
            return null;
        }
        return value.name().toLowerCase();
    }

    private <T extends Enum<T>> List<String> enumListToStringList(List<T> values, Function<T, String> converter) {
        if (values == null) {
            return null;
        }
        return values.stream().map(converter).collect(Collectors.toList());
    }

    private <T extends Enum<T>> List<T> stringListToEnumList(List<String> values, Function<String, T> converter) {
        if (values == null) {
            return null;
        }
        return values.stream().map(converter).collect(Collectors.toList());
    }

    private void checkDataValid(AbstractVaultDTO<?, ?> dto) {
        List warnings;
        if (dto.data != null) {
            return;
        }
        if (dto.warnings instanceof List && !(warnings = (List)dto.warnings).isEmpty()) {
            throw new VaultException(warnings.get(0).toString());
        }
        throw new VaultException("Unknown vault error");
    }

    private String dataFormatToFormat(DataFormat format) {
        if (format == null) {
            return "pem";
        }
        return format.name().toLowerCase(Locale.ROOT);
    }

    private String nonNullFormat(String format) {
        if (format == null) {
            return "pem";
        }
        return format;
    }

    private String privateKeyFormat(DataFormat format, PrivateKeyEncoding privateKeyEncoding) {
        if (privateKeyEncoding == null) {
            return "pkcs8";
        }
        if (privateKeyEncoding == PrivateKeyEncoding.PKCS8) {
            return "pkcs8";
        }
        return this.dataFormatToFormat(format);
    }

    private CertificateData createCertificateData(String data, String format) {
        if (data == null) {
            return null;
        }
        switch (this.nonNullFormat(format)) {
            case "der": {
                return new CertificateData.DER(Base64.getDecoder().decode(data));
            }
            case "pem": {
                return new CertificateData.PEM(data);
            }
        }
        throw new VaultException("Unsupported certificate format");
    }

    private List<CertificateData> createCertificateDataList(List<String> datas, String format) {
        if (datas == null) {
            return null;
        }
        ArrayList<CertificateData> result = new ArrayList<CertificateData>(datas.size());
        for (String data : datas) {
            result.add(this.createCertificateData(data, format));
        }
        return result;
    }

    private CSRData createCSRData(String data, String format) {
        if (data == null) {
            return null;
        }
        switch (this.nonNullFormat(format)) {
            case "der": {
                return new CSRData.DER(Base64.getDecoder().decode(data));
            }
            case "pem": {
                return new CSRData.PEM(data);
            }
        }
        throw new VaultException("Unsupported certification request format");
    }

    private PrivateKeyData createPrivateKeyData(String data, String format, String privateKeyFormat) {
        if (data == null) {
            return null;
        }
        boolean pkcs8 = "pkcs8".equals(privateKeyFormat.toLowerCase(Locale.ROOT));
        switch (this.nonNullFormat(format)) {
            case "der": {
                return new PrivateKeyData.DER(Base64.getDecoder().decode(data), pkcs8);
            }
            case "pem": {
                return new PrivateKeyData.PEM(data, pkcs8);
            }
        }
        throw new VaultException("Unsupported private key format");
    }
}

