/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common.delegate;

import java.util.function.Supplier;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.common.delegate.DelegateProvider;
import org.keycloak.models.map.common.delegate.LazilyInitialized;

public class LazyDelegateProvider<T extends AbstractEntity>
implements DelegateProvider<T> {
    protected final LazilyInitialized<T> delegateSupplier;

    public LazyDelegateProvider(Supplier<T> delegateSupplier) {
        this.delegateSupplier = new LazilyInitialized<T>(delegateSupplier);
    }

    @Override
    public T getDelegate(boolean isRead, Enum<? extends EntityField<T>> field, Object ... parameters) {
        AbstractEntity ref = (AbstractEntity)this.delegateSupplier.get();
        if (ref == null) {
            throw new IllegalStateException("Invalid delegate obtained");
        }
        return (T)ref;
    }

    @Override
    public boolean isUpdated() {
        if (this.delegateSupplier.isInitialized()) {
            AbstractEntity d = (AbstractEntity)this.delegateSupplier.get();
            return d instanceof UpdatableEntity ? ((UpdatableEntity)((Object)d)).isUpdated() : false;
        }
        return false;
    }
}

