/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testcontainers.shaded.com.google.common.net.HostAndPort;
import org.testcontainers.utility.Versioning;

public final class DockerImageName {
    private static final String ALPHA_NUMERIC = "[a-z0-9]+";
    private static final String SEPARATOR = "([.]|_{1,2}|-+)";
    private static final String REPO_NAME_PART = "[a-z0-9]+(([.]|_{1,2}|-+)[a-z0-9]+)*";
    private static final Pattern REPO_NAME = Pattern.compile("[a-z0-9]+(([.]|_{1,2}|-+)[a-z0-9]+)*(/[a-z0-9]+(([.]|_{1,2}|-+)[a-z0-9]+)*)*");
    private final String rawName;
    private final String registry;
    private final String repository;
    @NotNull
    private final Versioning versioning;
    @Nullable
    private final DockerImageName compatibleSubstituteFor;

    public static DockerImageName parse(String fullImageName) {
        return new DockerImageName(fullImageName);
    }

    @Deprecated
    public DockerImageName(String fullImageName) {
        String remoteName;
        this.rawName = fullImageName;
        int slashIndex = fullImageName.indexOf(47);
        if (slashIndex == -1 || !fullImageName.substring(0, slashIndex).contains(".") && !fullImageName.substring(0, slashIndex).contains(":") && !fullImageName.substring(0, slashIndex).equals("localhost")) {
            this.registry = "";
            remoteName = fullImageName;
        } else {
            this.registry = fullImageName.substring(0, slashIndex);
            remoteName = fullImageName.substring(slashIndex + 1);
        }
        if (remoteName.contains("@sha256:")) {
            this.repository = remoteName.split("@sha256:")[0];
            this.versioning = new Versioning.Sha256Versioning(remoteName.split("@sha256:")[1]);
        } else if (remoteName.contains(":")) {
            this.repository = remoteName.split(":")[0];
            this.versioning = new Versioning.TagVersioning(remoteName.split(":")[1]);
        } else {
            this.repository = remoteName;
            this.versioning = Versioning.ANY;
        }
        this.compatibleSubstituteFor = null;
    }

    @Deprecated
    public DockerImageName(String nameWithoutTag, @NotNull String version) {
        String remoteName;
        this.rawName = nameWithoutTag;
        int slashIndex = nameWithoutTag.indexOf(47);
        if (slashIndex == -1 || !nameWithoutTag.substring(0, slashIndex).contains(".") && !nameWithoutTag.substring(0, slashIndex).contains(":") && !nameWithoutTag.substring(0, slashIndex).equals("localhost")) {
            this.registry = "";
            remoteName = nameWithoutTag;
        } else {
            this.registry = nameWithoutTag.substring(0, slashIndex);
            remoteName = nameWithoutTag.substring(slashIndex + 1);
        }
        if (version.startsWith("sha256:")) {
            this.repository = remoteName;
            this.versioning = new Versioning.Sha256Versioning(version.replace("sha256:", ""));
        } else {
            this.repository = remoteName;
            this.versioning = new Versioning.TagVersioning(version);
        }
        this.compatibleSubstituteFor = null;
    }

    public String getUnversionedPart() {
        if (!"".equals(this.registry)) {
            return this.registry + "/" + this.repository;
        }
        return this.repository;
    }

    public String getVersionPart() {
        return this.versioning.toString();
    }

    public String asCanonicalNameString() {
        return this.getUnversionedPart() + this.versioning.getSeparator() + this.getVersionPart();
    }

    public String toString() {
        return this.asCanonicalNameString();
    }

    public void assertValid() {
        HostAndPort.fromString(this.registry);
        if (!REPO_NAME.matcher(this.repository).matches()) {
            throw new IllegalArgumentException(this.repository + " is not a valid Docker image name (in " + this.rawName + ")");
        }
        if (!this.versioning.isValid()) {
            throw new IllegalArgumentException(this.versioning + " is not a valid image versioning identifier (in " + this.rawName + ")");
        }
    }

    public DockerImageName withTag(String newTag) {
        return this.withVersioning(new Versioning.TagVersioning(newTag));
    }

    public DockerImageName asCompatibleSubstituteFor(String otherImageName) {
        return this.withCompatibleSubstituteFor(DockerImageName.parse(otherImageName));
    }

    public DockerImageName asCompatibleSubstituteFor(DockerImageName otherImageName) {
        return this.withCompatibleSubstituteFor(otherImageName);
    }

    public boolean isCompatibleWith(DockerImageName other) {
        if (other.equals(this)) {
            return true;
        }
        if (this.compatibleSubstituteFor == null) {
            return false;
        }
        return this.compatibleSubstituteFor.isCompatibleWith(other);
    }

    public void assertCompatibleWith(DockerImageName ... anyOthers) {
        if (anyOthers.length == 0) {
            throw new IllegalArgumentException("anyOthers parameter must be non-empty");
        }
        for (DockerImageName anyOther : anyOthers) {
            if (!this.isCompatibleWith(anyOther)) continue;
            return;
        }
        DockerImageName exampleOther = anyOthers[0];
        throw new IllegalStateException(String.format("Failed to verify that image '%s' is a compatible substitute for '%s'. This generally means that you are trying to use an image that Testcontainers has not been designed to use. If this is deliberate, and if you are confident that the image is compatible, you should declare compatibility in code using the `asCompatibleSubstituteFor` method. For example:\n   DockerImageName myImage = DockerImageName.parse(\"%s\").asCompatibleSubstituteFor(\"%s\");\nand then use `myImage` instead.", this.rawName, exampleOther.rawName, this.rawName, exampleOther.rawName));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DockerImageName)) {
            return false;
        }
        DockerImageName other = (DockerImageName)o;
        String this$registry = this.getRegistry();
        String other$registry = other.getRegistry();
        if (this$registry == null ? other$registry != null : !this$registry.equals(other$registry)) {
            return false;
        }
        String this$repository = this.getRepository();
        String other$repository = other.getRepository();
        if (this$repository == null ? other$repository != null : !this$repository.equals(other$repository)) {
            return false;
        }
        Versioning this$versioning = this.versioning;
        Versioning other$versioning = other.versioning;
        return !(this$versioning == null ? other$versioning != null : !this$versioning.equals(other$versioning));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $registry = this.getRegistry();
        result = result * 59 + ($registry == null ? 43 : $registry.hashCode());
        String $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        Versioning $versioning = this.versioning;
        result = result * 59 + ($versioning == null ? 43 : $versioning.hashCode());
        return result;
    }

    private DockerImageName(String rawName, String registry, String repository, @NotNull Versioning versioning, @Nullable DockerImageName compatibleSubstituteFor) {
        if (versioning == null) {
            throw new NullPointerException("versioning is marked non-null but is null");
        }
        this.rawName = rawName;
        this.registry = registry;
        this.repository = repository;
        this.versioning = versioning;
        this.compatibleSubstituteFor = compatibleSubstituteFor;
    }

    public DockerImageName withRegistry(String registry) {
        return this.registry == registry ? this : new DockerImageName(this.rawName, registry, this.repository, this.versioning, this.compatibleSubstituteFor);
    }

    public String getRegistry() {
        return this.registry;
    }

    public DockerImageName withRepository(String repository) {
        return this.repository == repository ? this : new DockerImageName(this.rawName, this.registry, repository, this.versioning, this.compatibleSubstituteFor);
    }

    public String getRepository() {
        return this.repository;
    }

    private DockerImageName withVersioning(@NotNull Versioning versioning) {
        if (versioning == null) {
            throw new NullPointerException("versioning is marked non-null but is null");
        }
        return this.versioning == versioning ? this : new DockerImageName(this.rawName, this.registry, this.repository, versioning, this.compatibleSubstituteFor);
    }

    private DockerImageName withCompatibleSubstituteFor(@Nullable DockerImageName compatibleSubstituteFor) {
        return this.compatibleSubstituteFor == compatibleSubstituteFor ? this : new DockerImageName(this.rawName, this.registry, this.repository, this.versioning, compatibleSubstituteFor);
    }
}

