/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.Optional;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.ClientPolicyConditionConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;
import org.keycloak.util.JsonSerialization;

public abstract class AbstractClientPolicyConditionProvider<CONFIG extends ClientPolicyConditionConfigurationRepresentation>
implements ClientPolicyConditionProvider<CONFIG> {
    protected final KeycloakSession session;
    protected CONFIG configuration;

    public AbstractClientPolicyConditionProvider(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public void setupConfiguration(CONFIG config) {
        this.configuration = config == null ? (ClientPolicyConditionConfigurationRepresentation)JsonSerialization.mapper.convertValue((Object)new ClientPolicyConditionConfigurationRepresentation(), this.getConditionConfigurationClass()) : config;
    }

    @Override
    public boolean isNegativeLogic() throws ClientPolicyException {
        if (this.configuration == null) {
            throw new ClientPolicyException("Not allowed to call this when configuration is not set");
        }
        return Optional.ofNullable(((ClientPolicyConditionConfigurationRepresentation)this.configuration).isNegativeLogic()).orElse(Boolean.FALSE);
    }
}

