/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import com.datical.liquibase.ext.config.SqlcmdConfiguration;
import com.datical.liquibase.ext.config.SqlcmdConfiguration$ConfigurationKeys;
import com.datical.liquibase.ext.database.jvm.ProJdbcConnection;
import com.datical.liquibase.ext.tools.NativeToolFileCreator;
import com.datical.liquibase.ext.tools.NativeToolFileCreator$FileTypeEnum;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.ExecuteShellCommandChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.resource.InputStreamList;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sql.Sql;
import liquibase.util.StringUtil;

@LiquibaseService(skip=true)
public class SqlcmdRunner
extends ExecuteShellCommandChange {
    private final ChangeSet changeSet;
    private final Sql[] sqlStrings;
    private File outFile = null;
    private Boolean keepTempFile;
    private List<String> args = new ArrayList<String>();
    private String tempName;
    private String tempPath;
    private Boolean tempOverwrite;
    private String logFile;
    private String catalogName;

    public SqlcmdRunner(ChangeSet changeSet, Sql[] sqlArray) {
        this.changeSet = changeSet;
        this.sqlStrings = sqlArray;
        this.setTimeout("1800");
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String string) {
        this.logFile = string;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String string) {
        this.catalogName = string;
    }

    @Override
    protected List<String> createFinalCommandArray(Database object) {
        this.loadSqlcmdProperties();
        List<String> list = super.createFinalCommandArray((Database)object);
        try {
            this.writeSqlStrings();
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException(exception);
        }
        if (this.keepTempFile == null) {
            this.keepTempFile = SqlcmdConfiguration.TEMP_KEEP.getCurrentValue();
        }
        list.add("-S");
        list.add(this.getDatabaseHostname((Database)object));
        Object object2 = object.getConnection();
        ProJdbcConnection proJdbcConnection = (ProJdbcConnection)object2;
        String string = proJdbcConnection.getUsername();
        if (string == null) {
            string = object2.getConnectionUserName();
        }
        string = StringUtil.trimToEmpty(string);
        object2 = StringUtil.trimToEmpty(proJdbcConnection.getPassword());
        if (((String)object2).equals("")) {
            string = "";
        }
        if (StringUtil.isEmpty(string) || StringUtil.isEmpty((String)object2)) {
            Scope.getCurrentScope().getLog(SqlcmdRunner.class).fine("database connection is missing username and/or password. Assuming integratedSecurity.");
            list.add("-E");
        } else {
            Scope.getCurrentScope().getLog(SqlcmdRunner.class).fine("database connection has both username and password. Adding -U and -P to commandArray.");
            list.add("-U");
            list.add(string);
            list.add("-P");
            list.add((String)object2);
        }
        Object object3 = object2 = this.getCatalogName() != null ? this.getCatalogName() : object.getDefaultCatalogName();
        if (((MSSQLDatabase)object).isAzureDb()) {
            Scope.getCurrentScope().getLog(SqlcmdRunner.class).fine("database is AzureDB");
            list.add("-d");
            list.add((String)object2);
        }
        if (this.isActiveDirectoryAuthentication((Database)object)) {
            list.add("-G");
        }
        if (this.outFile != null) {
            list.add("-i");
            list.add(this.outFile.getAbsolutePath());
        }
        list.add("-b");
        list.add("-e");
        if (!this.args.isEmpty()) {
            list.addAll(Collections.unmodifiableList(this.args));
        }
        object = StringUtil.join(list, " ").replaceAll("(.*) -U (.*) -P (.*) -i (.)", "$1 -U ***** -P ****** -i $4");
        Scope.getCurrentScope().getLog(this.getClass()).info("SQLCMD command:\n".concat(String.valueOf(object)));
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeCommand(Database object) {
        block10: {
            try {
                this.finalCommandArray = this.createFinalCommandArray((Database)object);
                super.executeCommand((Database)object);
                if (this.outFile == null) break block10;
            }
            catch (TimeoutException timeoutException) {
                try {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    this.processResult(0, null, null, (Database)object);
                    object = timeoutException.getMessage() + System.lineSeparator() + System.lineSeparator() + "The sqlcmd executable failed to return a response within the configured timeout.\nPlease check liquibase.sqlcmd.timeout specified in liquibase.sqlcmd.conf file, the LIQUIBASE_SQLCMD_TIMEOUT Enviroment variable, or other config locations.\nLearn more at https://docs.liquibase.com/concepts/advanced/runwith.html." + System.lineSeparator();
                    Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(object)));
                    Scope.getCurrentScope().getLog(SqlcmdRunner.class).warning((String)object);
                    throw new LiquibaseException(timeoutException);
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw illegalArgumentException;
                    }
                    catch (Exception exception) {
                        throw new LiquibaseException(exception);
                    }
                }
                catch (Throwable throwable) {
                    if (this.outFile != null && this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
                        Scope.getCurrentScope().getLog(this.getClass()).info("SQLCMD run script can be located at: " + this.outFile.getAbsolutePath());
                    }
                    throw throwable;
                }
            }
            if (this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
                Scope.getCurrentScope().getLog(this.getClass()).info("SQLCMD run script can be located at: " + this.outFile.getAbsolutePath());
                return;
            }
        }
    }

    @Override
    protected void processResult(int n2, String string, String string2, Database database) {
        if (n2 != 0 && !StringUtil.isEmpty(string2)) {
            String string3 = this.getCommandString() + " returned a code of " + n2 + "\n" + string2;
            throw new UnexpectedLiquibaseException(string3);
        }
        super.processResult(n2, string, string2, database);
    }

    @Override
    protected ExecuteShellCommandChange.StreamGobbler createErrorGobbler(InputStream inputStream, OutputStream outputStream) {
        return new ExecuteShellCommandChange.StreamGobbler(inputStream, outputStream, Thread.currentThread());
    }

    private boolean isActiveDirectoryAuthentication(Database object) {
        return ((String)(object = object.getConnection().getURL())).toLowerCase().contains("authentication=activedirectorypassword") || ((String)object).toLowerCase().contains("authentication=activedirectorymsi") || ((String)object).toLowerCase().contains("activedirectoryintegrated");
    }

    private String getDatabaseHostname(Database object) {
        object = object.getConnection().getURL();
        Object object2 = Pattern.compile(".*?//(.*?):(\\d+);.*").matcher((CharSequence)object);
        if (((Matcher)object2).matches()) {
            object = ((Matcher)object2).group(1);
            object2 = ((Matcher)object2).group(2);
        } else {
            object = ((String)object).replaceFirst(".*?//", "").replaceFirst(":.*", "").replaceFirst(";.*", "");
            object2 = "1433";
        }
        return "tcp:" + (String)object + "," + (String)object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadSqlcmdProperties() {
        InputStream inputStream;
        String string;
        Object object;
        File file;
        block23: {
            boolean bl2 = StringUtil.trimToEmpty(System.getProperties().getProperty("os.name")).toLowerCase().startsWith("windows");
            this.setExecutable("sqlcmd");
            if (bl2) {
                this.setExecutable("sqlcmd.exe");
            }
            file = null;
            Properties properties = new Properties();
            object = SqlcmdConfiguration.PATH.getCurrentValue();
            if (object != null) {
                file = new File((String)object);
            }
            object = SqlcmdConfiguration.TIMEOUT.getCurrentValue();
            string = SqlcmdConfiguration.ARGS.getCurrentValue();
            this.assignPropertiesFromConfiguration();
            Object object2 = Scope.getCurrentScope().getResourceAccessor();
            inputStream = null;
            try {
                object2 = object2.openStreams(null, "liquibase.sqlcmd.conf");
                Throwable throwable = null;
                try {
                    if (object2 == null || ((InputStreamList)object2).size() == 0) {
                        Scope.getCurrentScope().getLog(this.getClass()).info("No configuration file named 'liquibase.sqlcmd.conf' found.");
                    } else {
                        String string2 = ((InputStreamList)object2).getURIs().get(0).getRawPath();
                        Scope.getCurrentScope().getLog(this.getClass()).info("SQLCMD configuration file located at '" + string2 + "'.");
                        inputStream = ((InputStreamList)object2).iterator().next();
                        properties.load(inputStream);
                        if (properties.containsKey("liquibase.sqlcmd.path")) {
                            file = new File(properties.getProperty("liquibase.sqlcmd.path"));
                        }
                        if (properties.containsKey("liquibase.sqlcmd.timeout")) {
                            object = this.determineTimeout(properties);
                        }
                        if (properties.containsKey("liquibase.sqlcmd.args")) {
                            string = properties.getProperty("liquibase.sqlcmd.args");
                        }
                        this.overrideWithFileProperties(properties);
                    }
                    if (object2 == null) break block23;
                }
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (object2 == null) throw throwable4;
                        if (throwable == null) {
                            ((InputStreamList)object2).close();
                            throw throwable4;
                        }
                        try {
                            ((InputStreamList)object2).close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            throw throwable4;
                        }
                    }
                }
                ((InputStreamList)object2).close();
            }
            catch (IOException iOException) {
                try {
                    throw new UnexpectedLiquibaseException(iOException);
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
            }
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {}
        this.handleSqlcmdExecutable(file);
        this.handleTimeout((Integer)object);
        this.handleArgs(string);
        this.logProperties();
    }

    private void handleArgs(String string) {
        if (string != null) {
            string = string.trim();
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'sqlcmd' with a extra arguments of '" + string + "'");
            this.args = StringUtil.splitAndTrim(string, " ");
        }
    }

    private void handleTimeout(Integer n2) {
        if (n2 != null) {
            this.validateTimeout(n2);
            this.setTimeout(String.valueOf(n2));
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'sqlcmd' with a timeout of '" + n2 + "'");
        }
    }

    private void handleSqlcmdExecutable(File file) {
        if (file == null) {
            return;
        }
        this.checkSqlcmdExecutable(file);
        try {
            this.setExecutable(file.getCanonicalPath());
            Scope.getCurrentScope().getLog(this.getClass()).info("Using the 'sqlcmd' executable located at:  '" + file.getCanonicalPath() + "'");
            return;
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException(iOException);
        }
    }

    private void assignPropertiesFromConfiguration() {
        this.tempName = SqlcmdConfiguration.TEMP_NAME.getCurrentValue();
        this.tempPath = SqlcmdConfiguration.TEMP_PATH.getCurrentValue();
        this.tempOverwrite = SqlcmdConfiguration.TEMP_OVERWRITE.getCurrentValue();
        this.logFile = SqlcmdConfiguration.LOG_FILE.getCurrentValue();
        if (!SqlcmdConfiguration.TEMP_KEEP.getCurrentConfiguredValue().wasDefaultValueUsed()) {
            this.keepTempFile = SqlcmdConfiguration.TEMP_KEEP.getCurrentValue();
        }
    }

    private void logProperties() {
        if (this.keepTempFile != null) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'sqlcmd' with a keep temp file value of '" + this.keepTempFile + "'");
        }
        if (this.tempPath != null) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'sqlcmd' with a keep temp file path value of '" + this.tempPath + "'");
        }
        if (this.tempOverwrite != null) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'sqlcmd' with a keep temp file overwrite value of '" + this.tempOverwrite + "'");
        }
        if (this.tempName != null) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'sqlcmd' with a keep temp file name value of '" + this.tempName + "'");
        }
        if (this.logFile != null) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'sqlcmd' with a log file value of '" + this.logFile + "'");
        }
    }

    private void checkSqlcmdExecutable(File file) {
        if (!file.exists()) {
            throw new UnexpectedLiquibaseException("The 'sqlcmd' executable was not found at '" + file.getAbsolutePath() + "'.\nPlease check the liquibase.sqlcmd.path property in liquibase.sqlcmd.conf, the LIQUIBASE_SQLCMD_PATH Environment variable, \nor other config locations. Learn more at https://docs.liquibase.com/concepts/advanced/runwith.html.\n");
        }
        if (!file.canExecute()) {
            throw new UnexpectedLiquibaseException("The 'sqlcmd' executable located at '" + file.getAbsolutePath() + "' cannot be executed");
        }
    }

    private int determineTimeout(Properties object) {
        if ((object = ((Properties)object).getProperty("liquibase.sqlcmd.timeout")) == null) {
            return -1;
        }
        try {
            return Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException("Invalid value '" + (String)object + "' for timeoutString 'liquibase.sqlcmd.timeout'. Must be a valid integer.  Learn more at https://docs.liquibase.com");
        }
    }

    private void overrideWithFileProperties(Properties properties) {
        if (properties.containsKey("liquibase.sqlcmd.keep.temp")) {
            this.keepTempFile = this.getBooleanFromProperties(properties, "liquibase.sqlcmd.keep.temp");
        }
        if (properties.containsKey(SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.name"))) {
            this.tempName = properties.getProperty(SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.name"));
        }
        if (properties.containsKey(SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.overwrite"))) {
            this.tempOverwrite = this.getBooleanFromProperties(properties, SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.overwrite"));
        }
        if (properties.containsKey(SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.path"))) {
            this.tempPath = properties.getProperty(SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.path"));
        }
        if (properties.containsKey(SqlcmdConfiguration$ConfigurationKeys.getFullKey("logFile"))) {
            this.logFile = properties.getProperty(SqlcmdConfiguration$ConfigurationKeys.getFullKey("logFile"));
        }
    }

    private Boolean getBooleanFromProperties(Properties object, String string) {
        if (!((object = ((Properties)object).getProperty(string)) == null || ((String)object).isEmpty() || ((String)(object = ((String)object).toLowerCase())).equals("true") || ((String)object).equals("false"))) {
            throw new UnexpectedLiquibaseException("Invalid value '" + (String)object + "' for property '" + string + "'. Must be 'true' or 'false'.  Learn more at https://docs.liquibase.com");
        }
        return Boolean.valueOf((String)object);
    }

    private void validateTimeout(Integer n2) {
        if (n2 == null) {
            return;
        }
        if (n2.equals(-1)) {
            return;
        }
        if (n2.equals(0)) {
            throw new UnexpectedLiquibaseException("Invalid timeout value of 0");
        }
        if (n2 <= 0) {
            throw new UnexpectedLiquibaseException("Invalid timeout value of '" + n2 + "'");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeSqlStrings() {
        Object object;
        if (this.sqlStrings == null || this.sqlStrings.length == 0) {
            return;
        }
        Scope.getCurrentScope().getLog(this.getClass()).info("Creating the SQL run script");
        Object object2 = new NativeToolFileCreator(this.changeSet, this.tempName, this.tempPath, this.tempOverwrite == null ? SqlcmdConfiguration.TEMP_OVERWRITE.getDefaultValue().booleanValue() : this.tempOverwrite.booleanValue(), this.keepTempFile == null ? SqlcmdConfiguration.TEMP_KEEP.getDefaultValue().booleanValue() : this.keepTempFile.booleanValue());
        try {
            this.outFile = ((NativeToolFileCreator)object2).generateTemporaryFile(NativeToolFileCreator$FileTypeEnum.sql);
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException(iOException);
        }
        object2 = this.sqlStrings;
        int n2 = this.sqlStrings.length;
        for (int i2 = 0; i2 < n2 && !this.warnOnOutStatements((Sql)(object = object2[i2])); ++i2) {
        }
        object2 = System.lineSeparator();
        BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(this.outFile.getAbsolutePath(), new String[0]), new OpenOption[0]);
        object = null;
        try {
            if (this.logFile != null) {
                bufferedWriter.write("\n:OUT \"" + this.logFile + "\"" + (String)object2);
            }
            bufferedWriter.write(";".concat(String.valueOf(object2)));
            object2 = this.sqlStrings;
            n2 = this.sqlStrings.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                String string = object2[i3].toSql().replace("\r", "");
                bufferedWriter.write(string + "\n");
            }
            object2 = this.getEndDelimiter();
            if (object2 != null && ((String)object2).equals("\n/$")) {
                bufferedWriter.write("/\n");
            }
            bufferedWriter.write("GO\n");
            if (bufferedWriter == null) return;
        }
        catch (Throwable throwable) {
            try {
                object2 = throwable;
                object = throwable;
                throw object2;
            }
            catch (Throwable throwable2) {
                if (bufferedWriter == null) throw throwable2;
                if (object != null) {
                    try {
                        bufferedWriter.close();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        ((Throwable)object).addSuppressed(throwable3);
                    }
                    throw throwable2;
                } else {
                    bufferedWriter.close();
                }
                throw throwable2;
            }
        }
        bufferedWriter.close();
        return;
    }

    private boolean warnOnOutStatements(Sql stringArray) {
        stringArray = stringArray.toSql().split("\n");
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!stringArray[i2].matches("(?im)^\\s*:out .*")) continue;
            Scope.getCurrentScope().getLog(SqlcmdRunner.class).warning("OUT statements were detected in your script for change set " + this.changeSet.getId() + "::" + this.changeSet.getAuthor() + ".\nThis may prevent SQLCMD output from being included in the Liquibase logs");
            return true;
        }
        return false;
    }

    private String getEndDelimiter() {
        String string = null;
        for (Change change : this.changeSet.getChanges()) {
            if (change instanceof AbstractSQLChange && (string = ((AbstractSQLChange)change).getEndDelimiter()) != null) break;
        }
        return string;
    }
}

