/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.api.models;

import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.internal.restclient.model.ModelNodeAdapter;
import com.openshift.internal.restclient.model.ObjectReference;
import com.openshift.internal.util.JBossDmrExtentions;
import com.openshift.restclient.IClient;
import com.openshift.restclient.api.models.IEndpoints;
import com.openshift.restclient.model.IObjectReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class Endpoints
extends KubernetesResource
implements IEndpoints {
    public Endpoints(ModelNode node, IClient client, Map<String, String[]> overrideProperties) {
        super(node, client, overrideProperties);
    }

    @Override
    public List<IEndpoints.IEndpointSubset> getSubSets() {
        List root = this.get("subsets").asList();
        ArrayList<IEndpoints.IEndpointSubset> subsets = new ArrayList<IEndpoints.IEndpointSubset>(root.size());
        for (ModelNode n : root) {
            subsets.add(new EndpointSubset(n, this.getPropertyKeys()));
        }
        return subsets;
    }

    private static class EndpointPort
    extends ModelNodeAdapter
    implements IEndpoints.IEndpointPort {
        protected EndpointPort(ModelNode node, Map<String, String[]> propertyKeys) {
            super(node, propertyKeys);
        }

        @Override
        public String getName() {
            return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), "name");
        }

        @Override
        public int getPort() {
            return JBossDmrExtentions.asInt(this.getNode(), this.getPropertyKeys(), "port");
        }

        @Override
        public String getProtocol() {
            return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), "protocol");
        }
    }

    private static class EndpointAddress
    extends ModelNodeAdapter
    implements IEndpoints.IEndpointAddress {
        private static final String TARGET_REF = "targetRef";

        protected EndpointAddress(ModelNode node, Map<String, String[]> propertyKeys) {
            super(node, propertyKeys);
        }

        @Override
        public String getIP() {
            return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), "ip");
        }

        @Override
        public String getHostName() {
            return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), "hostname");
        }

        @Override
        public String getNodeName() {
            return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), "nodeName");
        }

        @Override
        public String getName() {
            return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), "name");
        }

        @Override
        public IObjectReference getTargetRef() {
            if (this.getNode().has(JBossDmrExtentions.getPath(this.getPropertyKeys(), TARGET_REF))) {
                ModelNode node = JBossDmrExtentions.get(this.getNode(), this.getPropertyKeys(), TARGET_REF);
                return new ObjectReference(node);
            }
            return null;
        }
    }

    private static class EndpointSubset
    extends ModelNodeAdapter
    implements IEndpoints.IEndpointSubset {
        protected EndpointSubset(ModelNode node, Map<String, String[]> propertyKeys) {
            super(node, propertyKeys);
        }

        @Override
        public List<IEndpoints.IEndpointAddress> getAddresses() {
            List root = JBossDmrExtentions.get(this.getNode(), this.getPropertyKeys(), "addresses").asList();
            ArrayList<IEndpoints.IEndpointAddress> addresses = new ArrayList<IEndpoints.IEndpointAddress>(root.size());
            for (ModelNode n : root) {
                addresses.add(new EndpointAddress(n, this.getPropertyKeys()));
            }
            return addresses;
        }

        @Override
        public List<IEndpoints.IEndpointAddress> getNotReadyAddresses() {
            List root = JBossDmrExtentions.get(this.getNode(), this.getPropertyKeys(), "notreadyaddresses").asList();
            ArrayList<IEndpoints.IEndpointAddress> addresses = new ArrayList<IEndpoints.IEndpointAddress>(root.size());
            for (ModelNode n : root) {
                addresses.add(new EndpointAddress(n, this.getPropertyKeys()));
            }
            return addresses;
        }

        @Override
        public List<IEndpoints.IEndpointPort> getPorts() {
            List root = JBossDmrExtentions.get(this.getNode(), this.getPropertyKeys(), "ports").asList();
            ArrayList<IEndpoints.IEndpointPort> ports = new ArrayList<IEndpoints.IEndpointPort>(root.size());
            for (ModelNode n : root) {
                ports.add(new EndpointPort(n, this.getPropertyKeys()));
            }
            return ports;
        }
    }
}

