/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.quarkus.vault.VaultException;
import io.quarkus.vault.runtime.VaultIOException;
import io.quarkus.vault.runtime.client.VaultClient;
import io.quarkus.vault.runtime.client.VaultClientException;
import io.smallrye.mutiny.TimeoutException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.unchecked.Unchecked;
import io.vertx.core.VertxException;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionException;

public abstract class VertxVaultClient
implements VaultClient {
    private static final HttpMethod LIST = HttpMethod.valueOf((String)"LIST");
    private static final List<String> ROOT_NAMESPACE_API = Arrays.asList("sys/init", "sys/license", "sys/leader", "sys/health", "sys/metrics", "sys/config/state", "sys/host-info", "sys/key-status", "sys/storage", "sys/storage/raft");
    private URL baseUrl;
    private Duration requestTimeout;
    private Optional<String> namespace;
    private ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());

    protected VertxVaultClient(URL baseUrl, Optional<String> namespace, Duration requestTimeout) {
        this.baseUrl = baseUrl;
        this.namespace = namespace;
        this.requestTimeout = requestTimeout;
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    protected abstract WebClient getWebClient();

    @Override
    public <T> Uni<T> put(String operation, String path, String token, Object body, int expectedCode) {
        HttpRequest<Buffer> request = this.builder(operation, HttpMethod.PUT, path, token);
        return this.exec(request, body, null, expectedCode);
    }

    @Override
    public <T> Uni<T> list(String operationName, String path, String token, Class<T> resultClass) {
        HttpRequest<Buffer> request = this.builder(operationName, LIST, path, token);
        return this.exec(request, resultClass);
    }

    @Override
    public <T> Uni<T> delete(String operationName, String path, String token, int expectedCode) {
        HttpRequest<Buffer> request = this.builder(operationName, HttpMethod.DELETE, path, token);
        return this.exec(request, expectedCode);
    }

    @Override
    public <T> Uni<T> post(String operationName, String path, String token, Object body, Class<T> resultClass, int expectedCode) {
        HttpRequest<Buffer> request = this.builder(operationName, HttpMethod.POST, path, token);
        return this.exec(request, body, resultClass, expectedCode);
    }

    @Override
    public <T> Uni<T> post(String operationName, String path, String token, Object body, Class<T> resultClass) {
        return this.post(operationName, path, token, Collections.emptyMap(), body, resultClass);
    }

    @Override
    public <T> Uni<T> post(String operationName, String path, String token, Map<String, String> headers, Object body, Class<T> resultClass) {
        HttpRequest<Buffer> request = this.builder(operationName, HttpMethod.POST, path, token);
        headers.forEach((arg_0, arg_1) -> request.putHeader(arg_0, arg_1));
        return this.exec(request, body, resultClass);
    }

    @Override
    public <T> Uni<T> post(String operationName, String path, String token, Object body, int expectedCode) {
        HttpRequest<Buffer> request = this.builder(operationName, HttpMethod.POST, path, token);
        return this.exec(request, body, null, expectedCode);
    }

    @Override
    public <T> Uni<T> put(String operationName, String path, String token, Object body, Class<T> resultClass) {
        HttpRequest<Buffer> request = this.builder(operationName, HttpMethod.PUT, path, token);
        return this.exec(request, body, resultClass);
    }

    @Override
    public <T> Uni<T> put(String operationName, String path, Object body, Class<T> resultClass) {
        HttpRequest<Buffer> request = this.builder(operationName, HttpMethod.PUT, path);
        return this.exec(request, body, resultClass);
    }

    @Override
    public <T> Uni<T> get(String operationName, String path, String token, Class<T> resultClass) {
        HttpRequest<Buffer> request = this.builder(operationName, HttpMethod.GET, path, token);
        return this.exec(request, resultClass);
    }

    @Override
    public <T> Uni<T> get(String operationName, String path, Map<String, String> queryParams, Class<T> resultClass) {
        HttpRequest<Buffer> request = this.builder(operationName, HttpMethod.GET, path, queryParams);
        return this.exec(request, resultClass);
    }

    @Override
    public Uni<Buffer> get(String operationName, String path, String token) {
        HttpRequest<Buffer> request = this.builder(operationName, HttpMethod.GET, path, token);
        return request.send().ifNoItem().after(this.getRequestTimeout()).fail().map(response -> {
            if (response.statusCode() != 200 && response.statusCode() != 204) {
                this.throwVaultException((HttpResponse<Buffer>)response);
            }
            return (Buffer)response.body();
        });
    }

    @Override
    public Uni<Integer> head(String operationName, String path) {
        HttpRequest<Buffer> request = this.builder(operationName, HttpMethod.HEAD, path);
        return this.exec(request);
    }

    @Override
    public Uni<Integer> head(String operationName, String path, Map<String, String> queryParams) {
        HttpRequest<Buffer> request = this.builder(operationName, HttpMethod.HEAD, path, queryParams);
        return this.exec(request);
    }

    private <T> Uni<T> exec(HttpRequest<Buffer> request, Class<T> resultClass) {
        return this.exec(request, null, resultClass, 200);
    }

    private <T> Uni<T> exec(HttpRequest<Buffer> request, int expectedCode) {
        return this.exec(request, null, null, expectedCode);
    }

    private <T> Uni<T> exec(HttpRequest<Buffer> request, Object body, Class<T> resultClass) {
        return this.exec(request, body, resultClass, 200);
    }

    private <T> Uni<T> exec(HttpRequest<Buffer> request, Object body, Class<T> resultClass, int expectedCode) {
        Uni send = body == null ? request.send() : request.sendBuffer(Buffer.buffer((String)this.requestBody(body)));
        return send.ifNoItem().after(this.getRequestTimeout()).failWith(java.util.concurrent.TimeoutException::new).map(Unchecked.function(response -> {
            Buffer responseBuffer;
            if (response.statusCode() != expectedCode) {
                this.throwVaultException((HttpResponse<Buffer>)response);
            }
            if ((responseBuffer = (Buffer)response.body()) != null) {
                return resultClass == null ? null : this.mapper.readValue(responseBuffer.toString(), resultClass);
            }
            return null;
        })).onFailure(JsonProcessingException.class).transform(VaultException::new).onFailure(TimeoutException.class).transform(VaultIOException::new).onFailure(VertxException.class).transform(e -> {
            if ("Connection was closed".equals(e.getMessage())) {
                return new VaultIOException((Throwable)e);
            }
            return e;
        }).onFailure(CompletionException.class).transform(e -> {
            if (e.getCause() instanceof ConnectException) {
                return new VaultIOException((Throwable)e);
            }
            if (e.getCause() instanceof java.util.concurrent.TimeoutException) {
                return new VaultIOException((Throwable)e);
            }
            return e;
        });
    }

    private Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    private Uni<Integer> exec(HttpRequest<Buffer> request) {
        return request.send().ifNoItem().after(this.getRequestTimeout()).failWith(java.util.concurrent.TimeoutException::new).onItem().transform(HttpResponse::statusCode);
    }

    private void throwVaultException(HttpResponse<Buffer> response) {
        String body = null;
        try {
            body = ((Buffer)response.body()).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new VaultClientException(response.statusCode(), body);
    }

    private HttpRequest<Buffer> builder(String operationName, HttpMethod method, String path, String token) {
        HttpRequest<Buffer> request = this.builder(operationName, method, path);
        if (token != null) {
            request.putHeader("X-Vault-Token", token);
        }
        if (this.namespace.isPresent() && !this.isRootNamespaceAPI(path)) {
            request.putHeader("X-Vault-Namespace", this.namespace.get());
        }
        return request;
    }

    private boolean isRootNamespaceAPI(String path) {
        return ROOT_NAMESPACE_API.stream().anyMatch(path::startsWith);
    }

    private HttpRequest<Buffer> builder(String operationName, HttpMethod method, String path) {
        RequestOptions options = new RequestOptions().setAbsoluteURI(this.getUrl(path)).setTraceOperation(operationName);
        return this.getWebClient().request(method, options);
    }

    private HttpRequest<Buffer> builder(String operationName, HttpMethod method, String path, Map<String, String> queryParams) {
        HttpRequest<Buffer> request = this.builder(operationName, method, path);
        if (queryParams != null) {
            queryParams.forEach((arg_0, arg_1) -> request.addQueryParam(arg_0, arg_1));
        }
        return request;
    }

    private String requestBody(Object body) {
        try {
            return this.mapper.writeValueAsString(body);
        }
        catch (JsonProcessingException e) {
            throw new VaultException(e);
        }
    }

    private URL getUrl(String path) {
        try {
            return new URL(this.baseUrl, "v1/" + path);
        }
        catch (MalformedURLException e) {
            throw new VaultException(e);
        }
    }
}

