/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcPrincipal;
import org.wildfly.security.http.oidc.OidcTokenStore;
import org.wildfly.security.http.oidc.RefreshableOidcSecurityContext;

public class OidcAccount
implements Serializable {
    private static final long serialVersionUID = -2871833856346510925L;
    private final OidcPrincipal<RefreshableOidcSecurityContext> principal;

    public OidcAccount(OidcPrincipal<RefreshableOidcSecurityContext> principal) {
        this.principal = principal;
    }

    public RefreshableOidcSecurityContext getOidcSecurityContext() {
        return this.principal.getOidcSecurityContext();
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Set<String> getRoles() {
        HashSet<String> roles = new HashSet<String>();
        return roles;
    }

    void setCurrentRequestInfo(OidcClientConfiguration deployment, OidcTokenStore tokenStore) {
        this.principal.getOidcSecurityContext().setCurrentRequestInfo(deployment, tokenStore);
    }

    public boolean checkActive() {
        RefreshableOidcSecurityContext session = this.getOidcSecurityContext();
        if (session.isActive() && !session.getOidcClientConfiguration().isAlwaysRefreshToken()) {
            ElytronMessages.log.debug("session is active");
            return true;
        }
        ElytronMessages.log.debug("session not active");
        return false;
    }

    boolean tryRefresh() {
        ElytronMessages.log.debug("Trying to refresh");
        RefreshableOidcSecurityContext securityContext = this.getOidcSecurityContext();
        if (securityContext == null) {
            ElytronMessages.log.debug("No security context. Aborting refresh.");
        }
        if (securityContext.refreshToken(false)) {
            ElytronMessages.log.debug("refresh succeeded");
            return true;
        }
        return this.checkActive();
    }
}

