/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration;

import java.util.stream.Stream;
import javax.ws.rs.core.Response;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.DynamicClientRegisteredContext;
import org.keycloak.services.clientpolicy.context.DynamicClientUpdatedContext;
import org.keycloak.services.clientregistration.ClientRegistrationAuth;
import org.keycloak.services.clientregistration.ClientRegistrationContext;
import org.keycloak.services.clientregistration.ClientRegistrationProvider;
import org.keycloak.services.clientregistration.ClientRegistrationTokenUtils;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicyManager;
import org.keycloak.services.clientregistration.policy.RegistrationAuth;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.validation.ValidationUtil;

public abstract class AbstractClientRegistrationProvider
implements ClientRegistrationProvider {
    protected KeycloakSession session;
    protected EventBuilder event;
    protected ClientRegistrationAuth auth;

    public AbstractClientRegistrationProvider(KeycloakSession session) {
        this.session = session;
    }

    public ClientRepresentation create(ClientRegistrationContext context) {
        ClientRepresentation client = context.getClient();
        this.event.event(EventType.CLIENT_REGISTER);
        RegistrationAuth registrationAuth = this.auth.requireCreate(context);
        try {
            RealmModel realm = this.session.getContext().getRealm();
            ClientModel clientModel = ClientManager.createClient(this.session, realm, client);
            if (client.getDefaultRoles() != null) {
                for (String name : client.getDefaultRoles()) {
                    clientModel.addDefaultRole(name);
                }
            }
            if (clientModel.isServiceAccountsEnabled()) {
                new ClientManager(new RealmManager(this.session)).enableServiceAccount(clientModel);
            }
            if (Boolean.TRUE.equals(client.getAuthorizationServicesEnabled())) {
                RepresentationToModel.createResourceServer((ClientModel)clientModel, (KeycloakSession)this.session, (boolean)true);
            }
            this.session.getContext().setClient(clientModel);
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new DynamicClientRegisteredContext(context, clientModel, this.auth.getJwt(), realm));
            ClientRegistrationPolicyManager.triggerAfterRegister(context, registrationAuth, clientModel);
            client = ModelToRepresentation.toRepresentation((ClientModel)clientModel, (KeycloakSession)this.session);
            client.setSecret(clientModel.getSecret());
            String registrationAccessToken = ClientRegistrationTokenUtils.updateRegistrationAccessToken(this.session, clientModel, registrationAuth);
            client.setRegistrationAccessToken(registrationAccessToken);
            if (this.auth.isInitialAccessToken()) {
                ClientInitialAccessModel initialAccessModel = this.auth.getInitialAccessModel();
                this.session.realms().decreaseRemainingCount(realm, initialAccessModel);
            }
            client.setDirectAccessGrantsEnabled(Boolean.valueOf(false));
            Stream defaultRolesNames = clientModel.getDefaultRolesStream();
            if (defaultRolesNames != null) {
                client.setDefaultRoles((String[])defaultRolesNames.toArray(String[]::new));
            }
            this.event.client(client.getClientId()).success();
            return client;
        }
        catch (ModelDuplicateException e) {
            throw new ErrorResponseException("invalid_client_metadata", "Client Identifier in use", Response.Status.BAD_REQUEST);
        }
        catch (ClientPolicyException cpe) {
            throw new ErrorResponseException(cpe.getError(), cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
    }

    public ClientRepresentation get(ClientModel client) {
        Stream defaultRolesNames;
        this.event.event(EventType.CLIENT_INFO);
        this.auth.requireView(client);
        ClientRepresentation rep = ModelToRepresentation.toRepresentation((ClientModel)client, (KeycloakSession)this.session);
        if (!Boolean.TRUE.equals(rep.isBearerOnly()) && !Boolean.TRUE.equals(rep.isPublicClient())) {
            rep.setSecret(client.getSecret());
        }
        if (this.auth.isRegistrationAccessToken()) {
            String registrationAccessToken = ClientRegistrationTokenUtils.updateTokenSignature(this.session, this.auth);
            rep.setRegistrationAccessToken(registrationAccessToken);
        }
        if ((defaultRolesNames = client.getDefaultRolesStream()) != null) {
            rep.setDefaultRoles((String[])defaultRolesNames.toArray(String[]::new));
        }
        this.event.client(client.getClientId()).success();
        return rep;
    }

    public ClientRepresentation update(String clientId, ClientRegistrationContext context) {
        ClientRepresentation rep = context.getClient();
        this.event.event(EventType.CLIENT_UPDATE).client(clientId);
        ClientModel client = this.session.getContext().getRealm().getClientByClientId(clientId);
        RegistrationAuth registrationAuth = this.auth.requireUpdate(context, client);
        if (!client.getClientId().equals(rep.getClientId())) {
            throw new ErrorResponseException("invalid_client_metadata", "Client Identifier modified", Response.Status.BAD_REQUEST);
        }
        RepresentationToModel.updateClient((ClientRepresentation)rep, (ClientModel)client, (KeycloakSession)this.session);
        RepresentationToModel.updateClientProtocolMappers((ClientRepresentation)rep, (ClientModel)client);
        if (rep.getDefaultRoles() != null) {
            client.updateDefaultRoles(rep.getDefaultRoles());
        }
        rep = ModelToRepresentation.toRepresentation((ClientModel)client, (KeycloakSession)this.session);
        rep.setSecret(client.getSecret());
        Stream defaultRolesNames = client.getDefaultRolesStream();
        if (defaultRolesNames != null) {
            rep.setDefaultRoles((String[])defaultRolesNames.toArray(String[]::new));
        }
        if (this.auth.isRegistrationAccessToken()) {
            String registrationAccessToken = ClientRegistrationTokenUtils.updateRegistrationAccessToken(this.session, client, this.auth.getRegistrationAuth());
            rep.setRegistrationAccessToken(registrationAccessToken);
        }
        try {
            this.session.getContext().setClient(client);
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new DynamicClientUpdatedContext(this.session, client, this.auth.getJwt(), client.getRealm()));
        }
        catch (ClientPolicyException cpe) {
            throw new ErrorResponseException(cpe.getError(), cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        ClientRegistrationPolicyManager.triggerAfterUpdate(context, registrationAuth, client);
        this.event.client(client.getClientId()).success();
        return rep;
    }

    public void delete(String clientId) {
        this.event.event(EventType.CLIENT_DELETE).client(clientId);
        ClientModel client = this.session.getContext().getRealm().getClientByClientId(clientId);
        this.auth.requireDelete(client);
        if (!new ClientManager(new RealmManager(this.session)).removeClient(this.session.getContext().getRealm(), client)) {
            throw new ForbiddenException();
        }
        this.event.client(client.getClientId()).success();
    }

    public void validateClient(ClientModel clientModel, OIDCClientRepresentation oidcClient, boolean create) {
        ValidationUtil.validateClient((KeycloakSession)this.session, (ClientModel)clientModel, (OIDCClientRepresentation)oidcClient, (boolean)create, r -> {
            this.session.getTransactionManager().setRollbackOnly();
            String errorCode = r.fieldHasError("redirectUris") ? "invalid_redirect_uri" : "invalid_client_metadata";
            throw new ErrorResponseException(errorCode, r.getAllErrorsAsString(), Response.Status.BAD_REQUEST);
        });
    }

    public void validateClient(ClientRepresentation clientRep, boolean create) {
        this.validateClient(this.session.getContext().getRealm().getClientByClientId(clientRep.getClientId()), null, create);
    }

    @Override
    public void setAuth(ClientRegistrationAuth auth) {
        this.auth = auth;
    }

    @Override
    public ClientRegistrationAuth getAuth() {
        return this.auth;
    }

    @Override
    public void setEvent(EventBuilder event) {
        this.event = event;
    }

    @Override
    public EventBuilder getEvent() {
        return this.event;
    }

    public void close() {
    }
}

