/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.SessionCodeChecks;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class LogoutSessionCodeChecks
extends SessionCodeChecks {
    public LogoutSessionCodeChecks(RealmModel realm, UriInfo uriInfo, HttpRequest request, ClientConnection clientConnection, KeycloakSession session, EventBuilder event, String code, String clientId, String tabId) {
        super(realm, uriInfo, request, clientConnection, session, event, null, code, null, clientId, tabId, null);
    }

    @Override
    protected void setClientToEvent(ClientModel client) {
    }

    @Override
    protected Response restartAuthenticationSessionFromCookie(RootAuthenticationSessionModel existingRootSession) {
        this.getEvent().error("session_expired");
        return ErrorPage.error(this.getSession(), null, Response.Status.BAD_REQUEST, "failedLogout", new Object[0]);
    }

    @Override
    protected boolean isActionActive(ClientSessionCode.ActionType actionType) {
        if (!this.getClientCode().isActionActive(actionType)) {
            this.getEvent().clone().error("expired_code");
            return false;
        }
        return true;
    }

    @Override
    protected boolean checkClientDisabled(ClientModel client) {
        return !client.isEnabled() && this.getClientCode() != null;
    }
}

