/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.client;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.client.MapClientAdapter;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.client.MapClientEntityImpl;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.common.TimeAdapter;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.provider.ProviderEvent;

public class MapClientProvider
implements ClientProvider {
    private static final Logger LOG = Logger.getLogger(MapClientProvider.class);
    private final KeycloakSession session;
    final MapKeycloakTransaction<MapClientEntity, ClientModel> tx;
    private final ConcurrentMap<String, ConcurrentMap<String, Long>> clientRegisteredNodesStore;

    public MapClientProvider(KeycloakSession session, MapStorage<MapClientEntity, ClientModel> clientStore, ConcurrentMap<String, ConcurrentMap<String, Long>> clientRegisteredNodesStore) {
        this.session = session;
        this.clientRegisteredNodesStore = clientRegisteredNodesStore;
        this.tx = clientStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
    }

    private ClientModel.ClientUpdatedEvent clientUpdatedEvent(final ClientModel c) {
        return new ClientModel.ClientUpdatedEvent(){

            public ClientModel getUpdatedClient() {
                return c;
            }

            public KeycloakSession getKeycloakSession() {
                return MapClientProvider.this.session;
            }
        };
    }

    private <T extends MapClientEntity> Function<T, ClientModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapClientAdapter(this.session, realm, (MapClientEntity)origEntity, (MapClientEntity)origEntity){
            final /* synthetic */ MapClientEntity val$origEntity;
            {
                this.val$origEntity = mapClientEntity;
                super(session, realm, entity);
            }

            public void updateClient() {
                LOG.tracef("updateClient(%s)%s", (Object)this.realm, (Object)this.val$origEntity.getId(), StackUtil.getShortStackTrace());
                this.session.getKeycloakSessionFactory().publish((ProviderEvent)MapClientProvider.this.clientUpdatedEvent(this));
            }

            public Map<String, Integer> getRegisteredNodes() {
                return Collections.unmodifiableMap(this.getMapForEntity().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> TimeAdapter.fromLongWithTimeInSecondsToIntegerWithTimeInSeconds((Long)e.getValue()))));
            }

            public void registerNode(String nodeHost, int registrationTime) {
                this.getMapForEntity().put(nodeHost, TimeAdapter.fromIntegerWithTimeInSecondsToLongWithTimeAsInSeconds(registrationTime));
            }

            public void unregisterNode(String nodeHost) {
                this.getMapForEntity().remove(nodeHost);
            }

            private ConcurrentMap<String, Long> getMapForEntity() {
                return MapClientProvider.this.clientRegisteredNodesStore.computeIfAbsent(((MapClientEntity)this.entity).getId(), k -> new ConcurrentHashMap());
            }
        };
    }

    private Predicate<MapClientEntity> entityRealmFilter(RealmModel realm) {
        if (realm == null || realm.getId() == null) {
            return c -> false;
        }
        String realmId = realm.getId();
        return entity -> Objects.equals(realmId, entity.getRealmId());
    }

    public Stream<ClientModel> getClientsStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = mcb.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(firstResult, maxResults, ClientModel.SearchableFields.CLIENT_ID)).map(this.entityToAdapterFunc(realm));
    }

    public Stream<ClientModel> getClientsStream(RealmModel realm) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = mcb.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        return this.tx.read(QueryParameters.withCriteria(mcb).orderBy(ClientModel.SearchableFields.CLIENT_ID, QueryParameters.Order.ASCENDING)).map(this.entityToAdapterFunc(realm));
    }

    public ClientModel addClient(RealmModel realm, String id, String clientId) {
        LOG.tracef("addClient(%s, %s, %s)%s", new Object[]{realm, id, clientId, StackUtil.getShortStackTrace()});
        if (id != null && this.tx.read(id) != null) {
            throw new ModelDuplicateException("Client with same id exists: " + id);
        }
        if (clientId != null && this.getClientByClientId(realm, clientId) != null) {
            throw new ModelDuplicateException("Client with same clientId in realm " + realm.getName() + " exists: " + clientId);
        }
        MapClientEntity entity = new MapClientEntityImpl();
        entity.setId(id);
        entity.setRealmId(realm.getId());
        entity.setClientId(clientId);
        entity.setEnabled(true);
        entity.setStandardFlowEnabled(true);
        entity = this.tx.create(entity);
        if (clientId == null) {
            clientId = entity.getId();
            entity.setClientId(clientId);
        }
        ClientModel resource = this.entityToAdapterFunc(realm).apply(entity);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)((ClientModel.ClientCreationEvent)() -> resource));
        resource.updateClient();
        return resource;
    }

    public Stream<ClientModel> getAlwaysDisplayInConsoleClientsStream(RealmModel realm) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(ClientModel.SearchableFields.ALWAYS_DISPLAY_IN_CONSOLE, ModelCriteriaBuilder.Operator.EQ, new Object[]{Boolean.TRUE});
        return this.tx.read(QueryParameters.withCriteria(mcb).orderBy(ClientModel.SearchableFields.CLIENT_ID, QueryParameters.Order.ASCENDING)).map(this.entityToAdapterFunc(realm));
    }

    public void removeClients(RealmModel realm) {
        LOG.tracef("removeClients(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        this.getClientsStream(realm).map(ClientModel::getId).collect(Collectors.toSet()).forEach(cid -> this.removeClient(realm, (String)cid));
    }

    public boolean removeClient(RealmModel realm, String id) {
        if (id == null) {
            return false;
        }
        LOG.tracef("removeClient(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        ClientModel client = this.getClientById(realm, id);
        if (client == null) {
            return false;
        }
        this.session.invalidate((InvalidationHandler.InvalidableObjectType)AbstractMapProviderFactory.MapProviderObjectType.CLIENT_BEFORE_REMOVE, new Object[]{realm, client});
        this.tx.delete(id);
        this.session.invalidate((InvalidationHandler.InvalidableObjectType)AbstractMapProviderFactory.MapProviderObjectType.CLIENT_AFTER_REMOVE, new Object[]{client});
        return true;
    }

    public long getClientsCount(RealmModel realm) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = mcb.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        return this.tx.getCount(QueryParameters.withCriteria(mcb));
    }

    public ClientModel getClientById(RealmModel realm, String id) {
        if (id == null) {
            return null;
        }
        LOG.tracef("getClientById(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        MapClientEntity entity = this.tx.read(id);
        return entity == null || !this.entityRealmFilter(realm).test(entity) ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    public ClientModel getClientByClientId(RealmModel realm, String clientId) {
        if (clientId == null) {
            return null;
        }
        LOG.tracef("getClientByClientId(%s, %s)%s", (Object)realm, (Object)clientId, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{clientId});
        return this.tx.read(QueryParameters.withCriteria(mcb)).map(this.entityToAdapterFunc(realm)).findFirst().orElse(null);
    }

    public Stream<ClientModel> searchClientsByClientIdStream(RealmModel realm, String clientId, Integer firstResult, Integer maxResults) {
        if (clientId == null) {
            return Stream.empty();
        }
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + clientId + "%"});
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(firstResult, maxResults, ClientModel.SearchableFields.CLIENT_ID)).map(this.entityToAdapterFunc(realm));
    }

    public Stream<ClientModel> searchClientsByAttributes(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb).compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            mcb = ((DefaultModelCriteria)mcb).compare(ClientModel.SearchableFields.ATTRIBUTE, ModelCriteriaBuilder.Operator.EQ, new Object[]{entry.getKey(), entry.getValue()});
        }
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(firstResult, maxResults, ClientModel.SearchableFields.CLIENT_ID)).map(this.entityToAdapterFunc(realm));
    }

    public void addClientScopes(RealmModel realm, ClientModel client, Set<ClientScopeModel> clientScopes, boolean defaultScope) {
        String id = client.getId();
        MapClientEntity entity = this.tx.read(id);
        if (entity == null) {
            return;
        }
        String clientProtocol = client.getProtocol() == null ? "openid-connect" : client.getProtocol();
        LOG.tracef("addClientScopes(%s, %s, %s, %b)%s", new Object[]{realm, client, clientScopes, defaultScope, StackUtil.getShortStackTrace()});
        Map<String, ClientScopeModel> existingClientScopes = this.getClientScopes(realm, client, true);
        existingClientScopes.putAll(this.getClientScopes(realm, client, false));
        clientScopes.stream().filter(clientScope -> !existingClientScopes.containsKey(clientScope.getName())).filter(clientScope -> Objects.equals(clientScope.getProtocol(), clientProtocol)).forEach(clientScope -> entity.setClientScope(clientScope.getId(), defaultScope));
    }

    public void removeClientScope(RealmModel realm, ClientModel client, ClientScopeModel clientScope) {
        String id = client.getId();
        MapClientEntity entity = this.tx.read(id);
        if (entity == null) {
            return;
        }
        LOG.tracef("removeClientScope(%s, %s, %s)%s", new Object[]{realm, client, clientScope, StackUtil.getShortStackTrace()});
        entity.removeClientScope(clientScope.getId());
    }

    public Map<String, ClientScopeModel> getClientScopes(RealmModel realm, ClientModel client, boolean defaultScopes) {
        String id = client.getId();
        MapClientEntity entity = this.tx.read(id);
        if (entity == null) {
            return null;
        }
        String clientProtocol = client.getProtocol() == null ? "openid-connect" : client.getProtocol();
        LOG.tracef("getClientScopes(%s, %s, %b)%s", new Object[]{realm, client, defaultScopes, StackUtil.getShortStackTrace()});
        return entity.getClientScopes(defaultScopes).map(clientScopeId -> this.session.clientScopes().getClientScopeById(realm, clientScopeId)).filter(Objects::nonNull).filter(clientScope -> Objects.equals(clientScope.getProtocol(), clientProtocol)).collect(Collectors.toMap(ClientScopeModel::getName, Function.identity()));
    }

    public Map<ClientModel, Set<String>> getAllRedirectUrisOfEnabledClients(RealmModel realm) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(ClientModel.SearchableFields.ENABLED, ModelCriteriaBuilder.Operator.EQ, new Object[]{Boolean.TRUE});
        try (Stream<MapClientEntity> st = this.tx.read(QueryParameters.withCriteria(mcb));){
            Map<ClientModel, Set<String>> map = st.filter(mce -> mce.getRedirectUris() != null && !mce.getRedirectUris().isEmpty()).collect(Collectors.toMap(mce -> this.entityToAdapterFunc(realm).apply((MapClientEntity)mce), mce -> new HashSet<String>(mce.getRedirectUris())));
            return map;
        }
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(ClientModel.SearchableFields.SCOPE_MAPPING_ROLE, ModelCriteriaBuilder.Operator.EQ, new Object[]{role.getId()});
        try (Stream<MapClientEntity> toRemove = this.tx.read(QueryParameters.withCriteria(mcb));){
            toRemove.map(clientEntity -> this.session.clients().getClientById(realm, clientEntity.getId())).filter(Objects::nonNull).forEach(clientModel -> clientModel.deleteScopeMapping(role));
        }
    }

    public void preRemove(RealmModel realm) {
        LOG.tracef("preRemove(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = mcb.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        this.tx.delete(QueryParameters.withCriteria(mcb));
    }

    public void close() {
    }
}

