/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.delegate;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelIllegalStateException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;

public class ClientModelLazyDelegate
implements ClientModel {
    private final Supplier<ClientModel> delegateSupplier;
    private final AtomicMarkableReference<ClientModel> delegate = new AtomicMarkableReference<Object>(null, false);

    public ClientModelLazyDelegate(Supplier<ClientModel> delegateSupplier) {
        this.delegateSupplier = delegateSupplier;
    }

    private ClientModel getDelegate() {
        ClientModel ref;
        if (!this.delegate.isMarked()) {
            this.delegate.compareAndSet(null, this.delegateSupplier == null ? null : this.delegateSupplier.get(), false, true);
        }
        if ((ref = this.delegate.getReference()) == null) {
            throw new ModelIllegalStateException("Invalid delegate obtained");
        }
        return ref;
    }

    @Override
    public void updateClient() {
        this.getDelegate().updateClient();
    }

    @Override
    public String getId() {
        return this.getDelegate().getId();
    }

    @Override
    public String getClientId() {
        return this.getDelegate().getClientId();
    }

    @Override
    public void setClientId(String clientId) {
        this.getDelegate().setClientId(clientId);
    }

    @Override
    public String getName() {
        return this.getDelegate().getName();
    }

    @Override
    public void setName(String name) {
        this.getDelegate().setName(name);
    }

    @Override
    public String getDescription() {
        return this.getDelegate().getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.getDelegate().setDescription(description);
    }

    @Override
    public boolean isEnabled() {
        return this.getDelegate().isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getDelegate().setEnabled(enabled);
    }

    @Override
    public boolean isAlwaysDisplayInConsole() {
        return this.getDelegate().isAlwaysDisplayInConsole();
    }

    @Override
    public void setAlwaysDisplayInConsole(boolean alwaysDisplayInConsole) {
        this.getDelegate().setAlwaysDisplayInConsole(alwaysDisplayInConsole);
    }

    @Override
    public boolean isSurrogateAuthRequired() {
        return this.getDelegate().isSurrogateAuthRequired();
    }

    @Override
    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        this.getDelegate().setSurrogateAuthRequired(surrogateAuthRequired);
    }

    @Override
    public Set<String> getWebOrigins() {
        return this.getDelegate().getWebOrigins();
    }

    @Override
    public void setWebOrigins(Set<String> webOrigins) {
        this.getDelegate().setWebOrigins(webOrigins);
    }

    @Override
    public void addWebOrigin(String webOrigin) {
        this.getDelegate().addWebOrigin(webOrigin);
    }

    @Override
    public void removeWebOrigin(String webOrigin) {
        this.getDelegate().removeWebOrigin(webOrigin);
    }

    @Override
    public Set<String> getRedirectUris() {
        return this.getDelegate().getRedirectUris();
    }

    @Override
    public void setRedirectUris(Set<String> redirectUris) {
        this.getDelegate().setRedirectUris(redirectUris);
    }

    @Override
    public void addRedirectUri(String redirectUri) {
        this.getDelegate().addRedirectUri(redirectUri);
    }

    @Override
    public void removeRedirectUri(String redirectUri) {
        this.getDelegate().removeRedirectUri(redirectUri);
    }

    @Override
    public String getManagementUrl() {
        return this.getDelegate().getManagementUrl();
    }

    @Override
    public void setManagementUrl(String url) {
        this.getDelegate().setManagementUrl(url);
    }

    @Override
    public String getRootUrl() {
        return this.getDelegate().getRootUrl();
    }

    @Override
    public void setRootUrl(String url) {
        this.getDelegate().setRootUrl(url);
    }

    @Override
    public String getBaseUrl() {
        return this.getDelegate().getBaseUrl();
    }

    @Override
    public void setBaseUrl(String url) {
        this.getDelegate().setBaseUrl(url);
    }

    @Override
    public boolean isBearerOnly() {
        return this.getDelegate().isBearerOnly();
    }

    @Override
    public void setBearerOnly(boolean only) {
        this.getDelegate().setBearerOnly(only);
    }

    @Override
    public int getNodeReRegistrationTimeout() {
        return this.getDelegate().getNodeReRegistrationTimeout();
    }

    @Override
    public void setNodeReRegistrationTimeout(int timeout) {
        this.getDelegate().setNodeReRegistrationTimeout(timeout);
    }

    @Override
    public String getClientAuthenticatorType() {
        return this.getDelegate().getClientAuthenticatorType();
    }

    @Override
    public void setClientAuthenticatorType(String clientAuthenticatorType) {
        this.getDelegate().setClientAuthenticatorType(clientAuthenticatorType);
    }

    @Override
    public boolean validateSecret(String secret) {
        return this.getDelegate().validateSecret(secret);
    }

    @Override
    public String getSecret() {
        return this.getDelegate().getSecret();
    }

    @Override
    public void setSecret(String secret) {
        this.getDelegate().setSecret(secret);
    }

    @Override
    public String getRegistrationToken() {
        return this.getDelegate().getRegistrationToken();
    }

    @Override
    public void setRegistrationToken(String registrationToken) {
        this.getDelegate().setRegistrationToken(registrationToken);
    }

    @Override
    public String getProtocol() {
        return this.getDelegate().getProtocol();
    }

    @Override
    public void setProtocol(String protocol) {
        this.getDelegate().setProtocol(protocol);
    }

    @Override
    public void setAttribute(String name, String value) {
        this.getDelegate().setAttribute(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.getDelegate().removeAttribute(name);
    }

    @Override
    public String getAttribute(String name) {
        return this.getDelegate().getAttribute(name);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.getDelegate().getAttributes();
    }

    @Override
    public String getAuthenticationFlowBindingOverride(String binding) {
        return this.getDelegate().getAuthenticationFlowBindingOverride(binding);
    }

    @Override
    public Map<String, String> getAuthenticationFlowBindingOverrides() {
        return this.getDelegate().getAuthenticationFlowBindingOverrides();
    }

    @Override
    public void removeAuthenticationFlowBindingOverride(String binding) {
        this.getDelegate().removeAuthenticationFlowBindingOverride(binding);
    }

    @Override
    public void setAuthenticationFlowBindingOverride(String binding, String flowId) {
        this.getDelegate().setAuthenticationFlowBindingOverride(binding, flowId);
    }

    @Override
    public boolean isFrontchannelLogout() {
        return this.getDelegate().isFrontchannelLogout();
    }

    @Override
    public void setFrontchannelLogout(boolean flag) {
        this.getDelegate().setFrontchannelLogout(flag);
    }

    @Override
    public boolean isFullScopeAllowed() {
        return this.getDelegate().isFullScopeAllowed();
    }

    @Override
    public void setFullScopeAllowed(boolean value) {
        this.getDelegate().setFullScopeAllowed(value);
    }

    @Override
    public boolean isPublicClient() {
        return this.getDelegate().isPublicClient();
    }

    @Override
    public void setPublicClient(boolean flag) {
        this.getDelegate().setPublicClient(flag);
    }

    @Override
    public boolean isConsentRequired() {
        return this.getDelegate().isConsentRequired();
    }

    @Override
    public void setConsentRequired(boolean consentRequired) {
        this.getDelegate().setConsentRequired(consentRequired);
    }

    @Override
    public boolean isStandardFlowEnabled() {
        return this.getDelegate().isStandardFlowEnabled();
    }

    @Override
    public void setStandardFlowEnabled(boolean standardFlowEnabled) {
        this.getDelegate().setStandardFlowEnabled(standardFlowEnabled);
    }

    @Override
    public boolean isImplicitFlowEnabled() {
        return this.getDelegate().isImplicitFlowEnabled();
    }

    @Override
    public void setImplicitFlowEnabled(boolean implicitFlowEnabled) {
        this.getDelegate().setImplicitFlowEnabled(implicitFlowEnabled);
    }

    @Override
    public boolean isDirectAccessGrantsEnabled() {
        return this.getDelegate().isDirectAccessGrantsEnabled();
    }

    @Override
    public void setDirectAccessGrantsEnabled(boolean directAccessGrantsEnabled) {
        this.getDelegate().setDirectAccessGrantsEnabled(directAccessGrantsEnabled);
    }

    @Override
    public boolean isServiceAccountsEnabled() {
        return this.getDelegate().isServiceAccountsEnabled();
    }

    @Override
    public void setServiceAccountsEnabled(boolean serviceAccountsEnabled) {
        this.getDelegate().setServiceAccountsEnabled(serviceAccountsEnabled);
    }

    @Override
    public RealmModel getRealm() {
        return this.getDelegate().getRealm();
    }

    @Override
    public void addClientScope(ClientScopeModel clientScope, boolean defaultScope) {
        this.getDelegate().addClientScope(clientScope, defaultScope);
    }

    @Override
    public void addClientScopes(Set<ClientScopeModel> clientScopes, boolean defaultScope) {
        this.getDelegate().addClientScopes(clientScopes, defaultScope);
    }

    @Override
    public void removeClientScope(ClientScopeModel clientScope) {
        this.getDelegate().removeClientScope(clientScope);
    }

    @Override
    public Map<String, ClientScopeModel> getClientScopes(boolean defaultScope) {
        return this.getDelegate().getClientScopes(defaultScope);
    }

    @Override
    public ClientScopeModel getDynamicClientScope(String scope) {
        return this.getDelegate().getDynamicClientScope(scope);
    }

    @Override
    public int getNotBefore() {
        return this.getDelegate().getNotBefore();
    }

    @Override
    public void setNotBefore(int notBefore) {
        this.getDelegate().setNotBefore(notBefore);
    }

    @Override
    public Map<String, Integer> getRegisteredNodes() {
        return this.getDelegate().getRegisteredNodes();
    }

    @Override
    public void registerNode(String nodeHost, int registrationTime) {
        this.getDelegate().registerNode(nodeHost, registrationTime);
    }

    @Override
    public void unregisterNode(String nodeHost) {
        this.getDelegate().unregisterNode(nodeHost);
    }

    @Override
    public boolean isDisplayOnConsentScreen() {
        return this.getDelegate().isDisplayOnConsentScreen();
    }

    @Override
    public String getConsentScreenText() {
        return this.getDelegate().getConsentScreenText();
    }

    @Override
    public void setDisplayOnConsentScreen(boolean displayOnConsentScreen) {
        this.getDelegate().setDisplayOnConsentScreen(displayOnConsentScreen);
    }

    @Override
    public void setConsentScreenText(String consentScreenText) {
        this.getDelegate().setConsentScreenText(consentScreenText);
    }

    @Override
    public String getGuiOrder() {
        return this.getDelegate().getGuiOrder();
    }

    @Override
    public void setGuiOrder(String guiOrder) {
        this.getDelegate().setGuiOrder(guiOrder);
    }

    @Override
    public boolean isIncludeInTokenScope() {
        return this.getDelegate().isIncludeInTokenScope();
    }

    @Override
    public void setIncludeInTokenScope(boolean includeInTokenScope) {
        this.getDelegate().setIncludeInTokenScope(includeInTokenScope);
    }

    @Override
    public boolean isDynamicScope() {
        return this.getDelegate().isDynamicScope();
    }

    @Override
    public void setIsDynamicScope(boolean isDynamicScope) {
        this.getDelegate().setIsDynamicScope(isDynamicScope);
    }

    @Override
    public String getDynamicScopeRegexp() {
        return this.getDelegate().getDynamicScopeRegexp();
    }

    @Override
    public Stream<RoleModel> getScopeMappingsStream() {
        return this.getDelegate().getScopeMappingsStream();
    }

    @Override
    public Stream<RoleModel> getRealmScopeMappingsStream() {
        return this.getDelegate().getRealmScopeMappingsStream();
    }

    @Override
    public void addScopeMapping(RoleModel role) {
        this.getDelegate().addScopeMapping(role);
    }

    @Override
    public void deleteScopeMapping(RoleModel role) {
        this.getDelegate().deleteScopeMapping(role);
    }

    @Override
    public boolean hasDirectScope(RoleModel role) {
        return this.getDelegate().hasDirectScope(role);
    }

    @Override
    public boolean hasScope(RoleModel role) {
        return this.getDelegate().hasScope(role);
    }

    @Override
    public RoleModel getRole(String name) {
        return this.getDelegate().getRole(name);
    }

    @Override
    public RoleModel addRole(String name) {
        return this.getDelegate().addRole(name);
    }

    @Override
    public RoleModel addRole(String id, String name) {
        return this.getDelegate().addRole(id, name);
    }

    @Override
    public boolean removeRole(RoleModel role) {
        return this.getDelegate().removeRole(role);
    }

    @Override
    public Stream<RoleModel> getRolesStream() {
        return this.getDelegate().getRolesStream();
    }

    @Override
    public Stream<RoleModel> getRolesStream(Integer firstResult, Integer maxResults) {
        return this.getDelegate().getRolesStream(firstResult, maxResults);
    }

    @Override
    public Stream<RoleModel> searchForRolesStream(String search, Integer first, Integer max) {
        return this.getDelegate().searchForRolesStream(search, first, max);
    }

    @Override
    public Stream<String> getDefaultRolesStream() {
        return this.getDelegate().getDefaultRolesStream();
    }

    @Override
    public void addDefaultRole(String name) {
        this.getDelegate().addDefaultRole(name);
    }

    @Override
    public void updateDefaultRoles(String ... defaultRoles) {
        this.getDelegate().updateDefaultRoles(defaultRoles);
    }

    @Override
    public void removeDefaultRoles(String ... defaultRoles) {
        this.getDelegate().removeDefaultRoles(defaultRoles);
    }

    @Override
    public Stream<ProtocolMapperModel> getProtocolMappersStream() {
        return this.getDelegate().getProtocolMappersStream();
    }

    @Override
    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        return this.getDelegate().addProtocolMapper(model);
    }

    @Override
    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        this.getDelegate().removeProtocolMapper(mapping);
    }

    @Override
    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        this.getDelegate().updateProtocolMapper(mapping);
    }

    @Override
    public ProtocolMapperModel getProtocolMapperById(String id) {
        return this.getDelegate().getProtocolMapperById(id);
    }

    @Override
    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        return this.getDelegate().getProtocolMapperByName(protocol, name);
    }

    public static class WithId
    extends ClientModelLazyDelegate {
        private final String id;

        public WithId(String id, Supplier<ClientModel> delegateSupplier) {
            super(delegateSupplier);
            this.id = id;
        }

        public WithId(KeycloakSession session, RealmModel realm, String id) {
            super(() -> session.clients().getClientById(realm, id));
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof ClientModel)) {
                return false;
            }
            ClientModel that = (ClientModel)o;
            return that.getId().equals(this.getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }
    }
}

