/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate.validators;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.validate.AbstractStringValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidationResult;
import org.keycloak.validate.ValidatorConfig;

public class OptionsValidator
extends AbstractStringValidator
implements ConfiguredProvider {
    public static final OptionsValidator INSTANCE = new OptionsValidator();
    public static final String ID = "options";
    public static final String KEY_OPTIONS = "options";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    @Override
    public String getId() {
        return "options";
    }

    @Override
    protected void doValidate(String value, String inputHint, ValidationContext context, ValidatorConfig config) {
        List<String> allowedValues = config.getStringListOrDefault("options");
        if (allowedValues == null || !allowedValues.contains(value)) {
            context.addError(new ValidationError("options", inputHint, "error-invalid-value"));
        }
    }

    @Override
    public ValidationResult validateConfig(KeycloakSession session, ValidatorConfig config) {
        LinkedHashSet<ValidationError> errors = new LinkedHashSet<ValidationError>();
        if (config == null || !config.containsKey("options")) {
            errors.add(new ValidationError("options", "options", "error-validator-config-missing-value"));
        } else if (!(config.get("options") instanceof List)) {
            errors.add(new ValidationError("options", "options", "error-validator-config-invalid-value", "must be list of values"));
        }
        return new ValidationResult(errors);
    }

    @Override
    public String getHelpText() {
        return "Options validator";
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("options");
        property.setLabel("Options");
        property.setHelpText("List of allowed options");
        property.setType("MultivaluedString");
        configProperties.add(property);
    }
}

