/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import java.util.Optional;
import org.keycloak.common.crypto.FipsMode;
import org.keycloak.config.SecurityOptions;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;

final class SecurityPropertyMappers {
    private SecurityPropertyMappers() {
    }

    public static PropertyMapper[] getMappers() {
        return new PropertyMapper[]{PropertyMapper.fromOption(SecurityOptions.FIPS_MODE).transformer(SecurityPropertyMappers::resolveFipsMode).paramLabel("mode").build()};
    }

    private static Optional<String> resolveFipsMode(Optional<String> value, ConfigSourceInterceptorContext context) {
        if (value.isEmpty()) {
            return Optional.of(FipsMode.disabled.toString());
        }
        return Optional.of(FipsMode.valueOf((String)value.get()).toString());
    }

    private static Optional<String> resolveSecurityProvider(Optional<String> value, ConfigSourceInterceptorContext configSourceInterceptorContext) {
        FipsMode fipsMode = value.map(FipsMode::valueOf).orElse(FipsMode.disabled);
        if (fipsMode.isFipsEnabled()) {
            return Optional.of("BCFIPS");
        }
        return value;
    }
}

