/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm.entity;

import java.util.HashMap;
import java.util.Map;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.realm.entity.MapRequiredActionProviderEntityImpl;
import org.keycloak.models.utils.KeycloakModelUtils;

@DeepCloner.Root
public interface MapRequiredActionProviderEntity
extends UpdatableEntity,
AbstractEntity {
    public static MapRequiredActionProviderEntity fromModel(RequiredActionProviderModel model) {
        if (model == null) {
            return null;
        }
        MapRequiredActionProviderEntityImpl entity = new MapRequiredActionProviderEntityImpl();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setAlias(model.getAlias());
        entity.setName(model.getName());
        entity.setProviderId(model.getProviderId());
        entity.setPriority(model.getPriority());
        entity.setEnabled(model.isEnabled());
        entity.setDefaultAction(model.isDefaultAction());
        entity.setConfig(model.getConfig());
        return entity;
    }

    public static RequiredActionProviderModel toModel(MapRequiredActionProviderEntity entity) {
        if (entity == null) {
            return null;
        }
        RequiredActionProviderModel model = new RequiredActionProviderModel();
        model.setId(entity.getId());
        model.setAlias(entity.getAlias());
        model.setName(entity.getName());
        model.setProviderId(entity.getProviderId());
        Integer priority = entity.getPriority();
        model.setPriority(priority == null ? 0 : priority);
        Boolean enabled = entity.isEnabled();
        model.setEnabled(enabled == null ? false : enabled);
        Boolean defaultAction = entity.isDefaultAction();
        model.setDefaultAction(defaultAction == null ? false : defaultAction);
        Map<String, String> config = entity.getConfig();
        model.setConfig(config == null ? new HashMap() : new HashMap<String, String>(config));
        return model;
    }

    public String getAlias();

    public void setAlias(String var1);

    public String getName();

    public void setName(String var1);

    public String getProviderId();

    public void setProviderId(String var1);

    public Integer getPriority();

    public void setPriority(Integer var1);

    public Boolean isEnabled();

    public void setEnabled(Boolean var1);

    public Boolean isDefaultAction();

    public void setDefaultAction(Boolean var1);

    public Map<String, String> getConfig();

    public void setConfig(Map<String, String> var1);
}

