/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util;

import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.parser.CCJSqlParserUtil;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.AllColumns;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Join;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectBody;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectExpressionItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItem;

public final class SelectUtils {
    private static final String NOT_SUPPORTED_YET = "Not supported yet.";

    private SelectUtils() {
    }

    public static Select buildSelectFromTableAndExpressions(Table table, Expression ... expressionArray) {
        SelectItem[] selectItemArray = new SelectItem[expressionArray.length];
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            selectItemArray[i2] = new SelectExpressionItem(expressionArray[i2]);
        }
        return SelectUtils.buildSelectFromTableAndSelectItems(table, selectItemArray);
    }

    public static Select buildSelectFromTableAndExpressions(Table table, String ... stringArray) {
        SelectItem[] selectItemArray = new SelectItem[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            selectItemArray[i2] = new SelectExpressionItem(CCJSqlParserUtil.parseExpression(stringArray[i2]));
        }
        return SelectUtils.buildSelectFromTableAndSelectItems(table, selectItemArray);
    }

    public static Select buildSelectFromTableAndSelectItems(Table aSTNodeAccessImpl, SelectItem ... selectItemArray) {
        aSTNodeAccessImpl = new PlainSelect().addSelectItems(selectItemArray).withFromItem((FromItem)((Object)aSTNodeAccessImpl));
        return new Select().withSelectBody((SelectBody)((Object)aSTNodeAccessImpl));
    }

    public static Select buildSelectFromTable(Table table) {
        return SelectUtils.buildSelectFromTableAndSelectItems(table, new AllColumns());
    }

    public static void addExpression(Select select, Expression expression) {
        if (select.getSelectBody() instanceof PlainSelect) {
            select.getSelectBody(PlainSelect.class).getSelectItems().add(new SelectExpressionItem(expression));
            return;
        }
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    public static Join addJoin(Select select, Table aSTNodeAccessImpl, Expression expression) {
        if (select.getSelectBody() instanceof PlainSelect) {
            aSTNodeAccessImpl = new Join().withRightItem((FromItem)((Object)aSTNodeAccessImpl)).addOnExpression(expression);
            select.getSelectBody(PlainSelect.class).addJoins(new Join[]{aSTNodeAccessImpl});
            return aSTNodeAccessImpl;
        }
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    public static void addGroupBy(Select select, Expression expression) {
        if (select.getSelectBody() instanceof PlainSelect) {
            select.getSelectBody(PlainSelect.class).addGroupByColumnReference(expression);
            return;
        }
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }
}

