/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate.validators;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.validate.AbstractStringValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class EmailValidator
extends AbstractStringValidator
implements ConfiguredProvider {
    public static final String ID = "email";
    public static final EmailValidator INSTANCE = new EmailValidator();
    public static final String MESSAGE_INVALID_EMAIL = "error-invalid-email";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("[a-zA-Z0-9!#$%&'*+/=?^_`{|}~.-]+@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*");

    @Override
    public String getId() {
        return ID;
    }

    @Override
    protected void doValidate(String value, String inputHint, ValidationContext context, ValidatorConfig config) {
        if (!EMAIL_PATTERN.matcher(value).matches()) {
            context.addError(new ValidationError(ID, inputHint, MESSAGE_INVALID_EMAIL, value));
        }
    }

    @Override
    public String getHelpText() {
        return "Email format validator";
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return Collections.emptyList();
    }
}

