/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.naming.AuthenticationException;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialAuthentication;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.LegacyUserCredentialManager;
import org.keycloak.federation.kerberos.impl.KerberosUsernamePasswordAuthenticator;
import org.keycloak.federation.kerberos.impl.SPNEGOAuthenticator;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.utils.ReadOnlyUserModelDelegate;
import org.keycloak.policy.PasswordPolicyManagerProvider;
import org.keycloak.policy.PolicyError;
import org.keycloak.storage.DatastoreProvider;
import org.keycloak.storage.LegacyStoreManagers;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStoragePrivateUtil;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.UserStorageUtil;
import org.keycloak.storage.adapter.InMemoryUserAdapter;
import org.keycloak.storage.adapter.UpdateOnlyChangeUserModelDelegate;
import org.keycloak.storage.ldap.LDAPStorageProviderFactory;
import org.keycloak.storage.ldap.LDAPStorageUserManager;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.LDAPWritesOnlyUserModelDelegate;
import org.keycloak.storage.ldap.ReadonlyLDAPUserModelDelegate;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.Condition;
import org.keycloak.storage.ldap.idm.query.EscapeStrategy;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQueryConditionsBuilder;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPIdentityStore;
import org.keycloak.storage.ldap.kerberos.LDAPProviderKerberosConfig;
import org.keycloak.storage.ldap.mappers.LDAPMappersComparator;
import org.keycloak.storage.ldap.mappers.LDAPOperationDecorator;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapperManager;
import org.keycloak.storage.ldap.mappers.PasswordUpdateCallback;
import org.keycloak.storage.user.ImportedUserValidation;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.storage.user.UserQueryProvider;
import org.keycloak.storage.user.UserRegistrationProvider;
import org.keycloak.utils.StreamsUtil;

public class LDAPStorageProvider
implements UserStorageProvider,
CredentialInputValidator,
CredentialInputUpdater,
CredentialAuthentication,
UserLookupProvider,
UserRegistrationProvider,
UserQueryProvider,
ImportedUserValidation {
    private static final Logger logger = Logger.getLogger(LDAPStorageProvider.class);
    private static final int DEFAULT_MAX_RESULTS = 0x3FFFFFFF;
    protected LDAPStorageProviderFactory factory;
    protected KeycloakSession session;
    protected UserStorageProviderModel model;
    protected LDAPIdentityStore ldapIdentityStore;
    protected UserStorageProvider.EditMode editMode;
    protected LDAPProviderKerberosConfig kerberosConfig;
    protected PasswordUpdateCallback updater;
    protected LDAPStorageMapperManager mapperManager;
    protected LDAPStorageUserManager userManager;
    private LDAPMappersComparator ldapMappersComparator;
    protected final Set<String> supportedCredentialTypes = new HashSet<String>();

    public LDAPStorageProvider(LDAPStorageProviderFactory factory, KeycloakSession session, ComponentModel model, LDAPIdentityStore ldapIdentityStore) {
        this.factory = factory;
        this.session = session;
        this.model = new UserStorageProviderModel(model);
        this.ldapIdentityStore = ldapIdentityStore;
        this.kerberosConfig = new LDAPProviderKerberosConfig(model);
        this.editMode = ldapIdentityStore.getConfig().getEditMode();
        this.mapperManager = new LDAPStorageMapperManager(this);
        this.userManager = new LDAPStorageUserManager(this);
        this.supportedCredentialTypes.add("password");
        if (this.kerberosConfig.isAllowKerberosAuthentication()) {
            this.supportedCredentialTypes.add("kerberos");
        }
        this.ldapMappersComparator = new LDAPMappersComparator(this.getLdapIdentityStore().getConfig());
    }

    public void setUpdater(PasswordUpdateCallback updater) {
        this.updater = updater;
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public LDAPIdentityStore getLdapIdentityStore() {
        return this.ldapIdentityStore;
    }

    public UserStorageProvider.EditMode getEditMode() {
        return this.editMode;
    }

    public UserStorageProviderModel getModel() {
        return this.model;
    }

    public LDAPStorageMapperManager getMapperManager() {
        return this.mapperManager;
    }

    public LDAPStorageUserManager getUserManager() {
        return this.userManager;
    }

    public UserModel validate(RealmModel realm, UserModel local) {
        LDAPObject ldapObject = this.loadAndValidateUser(realm, local);
        if (ldapObject == null) {
            return null;
        }
        return this.proxy(realm, local, ldapObject, false);
    }

    protected UserModel proxy(RealmModel realm, UserModel local, LDAPObject ldapObject, boolean newUser) {
        LegacyStoreManagers datastoreProvider;
        UserModel existing = this.userManager.getManagedProxiedUser(local.getId());
        if (existing != null) {
            return existing;
        }
        if (local instanceof CachedUserModel && (existing = this.userManager.getManagedProxiedUser((local = (datastoreProvider = (LegacyStoreManagers)this.session.getProvider(DatastoreProvider.class)).userStorageManager().getUserById(realm, local.getId())).getId())) != null) {
            return existing;
        }
        Object proxied = local;
        this.checkDNChanged(realm, local, ldapObject);
        switch (this.editMode) {
            case READ_ONLY: {
                if (this.model.isImportEnabled()) {
                    proxied = new ReadonlyLDAPUserModelDelegate(local);
                    break;
                }
                proxied = new ReadOnlyUserModelDelegate(local);
                break;
            }
            case WRITABLE: 
            case UNSYNCED: {
                if (this.model.isImportEnabled() || newUser) break;
                ReadOnlyUserModelDelegate readOnlyDelegate = new ReadOnlyUserModelDelegate(local, ModelException::new);
                proxied = new LDAPWritesOnlyUserModelDelegate((UserModel)readOnlyDelegate, this);
            }
        }
        AtomicReference<UserModel> proxy = new AtomicReference<UserModel>((UserModel)proxied);
        realm.getComponentsStream(this.model.getId(), LDAPStorageMapper.class.getName()).sorted(this.ldapMappersComparator.sortAsc()).forEachOrdered(mapperModel -> {
            LDAPStorageMapper ldapMapper = this.mapperManager.getMapper((ComponentModel)mapperModel);
            proxy.set(ldapMapper.proxy(ldapObject, (UserModel)proxy.get(), realm));
        });
        proxied = proxy.get();
        if (!this.model.isImportEnabled()) {
            proxied = new UpdateOnlyChangeUserModelDelegate(proxied);
        }
        this.userManager.setManagedProxiedUser((UserModel)proxied, ldapObject);
        return proxied;
    }

    private void checkDNChanged(RealmModel realm, UserModel local, LDAPObject ldapObject) {
        String ldapDn;
        String dnFromDB = local.getFirstAttribute("LDAP_ENTRY_DN");
        String string = ldapDn = ldapObject.getDn() == null ? null : ldapObject.getDn().toString();
        if (ldapDn != null && !ldapDn.equals(dnFromDB)) {
            logger.debugf("Updated LDAP DN of user '%s' to '%s'", (Object)local.getUsername(), (Object)ldapDn);
            local.setSingleAttribute("LDAP_ENTRY_DN", ldapDn);
            UserCache userCache = UserStorageUtil.userCache((KeycloakSession)this.session);
            if (userCache != null) {
                userCache.evict(realm, local);
            }
        }
    }

    public boolean supportsCredentialAuthenticationFor(String type) {
        return type.equals("kerberos") && this.kerberosConfig.isAllowKerberosAuthentication();
    }

    public Stream<UserModel> searchForUserByUserAttributeStream(RealmModel realm, String attrName, String attrValue) {
        try (LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);){
            LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
            Condition attrCondition = conditionsBuilder.equal(attrName, attrValue, EscapeStrategy.DEFAULT);
            ldapQuery.addWhereCondition(attrCondition);
            List<LDAPObject> ldapObjects = ldapQuery.getResultList();
            Stream<UserModel> stream = ldapObjects.stream().map(ldapUser -> {
                String ldapUsername = LDAPUtils.getUsername(ldapUser, this.ldapIdentityStore.getConfig());
                UserModel localUser = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session).getUserByUsername(realm, ldapUsername);
                if (localUser == null) {
                    return this.importUserFromLDAP(this.session, realm, (LDAPObject)ldapUser);
                }
                return this.proxy(realm, localUser, (LDAPObject)ldapUser, false);
            });
            return stream;
        }
    }

    public boolean synchronizeRegistrations() {
        return "true".equalsIgnoreCase((String)this.model.getConfig().getFirst((Object)"syncRegistrations")) && this.editMode == UserStorageProvider.EditMode.WRITABLE;
    }

    public UserModel addUser(RealmModel realm, String username) {
        UserModel user;
        if (!this.synchronizeRegistrations()) {
            return null;
        }
        if (this.model.isImportEnabled()) {
            user = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session).addUser(realm, username);
            user.setFederationLink(this.model.getId());
        } else {
            user = new InMemoryUserAdapter(this.session, realm, new StorageId(this.model.getId(), username).getId());
            user.setUsername(username);
        }
        LDAPObject ldapUser = LDAPUtils.addUserToLDAP(this, realm, user, ldapObject -> {
            LDAPUtils.checkUuid(ldapObject, this.ldapIdentityStore.getConfig());
            user.setSingleAttribute("LDAP_ID", ldapObject.getUuid());
            user.setSingleAttribute("LDAP_ENTRY_DN", ldapObject.getDn().toString());
        });
        UserModel proxy = this.proxy(realm, user, ldapUser, true);
        proxy.grantRole(realm.getDefaultRole());
        realm.getDefaultGroupsStream().forEach(arg_0 -> ((UserModel)proxy).joinGroup(arg_0));
        realm.getRequiredActionProvidersStream().filter(RequiredActionProviderModel::isEnabled).filter(RequiredActionProviderModel::isDefaultAction).map(RequiredActionProviderModel::getAlias).forEachOrdered(arg_0 -> ((UserModel)proxy).addRequiredAction(arg_0));
        return proxy;
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        if (this.editMode == UserStorageProvider.EditMode.READ_ONLY || this.editMode == UserStorageProvider.EditMode.UNSYNCED) {
            logger.warnf("User '%s' can't be deleted in LDAP as editMode is '%s'. Deleting user just from Keycloak DB, but he will be re-imported from LDAP again once searched in Keycloak", (Object)user.getUsername(), (Object)this.editMode.toString());
            return true;
        }
        LDAPObject ldapObject = this.loadAndValidateUser(realm, user);
        if (ldapObject == null) {
            logger.warnf("User '%s' can't be deleted from LDAP as it doesn't exist here", (Object)user.getUsername());
            return false;
        }
        this.ldapIdentityStore.remove(ldapObject);
        this.userManager.removeManagedUserEntry(user.getId());
        return true;
    }

    public UserModel getUserById(RealmModel realm, String id) {
        UserModel alreadyLoadedInSession = this.userManager.getManagedProxiedUser(id);
        if (alreadyLoadedInSession != null) {
            return alreadyLoadedInSession;
        }
        StorageId storageId = new StorageId(id);
        return this.getUserByUsername(realm, storageId.getExternalId());
    }

    public int getUsersCount(RealmModel realm) {
        return 0;
    }

    public Stream<UserModel> getUsersStream(RealmModel realm) {
        return Stream.empty();
    }

    public Stream<UserModel> getUsersStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        return Stream.empty();
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, String search, Integer firstResult, Integer maxResults) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("keycloak.session.realm.users.query.search", search);
        return this.searchForUserStream(realm, attributes, firstResult, maxResults);
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, Map<String, String> params, Integer firstResult, Integer maxResults) {
        String search = params.get("keycloak.session.realm.users.query.search");
        if (search != null) {
            int spaceIndex = search.lastIndexOf(32);
            if (spaceIndex > -1) {
                String firstName = search.substring(0, spaceIndex).trim();
                String lastName = search.substring(spaceIndex).trim();
                params.put("firstName", firstName);
                params.put("lastName", lastName);
            } else if (search.indexOf(64) > -1) {
                params.put("username", search.trim().toLowerCase());
                params.put("email", search.trim().toLowerCase());
            } else {
                params.put("lastName", search.trim());
                params.put("username", search.trim().toLowerCase());
            }
        }
        Stream<LDAPObject> stream = this.searchLDAP(realm, params).stream().filter(ldapObject -> {
            String ldapUsername = LDAPUtils.getUsername(ldapObject, this.ldapIdentityStore.getConfig());
            return UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session).getUserByUsername(realm, ldapUsername) == null;
        });
        return StreamsUtil.paginatedStream(stream, (Integer)firstResult, (Integer)maxResults).map(ldapObject -> this.importUserFromLDAP(this.session, realm, (LDAPObject)ldapObject));
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group, Integer firstResult, Integer maxResults) {
        int first = firstResult == null ? 0 : firstResult;
        int max = maxResults == null ? 0x3FFFFFFF : maxResults;
        return realm.getComponentsStream(this.model.getId(), LDAPStorageMapper.class.getName()).sorted(this.ldapMappersComparator.sortAsc()).map(mapperModel -> this.mapperManager.getMapper((ComponentModel)mapperModel).getGroupMembers(realm, group, first, max)).filter(((Predicate<List>)List::isEmpty).negate()).map(Collection::stream).findFirst().orElse(Stream.empty());
    }

    public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        int first = firstResult == null ? 0 : firstResult;
        int max = maxResults == null ? 0x3FFFFFFF : maxResults;
        return realm.getComponentsStream(this.model.getId(), LDAPStorageMapper.class.getName()).sorted(this.ldapMappersComparator.sortAsc()).map(mapperModel -> this.mapperManager.getMapper((ComponentModel)mapperModel).getRoleMembers(realm, role, first, max)).filter(((Predicate<List>)List::isEmpty).negate()).map(Collection::stream).findFirst().orElse(Stream.empty());
    }

    public List<UserModel> loadUsersByUsernames(List<String> usernames, RealmModel realm) {
        ArrayList<UserModel> result = new ArrayList<UserModel>();
        for (String username : usernames) {
            UserModel kcUser = this.session.users().getUserByUsername(realm, username);
            if (kcUser == null) {
                logger.warnf("User '%s' referenced by membership wasn't found in LDAP", (Object)username);
                continue;
            }
            if (this.model.isImportEnabled() && !this.model.getId().equals(kcUser.getFederationLink())) {
                logger.warnf("Incorrect federation provider of user '%s'", (Object)kcUser.getUsername());
                continue;
            }
            result.add(kcUser);
        }
        return result;
    }

    protected List<LDAPObject> searchLDAP(RealmModel realm, Map<String, String> attributes) {
        List<LDAPObject> ldapObjects;
        LDAPQueryConditionsBuilder conditionsBuilder;
        LDAPQuery ldapQuery;
        ArrayList<LDAPObject> results = new ArrayList<LDAPObject>();
        if (attributes.containsKey("username")) {
            ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);
            try {
                conditionsBuilder = new LDAPQueryConditionsBuilder();
                Condition usernameCondition = conditionsBuilder.equal("username", attributes.get("username"), EscapeStrategy.NON_ASCII_CHARS_ONLY);
                ldapQuery.addWhereCondition(usernameCondition);
                ldapObjects = ldapQuery.getResultList();
                results.addAll(ldapObjects);
            }
            finally {
                if (ldapQuery != null) {
                    ldapQuery.close();
                }
            }
        }
        if (attributes.containsKey("email")) {
            ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);
            try {
                conditionsBuilder = new LDAPQueryConditionsBuilder();
                Condition emailCondition = conditionsBuilder.equal("email", attributes.get("email"), EscapeStrategy.NON_ASCII_CHARS_ONLY);
                ldapQuery.addWhereCondition(emailCondition);
                ldapObjects = ldapQuery.getResultList();
                results.addAll(ldapObjects);
            }
            finally {
                if (ldapQuery != null) {
                    ldapQuery.close();
                }
            }
        }
        if (attributes.containsKey("firstName") || attributes.containsKey("lastName")) {
            ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);
            try {
                conditionsBuilder = new LDAPQueryConditionsBuilder();
                if (attributes.containsKey("firstName")) {
                    ldapQuery.addWhereCondition(conditionsBuilder.equal("firstName", attributes.get("firstName"), EscapeStrategy.NON_ASCII_CHARS_ONLY));
                }
                if (attributes.containsKey("lastName")) {
                    ldapQuery.addWhereCondition(conditionsBuilder.equal("lastName", attributes.get("lastName"), EscapeStrategy.NON_ASCII_CHARS_ONLY));
                }
                List<LDAPObject> ldapObjects2 = ldapQuery.getResultList();
                results.addAll(ldapObjects2);
            }
            finally {
                if (ldapQuery != null) {
                    ldapQuery.close();
                }
            }
        }
        return results;
    }

    protected LDAPObject loadAndValidateUser(RealmModel realm, UserModel local) {
        LDAPObject existing = this.userManager.getManagedLDAPUser(local.getId());
        if (existing != null) {
            return existing;
        }
        String uuidLdapAttribute = local.getFirstAttribute("LDAP_ID");
        LDAPObject ldapUser = this.loadLDAPUserByUuid(realm, uuidLdapAttribute);
        if (ldapUser == null) {
            return null;
        }
        LDAPUtils.checkUuid(ldapUser, this.ldapIdentityStore.getConfig());
        if (ldapUser.getUuid().equals(local.getFirstAttribute("LDAP_ID"))) {
            return ldapUser;
        }
        logger.warnf("LDAP User invalid. ID doesn't match. ID from LDAP [%s], LDAP ID from local DB: [%s]", (Object)ldapUser.getUuid(), (Object)local.getFirstAttribute("LDAP_ID"));
        return null;
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        LDAPObject ldapUser = this.loadLDAPUserByUsername(realm, username);
        if (ldapUser == null) {
            return null;
        }
        return this.importUserFromLDAP(this.session, realm, ldapUser);
    }

    protected UserModel importUserFromLDAP(KeycloakSession session, RealmModel realm, LDAPObject ldapUser) {
        String ldapUsername = LDAPUtils.getUsername(ldapUser, this.ldapIdentityStore.getConfig());
        LDAPUtils.checkUuid(ldapUser, this.ldapIdentityStore.getConfig());
        UserModel imported = null;
        if (this.model.isImportEnabled()) {
            UserModel existingLocalUser = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)session).searchForUserByUserAttributeStream(realm, "LDAP_ID", ldapUser.getUuid()).findFirst().orElse(null);
            if (existingLocalUser != null) {
                imported = existingLocalUser;
                if (UserStorageUtil.userCache((KeycloakSession)session) != null) {
                    UserStorageUtil.userCache((KeycloakSession)session).evict(realm, existingLocalUser);
                }
            } else {
                imported = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)session).addUser(realm, ldapUsername);
            }
        } else {
            InMemoryUserAdapter adapter = new InMemoryUserAdapter(session, realm, new StorageId(this.model.getId(), ldapUsername).getId());
            adapter.addDefaults();
            imported = adapter;
        }
        imported.setEnabled(true);
        UserModel finalImported = imported;
        realm.getComponentsStream(this.model.getId(), LDAPStorageMapper.class.getName()).sorted(this.ldapMappersComparator.sortDesc()).forEachOrdered(mapperModel -> {
            if (logger.isTraceEnabled()) {
                logger.tracef("Using mapper %s during import user from LDAP", mapperModel);
            }
            LDAPStorageMapper ldapMapper = this.mapperManager.getMapper((ComponentModel)mapperModel);
            ldapMapper.onImportUserFromLDAP(ldapUser, finalImported, realm, true);
        });
        String userDN = ldapUser.getDn().toString();
        if (this.model.isImportEnabled()) {
            imported.setFederationLink(this.model.getId());
        }
        imported.setSingleAttribute("LDAP_ID", ldapUser.getUuid());
        imported.setSingleAttribute("LDAP_ENTRY_DN", userDN);
        if (this.getLdapIdentityStore().getConfig().isTrustEmail()) {
            imported.setEmailVerified(true);
        }
        logger.debugf("Imported new user from LDAP to Keycloak DB. Username: [%s], Email: [%s], LDAP_ID: [%s], LDAP Entry DN: [%s]", new Object[]{imported.getUsername(), imported.getEmail(), ldapUser.getUuid(), userDN});
        UserModel proxy = this.proxy(realm, imported, ldapUser, false);
        return proxy;
    }

    protected LDAPObject queryByEmail(RealmModel realm, String email) {
        try (LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);){
            LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
            Condition emailCondition = conditionsBuilder.equal("email", email, EscapeStrategy.DEFAULT);
            ldapQuery.addWhereCondition(emailCondition);
            LDAPObject lDAPObject = ldapQuery.getFirstResult();
            return lDAPObject;
        }
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        LDAPObject ldapUser = this.queryByEmail(realm, email);
        if (ldapUser == null) {
            return null;
        }
        String ldapUsername = LDAPUtils.getUsername(ldapUser, this.ldapIdentityStore.getConfig());
        UserModel user = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session).getUserByUsername(realm, ldapUsername);
        if (user != null) {
            LDAPUtils.checkUuid(ldapUser, this.ldapIdentityStore.getConfig());
            if (ldapUser.getUuid().equals(user.getFirstAttribute("LDAP_ID"))) {
                return this.proxy(realm, user, ldapUser, false);
            }
            throw new ModelDuplicateException("User with username '" + ldapUsername + "' already exists in Keycloak. It conflicts with LDAP user with email '" + email + "'");
        }
        return this.importUserFromLDAP(this.session, realm, ldapUser);
    }

    public void preRemove(RealmModel realm) {
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public void preRemove(RealmModel realm, GroupModel group) {
    }

    public boolean validPassword(RealmModel realm, UserModel user, String password) {
        if (this.kerberosConfig.isAllowKerberosAuthentication() && this.kerberosConfig.isUseKerberosForPasswordAuthentication()) {
            KerberosUsernamePasswordAuthenticator authenticator = this.factory.createKerberosUsernamePasswordAuthenticator(this.kerberosConfig);
            return authenticator.validUser(user.getUsername(), password);
        }
        LDAPObject ldapUser = this.loadAndValidateUser(realm, user);
        try {
            this.ldapIdentityStore.validatePassword(ldapUser, password);
            return true;
        }
        catch (AuthenticationException ae) {
            AtomicReference<Boolean> processed = new AtomicReference<Boolean>(false);
            realm.getComponentsStream(this.model.getId(), LDAPStorageMapper.class.getName()).sorted(this.ldapMappersComparator.sortDesc()).forEachOrdered(mapperModel -> {
                if (logger.isTraceEnabled()) {
                    logger.tracef("Using mapper %s during import user from LDAP", mapperModel);
                }
                LDAPStorageMapper ldapMapper = this.mapperManager.getMapper((ComponentModel)mapperModel);
                processed.set((Boolean)processed.get() != false || ldapMapper.onAuthenticationFailure(ldapUser, user, ae, realm));
            });
            return processed.get();
        }
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        if (!"password".equals(input.getType()) || !(input instanceof UserCredentialModel)) {
            return false;
        }
        if (this.editMode == UserStorageProvider.EditMode.READ_ONLY) {
            throw new ReadOnlyException("Federated storage is not writable");
        }
        if (this.editMode == UserStorageProvider.EditMode.WRITABLE) {
            PolicyError error;
            LDAPIdentityStore ldapIdentityStore = this.getLdapIdentityStore();
            String password = input.getChallengeResponse();
            LDAPObject ldapUser = this.loadAndValidateUser(realm, user);
            if (ldapIdentityStore.getConfig().isValidatePasswordPolicy() && (error = ((PasswordPolicyManagerProvider)this.session.getProvider(PasswordPolicyManagerProvider.class)).validate(realm, user, password)) != null) {
                throw new ModelException(error.getMessage(), error.getParameters());
            }
            try {
                LDAPOperationDecorator operationDecorator = null;
                if (this.updater != null) {
                    operationDecorator = this.updater.beforePasswordUpdate(user, ldapUser, (UserCredentialModel)input);
                }
                ldapIdentityStore.updatePassword(ldapUser, password, operationDecorator);
                if (this.updater != null) {
                    this.updater.passwordUpdated(user, ldapUser, (UserCredentialModel)input);
                }
                return true;
            }
            catch (ModelException me) {
                if (this.updater != null) {
                    this.updater.passwordUpdateFailed(user, ldapUser, (UserCredentialModel)input, me);
                    return false;
                }
                throw me;
            }
        }
        return false;
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
    }

    public Stream<String> getDisableableCredentialTypesStream(RealmModel realm, UserModel user) {
        return Stream.empty();
    }

    public Set<String> getSupportedCredentialTypes() {
        return new HashSet<String>(this.supportedCredentialTypes);
    }

    public boolean supportsCredentialType(String credentialType) {
        return this.getSupportedCredentialTypes().contains(credentialType);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        return this.getSupportedCredentialTypes().contains(credentialType);
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof UserCredentialModel)) {
            return false;
        }
        if (input.getType().equals("password") && !((LegacyUserCredentialManager)user.credentialManager()).isConfiguredLocally("password")) {
            return this.validPassword(realm, user, input.getChallengeResponse());
        }
        return false;
    }

    public CredentialValidationOutput authenticate(RealmModel realm, CredentialInput cred) {
        if (!(cred instanceof UserCredentialModel)) {
            return CredentialValidationOutput.failed();
        }
        UserCredentialModel credential = (UserCredentialModel)cred;
        if (credential.getType().equals("kerberos") && this.kerberosConfig.isAllowKerberosAuthentication()) {
            String spnegoToken = credential.getChallengeResponse();
            SPNEGOAuthenticator spnegoAuthenticator = this.factory.createSPNEGOAuthenticator(spnegoToken, this.kerberosConfig);
            spnegoAuthenticator.authenticate();
            HashMap<String, String> state = new HashMap<String, String>();
            if (spnegoAuthenticator.isAuthenticated()) {
                String username = spnegoAuthenticator.getAuthenticatedUsername();
                UserModel user = this.findOrCreateAuthenticatedUser(realm, username);
                if (user == null) {
                    logger.warnf("Kerberos/SPNEGO authentication succeeded with username [%s], but couldn't find or create user with federation provider [%s]", (Object)username, (Object)this.model.getName());
                    return CredentialValidationOutput.failed();
                }
                String delegationCredential = spnegoAuthenticator.getSerializedDelegationCredential();
                if (delegationCredential != null) {
                    state.put("gss_delegation_credential", delegationCredential);
                }
                return new CredentialValidationOutput(user, CredentialValidationOutput.Status.AUTHENTICATED, state);
            }
            if (spnegoAuthenticator.getResponseToken() != null) {
                logger.tracef("SPNEGO Handshake will continue", new Object[0]);
                state.put("SpnegoResponseToken", spnegoAuthenticator.getResponseToken());
                return new CredentialValidationOutput(null, CredentialValidationOutput.Status.CONTINUE, state);
            }
            logger.tracef("SPNEGO Handshake not successful", new Object[0]);
            return CredentialValidationOutput.failed();
        }
        return CredentialValidationOutput.failed();
    }

    public void close() {
    }

    protected UserModel findOrCreateAuthenticatedUser(RealmModel realm, String username) {
        UserModel user = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session).getUserByUsername(realm, username);
        if (user != null) {
            logger.debugf("Kerberos authenticated user [%s] found in Keycloak storage", (Object)username);
            if (!this.model.getId().equals(user.getFederationLink())) {
                logger.warnf("User with username [%s] already exists, but is not linked to provider [%s]", (Object)username, (Object)this.model.getName());
                return null;
            }
            LDAPObject ldapObject = this.loadAndValidateUser(realm, user);
            if (ldapObject != null) {
                return this.proxy(realm, user, ldapObject, false);
            }
            logger.warnf("User with username [%s] aready exists and is linked to provider [%s] but is not valid. Stale LDAP_ID on local user is: %s", (Object)username, (Object)this.model.getName(), (Object)user.getFirstAttribute("LDAP_ID"));
            logger.warn((Object)"Will re-create user");
            UserCache userCache = UserStorageUtil.userCache((KeycloakSession)this.session);
            if (userCache != null) {
                userCache.evict(realm, user);
            }
            new UserManager(this.session).removeUser(realm, user, UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session));
        }
        logger.debugf("Kerberos authenticated user [%s] not in Keycloak storage. Creating him", (Object)username);
        return this.getUserByUsername(realm, username);
    }

    public LDAPObject loadLDAPUserByUsername(RealmModel realm, String username) {
        try (LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);){
            LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
            String usernameMappedAttribute = this.ldapIdentityStore.getConfig().getUsernameLdapAttribute();
            Condition usernameCondition = conditionsBuilder.equal(usernameMappedAttribute, username, EscapeStrategy.DEFAULT);
            ldapQuery.addWhereCondition(usernameCondition);
            LDAPObject ldapUser = ldapQuery.getFirstResult();
            if (ldapUser == null) {
                LDAPObject lDAPObject = null;
                return lDAPObject;
            }
            LDAPObject lDAPObject = ldapUser;
            return lDAPObject;
        }
    }

    public LDAPObject loadLDAPUserByUuid(RealmModel realm, String uuid) {
        if (uuid == null) {
            return null;
        }
        try (LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);){
            LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
            String uuidLDAPAttributeName = this.ldapIdentityStore.getConfig().getUuidLDAPAttributeName();
            Condition usernameCondition = conditionsBuilder.equal(uuidLDAPAttributeName, uuid, EscapeStrategy.DEFAULT);
            ldapQuery.addWhereCondition(usernameCondition);
            LDAPObject lDAPObject = ldapQuery.getFirstResult();
            return lDAPObject;
        }
    }
}

