/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.ResourceServerService;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class AuthorizationService {
    private final AdminPermissionEvaluator auth;
    private final ClientModel client;
    private ResourceServer resourceServer;
    private final AuthorizationProvider authorization;
    private final AdminEventBuilder adminEvent;

    public AuthorizationService(KeycloakSession session, ClientModel client, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.client = client;
        this.authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        this.adminEvent = adminEvent;
        this.resourceServer = this.authorization.getStoreFactory().getResourceServerStore().findByClient(this.client);
        this.auth = auth;
    }

    @Path(value="/resource-server")
    public Object resourceServer() {
        if (this.resourceServer == null) {
            throw new NotFoundException();
        }
        return this.getResourceServerService();
    }

    public ResourceServerService getResourceServerService() {
        ResourceServerService resource = new ResourceServerService(this.authorization, this.resourceServer, this.client, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    public void enable(boolean newClient) {
        this.resourceServer = this.getResourceServerService().create(newClient);
    }

    public void disable() {
        if (this.isEnabled()) {
            this.getResourceServerService().delete();
        }
    }

    public boolean isEnabled() {
        return this.resourceServer != null;
    }
}

