/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.reactive.common.jaxrs.RuntimeDelegateImpl;

public abstract class RestResponse<T>
implements AutoCloseable {
    protected RestResponse() {
    }

    public abstract int getStatus();

    public abstract Response.StatusType getStatusInfo();

    public abstract T getEntity();

    public abstract <OtherT> OtherT readEntity(Class<OtherT> var1);

    public abstract <OtherT> OtherT readEntity(GenericType<OtherT> var1);

    public abstract <OtherT> OtherT readEntity(Class<OtherT> var1, Annotation[] var2);

    public abstract <OtherT> OtherT readEntity(GenericType<OtherT> var1, Annotation[] var2);

    public abstract boolean hasEntity();

    public abstract boolean bufferEntity();

    @Override
    public abstract void close();

    public abstract MediaType getMediaType();

    public abstract Locale getLanguage();

    public abstract int getLength();

    public abstract Set<String> getAllowedMethods();

    public abstract Map<String, NewCookie> getCookies();

    public abstract EntityTag getEntityTag();

    public abstract Date getDate();

    public abstract Date getLastModified();

    public abstract URI getLocation();

    public abstract Set<Link> getLinks();

    public abstract boolean hasLink(String var1);

    public abstract Link getLink(String var1);

    public abstract Link.Builder getLinkBuilder(String var1);

    public abstract MultivaluedMap<String, Object> getMetadata();

    public MultivaluedMap<String, Object> getHeaders() {
        return this.getMetadata();
    }

    public abstract MultivaluedMap<String, String> getStringHeaders();

    public abstract String getHeaderString(String var1);

    public abstract Response toResponse();

    public static <T> RestResponse<T> fromResponse(RestResponse<T> response) {
        ResponseBuilder b = ResponseBuilder.create(response.getStatus());
        if (response.hasEntity()) {
            b.entity(response.getEntity());
        }
        for (String headerName : response.getHeaders().keySet()) {
            List headerValues = (List)response.getHeaders().get((Object)headerName);
            for (Object headerValue : headerValues) {
                b.header(headerName, headerValue);
            }
        }
        return b.build();
    }

    public static <IGNORED> RestResponse<IGNORED> status(Response.StatusType status) {
        return ResponseBuilder.create(status).build();
    }

    public static <T> RestResponse<T> status(Response.StatusType status, T entity) {
        return ResponseBuilder.create(status, entity).build();
    }

    public static <IGNORED> RestResponse<IGNORED> status(Status status) {
        return ResponseBuilder.create(status).build();
    }

    public static <T> RestResponse<T> status(Status status, T entity) {
        return ResponseBuilder.create(status, entity).build();
    }

    public static <IGNORED> RestResponse<IGNORED> status(int status) {
        return ResponseBuilder.create(status).build();
    }

    public static <IGNORED> RestResponse<IGNORED> status(int status, String reasonPhrase) {
        return ResponseBuilder.create(status, reasonPhrase).build();
    }

    public static <IGNORED> RestResponse<IGNORED> ok() {
        return ResponseBuilder.ok().build();
    }

    public static <T> RestResponse<T> ok(T entity) {
        return ResponseBuilder.ok(entity).build();
    }

    public static <T> RestResponse<T> ok(T entity, MediaType type) {
        return ResponseBuilder.ok(entity, type).build();
    }

    public static <T> RestResponse<T> ok(T entity, String type) {
        return ResponseBuilder.ok(entity, type).build();
    }

    public static <T> RestResponse<T> ok(T entity, Variant variant) {
        return ResponseBuilder.ok(entity, variant).build();
    }

    public static <IGNORED> RestResponse<IGNORED> serverError() {
        return ResponseBuilder.serverError().build();
    }

    public static <IGNORED> RestResponse<IGNORED> created(URI location) {
        return ResponseBuilder.created(location).build();
    }

    public static <IGNORED> RestResponse<IGNORED> accepted() {
        return ResponseBuilder.accepted().build();
    }

    public static <T> RestResponse<T> accepted(T entity) {
        return ResponseBuilder.accepted(entity).build();
    }

    public static <IGNORED> RestResponse<IGNORED> noContent() {
        return ResponseBuilder.noContent().build();
    }

    public static <IGNORED> RestResponse<IGNORED> notModified() {
        return ResponseBuilder.notModified().build();
    }

    public static <IGNORED> RestResponse<IGNORED> notModified(EntityTag tag) {
        return ResponseBuilder.notModified(tag).build();
    }

    public static <IGNORED> RestResponse<IGNORED> notModified(String tag) {
        return ResponseBuilder.notModified(tag).build();
    }

    public static <IGNORED> RestResponse<IGNORED> seeOther(URI location) {
        return ResponseBuilder.seeOther(location).build();
    }

    public static <IGNORED> RestResponse<IGNORED> temporaryRedirect(URI location) {
        return ResponseBuilder.temporaryRedirect(location).build();
    }

    public static <IGNORED> RestResponse<IGNORED> notAcceptable(List<Variant> variants) {
        return ResponseBuilder.notAcceptable(variants).build();
    }

    public static <IGNORED> RestResponse<IGNORED> notFound() {
        return ResponseBuilder.notFound().build();
    }

    public static class StatusCode {
        public static final int CONTINUE = 100;
        public static final int SWITCHING_PROTOCOLS = 101;
        public static final int OK = 200;
        public static final int CREATED = 201;
        public static final int ACCEPTED = 202;
        public static final int NON_AUTHORITATIVE_INFORMATION = 203;
        public static final int NO_CONTENT = 204;
        public static final int RESET_CONTENT = 205;
        public static final int PARTIAL_CONTENT = 206;
        public static final int MULTIPLE_CHOICES = 300;
        public static final int MOVED_PERMANENTLY = 301;
        public static final int FOUND = 302;
        public static final int SEE_OTHER = 303;
        public static final int NOT_MODIFIED = 304;
        public static final int USE_PROXY = 305;
        public static final int TEMPORARY_REDIRECT = 307;
        public static final int PERMANENT_REDIRECT = 308;
        public static final int BAD_REQUEST = 400;
        public static final int UNAUTHORIZED = 401;
        public static final int PAYMENT_REQUIRED = 402;
        public static final int FORBIDDEN = 403;
        public static final int NOT_FOUND = 404;
        public static final int METHOD_NOT_ALLOWED = 405;
        public static final int NOT_ACCEPTABLE = 406;
        public static final int PROXY_AUTHENTICATION_REQUIRED = 407;
        public static final int REQUEST_TIMEOUT = 408;
        public static final int CONFLICT = 409;
        public static final int GONE = 410;
        public static final int LENGTH_REQUIRED = 411;
        public static final int PRECONDITION_FAILED = 412;
        public static final int PAYLOAD_TOO_LARGE = 413;
        public static final int URI_TOO_LONG = 414;
        public static final int UNSUPPORTED_MEDIA_TYPE = 415;
        public static final int REQUESTED_RANGE_NOT_SATISFIABLE = 416;
        public static final int EXPECTATION_FAILED = 417;
        public static final int UPGRADE_REQUIRED = 426;
        public static final int PRECONDITION_REQUIRED = 428;
        public static final int TOO_MANY_REQUESTS = 429;
        public static final int REQUEST_HEADER_FIELDS_TOO_LARGE = 431;
        public static final int INTERNAL_SERVER_ERROR = 500;
        public static final int NOT_IMPLEMENTED = 501;
        public static final int BAD_GATEWAY = 502;
        public static final int SERVICE_UNAVAILABLE = 503;
        public static final int GATEWAY_TIMEOUT = 504;
        public static final int HTTP_VERSION_NOT_SUPPORTED = 505;
        public static final int NETWORK_AUTHENTICATION_REQUIRED = 511;
    }

    public static enum Status implements Response.StatusType
    {
        CONTINUE(100, "Continue"),
        SWITCHING_PROTOCOLS(101, "Switching Protocols"),
        OK(200, "OK"),
        CREATED(201, "Created"),
        ACCEPTED(202, "Accepted"),
        NON_AUTHORITATIVE_INFORMATION(203, "Non-Authoritative Information"),
        NO_CONTENT(204, "No Content"),
        RESET_CONTENT(205, "Reset Content"),
        PARTIAL_CONTENT(206, "Partial Content"),
        MULTIPLE_CHOICES(300, "Multiple Choices"),
        MOVED_PERMANENTLY(301, "Moved Permanently"),
        FOUND(302, "Found"),
        SEE_OTHER(303, "See Other"),
        NOT_MODIFIED(304, "Not Modified"),
        USE_PROXY(305, "Use Proxy"),
        TEMPORARY_REDIRECT(307, "Temporary Redirect"),
        PERMANENT_REDIRECT(308, "Permanent Redirect"),
        BAD_REQUEST(400, "Bad Request"),
        UNAUTHORIZED(401, "Unauthorized"),
        PAYMENT_REQUIRED(402, "Payment Required"),
        FORBIDDEN(403, "Forbidden"),
        NOT_FOUND(404, "Not Found"),
        METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
        NOT_ACCEPTABLE(406, "Not Acceptable"),
        PROXY_AUTHENTICATION_REQUIRED(407, "Proxy Authentication Required"),
        REQUEST_TIMEOUT(408, "Request Timeout"),
        CONFLICT(409, "Conflict"),
        GONE(410, "Gone"),
        LENGTH_REQUIRED(411, "Length Required"),
        PRECONDITION_FAILED(412, "Precondition Failed"),
        PAYLOAD_TOO_LARGE(413, "Payload Too Large"),
        URI_TOO_LONG(414, "URI Too Long"),
        UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type"),
        REQUESTED_RANGE_NOT_SATISFIABLE(416, "Requested Range Not Satisfiable"),
        EXPECTATION_FAILED(417, "Expectation Failed"),
        UPGRADE_REQUIRED(426, "Upgrade Required"),
        PRECONDITION_REQUIRED(428, "Precondition Required"),
        TOO_MANY_REQUESTS(429, "Too Many Requests"),
        REQUEST_HEADER_FIELDS_TOO_LARGE(431, "Request Header Fields Too Large"),
        INTERNAL_SERVER_ERROR(500, "Internal Server Error"),
        NOT_IMPLEMENTED(501, "Not Implemented"),
        BAD_GATEWAY(502, "Bad Gateway"),
        SERVICE_UNAVAILABLE(503, "Service Unavailable"),
        GATEWAY_TIMEOUT(504, "Gateway Timeout"),
        HTTP_VERSION_NOT_SUPPORTED(505, "Http Version Not Supported"),
        NETWORK_AUTHENTICATION_REQUIRED(511, "Network Authentication Required");

        private final int code;
        private final String reason;
        private final Response.Status.Family family;

        private Status(int statusCode, String reasonPhrase) {
            this.code = statusCode;
            this.reason = reasonPhrase;
            this.family = Response.Status.Family.familyOf((int)statusCode);
        }

        public Response.Status.Family getFamily() {
            return this.family;
        }

        public int getStatusCode() {
            return this.code;
        }

        public String getReasonPhrase() {
            return this.toString();
        }

        public String toString() {
            return this.reason;
        }

        public static Status fromStatusCode(int statusCode) {
            for (Status s : Status.values()) {
                if (s.code != statusCode) continue;
                return s;
            }
            return null;
        }
    }

    public static abstract class ResponseBuilder<T> {
        protected ResponseBuilder() {
        }

        protected static <T> ResponseBuilder<T> newInstance() {
            return ((RuntimeDelegateImpl)RuntimeDelegate.getInstance()).createRestResponseBuilder();
        }

        public abstract RestResponse<T> build();

        public abstract ResponseBuilder<T> clone();

        public abstract <Ret extends T> ResponseBuilder<Ret> status(int var1);

        public abstract <Ret extends T> ResponseBuilder<Ret> status(int var1, String var2);

        public <Ret extends T> ResponseBuilder<Ret> status(Response.StatusType status) {
            if (status == null) {
                throw new IllegalArgumentException();
            }
            return this.status(status.getStatusCode(), status.getReasonPhrase());
        }

        public ResponseBuilder<T> status(Status status) {
            return this.status((Response.StatusType)status);
        }

        public abstract ResponseBuilder<T> entity(T var1);

        public abstract ResponseBuilder<T> entity(T var1, Annotation[] var2);

        public abstract ResponseBuilder<T> allow(String ... var1);

        public abstract ResponseBuilder<T> allow(Set<String> var1);

        public abstract ResponseBuilder<T> cacheControl(CacheControl var1);

        public abstract ResponseBuilder<T> encoding(String var1);

        public abstract ResponseBuilder<T> header(String var1, Object var2);

        public abstract ResponseBuilder<T> replaceAll(MultivaluedMap<String, Object> var1);

        public abstract ResponseBuilder<T> language(String var1);

        public abstract ResponseBuilder<T> language(Locale var1);

        public abstract ResponseBuilder<T> type(MediaType var1);

        public abstract ResponseBuilder<T> type(String var1);

        public abstract ResponseBuilder<T> variant(Variant var1);

        public abstract ResponseBuilder<T> contentLocation(URI var1);

        public abstract ResponseBuilder<T> cookie(NewCookie ... var1);

        public abstract ResponseBuilder<T> expires(Date var1);

        public abstract ResponseBuilder<T> lastModified(Date var1);

        public abstract ResponseBuilder<T> location(URI var1);

        public abstract ResponseBuilder<T> tag(EntityTag var1);

        public abstract ResponseBuilder<T> tag(String var1);

        public abstract ResponseBuilder<T> variants(Variant ... var1);

        public abstract ResponseBuilder<T> variants(List<Variant> var1);

        public abstract ResponseBuilder<T> links(Link ... var1);

        public abstract ResponseBuilder<T> link(URI var1, String var2);

        public abstract ResponseBuilder<T> link(String var1, String var2);

        public static <T> ResponseBuilder<T> fromResponse(RestResponse<T> response) {
            ResponseBuilder b = ResponseBuilder.create(response.getStatus());
            if (response.hasEntity()) {
                b.entity(response.getEntity());
            }
            for (String headerName : response.getHeaders().keySet()) {
                List headerValues = (List)response.getHeaders().get((Object)headerName);
                for (Object headerValue : headerValues) {
                    b.header(headerName, headerValue);
                }
            }
            return b;
        }

        public static <IGNORED> ResponseBuilder<IGNORED> create(Response.StatusType status) {
            return ResponseBuilder.newInstance().status(status);
        }

        public static <T> ResponseBuilder<T> create(Response.StatusType status, T entity) {
            return ResponseBuilder.newInstance().status(status).entity(entity);
        }

        public static <IGNORED> ResponseBuilder<IGNORED> create(Status status) {
            return ResponseBuilder.create((Response.StatusType)status);
        }

        public static <T> ResponseBuilder<T> create(Status status, T entity) {
            return ResponseBuilder.create((Response.StatusType)status, entity);
        }

        public static <IGNORED> ResponseBuilder<IGNORED> create(int status) {
            return ResponseBuilder.newInstance().status(status);
        }

        public static <IGNORED> ResponseBuilder<IGNORED> create(int status, String reasonPhrase) {
            return ResponseBuilder.newInstance().status(status, reasonPhrase);
        }

        public static <IGNORED> ResponseBuilder<IGNORED> ok() {
            return ResponseBuilder.create(Status.OK);
        }

        public static <T> ResponseBuilder<T> ok(T entity) {
            return ResponseBuilder.create(Status.OK, entity);
        }

        public static <T> ResponseBuilder<T> ok(T entity, MediaType type) {
            return ResponseBuilder.ok(entity).type(type);
        }

        public static <T> ResponseBuilder<T> ok(T entity, String type) {
            return ResponseBuilder.ok(entity).type(type);
        }

        public static <T> ResponseBuilder<T> ok(T entity, Variant variant) {
            return ResponseBuilder.ok(entity).variant(variant);
        }

        public static <IGNORED> ResponseBuilder<IGNORED> serverError() {
            return ResponseBuilder.create(Status.INTERNAL_SERVER_ERROR);
        }

        public static <IGNORED> ResponseBuilder<IGNORED> created(URI location) {
            return ResponseBuilder.create(Status.CREATED).location(location);
        }

        public static <IGNORED> ResponseBuilder<IGNORED> accepted() {
            return ResponseBuilder.create(Status.ACCEPTED);
        }

        public static <T> ResponseBuilder<T> accepted(T entity) {
            return ResponseBuilder.create(Status.ACCEPTED, entity);
        }

        public static <IGNORED> ResponseBuilder<IGNORED> noContent() {
            return ResponseBuilder.create(Status.NO_CONTENT);
        }

        public static <IGNORED> ResponseBuilder<IGNORED> notModified() {
            return ResponseBuilder.create(Status.NOT_MODIFIED);
        }

        public static <IGNORED> ResponseBuilder<IGNORED> notModified(EntityTag tag) {
            return ResponseBuilder.notModified().tag(tag);
        }

        public static <IGNORED> ResponseBuilder<IGNORED> notModified(String tag) {
            return ResponseBuilder.notModified().tag(tag);
        }

        public static <IGNORED> ResponseBuilder<IGNORED> seeOther(URI location) {
            return ResponseBuilder.create(Status.SEE_OTHER).location(location);
        }

        public static <IGNORED> ResponseBuilder<IGNORED> temporaryRedirect(URI location) {
            return ResponseBuilder.create(Status.TEMPORARY_REDIRECT).location(location);
        }

        public static <IGNORED> ResponseBuilder<IGNORED> notAcceptable(List<Variant> variants) {
            return ResponseBuilder.create(Status.NOT_ACCEPTABLE).variants(variants);
        }

        public static <IGNORED> ResponseBuilder<IGNORED> notFound() {
            return ResponseBuilder.create(Status.NOT_FOUND);
        }
    }
}

