/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client;

import io.quarkus.runtime.TlsConfig;
import io.quarkus.vault.VaultException;
import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.client.MutinyVertxClientFactory;
import io.quarkus.vault.runtime.client.Private;
import io.quarkus.vault.runtime.client.VertxVaultClient;
import io.vertx.core.VertxOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;

@Singleton
@Private
public class PrivateVertxVaultClient
extends VertxVaultClient {
    private AtomicReference<Vertx> vertx = new AtomicReference();
    private AtomicReference<WebClient> webClient = new AtomicReference();
    private final TlsConfig tlsConfig;
    private final VaultConfigHolder vaultConfigHolder;

    public PrivateVertxVaultClient(VaultConfigHolder vaultConfigHolder, TlsConfig tlsConfig) {
        super(vaultConfigHolder.getVaultBootstrapConfig().url.orElseThrow(() -> new VaultException("no vault url provided")), vaultConfigHolder.getVaultBootstrapConfig().enterprise.namespace, vaultConfigHolder.getVaultBootstrapConfig().readTimeout);
        this.vaultConfigHolder = vaultConfigHolder;
        this.tlsConfig = tlsConfig;
    }

    @Override
    protected WebClient getWebClient() {
        WebClient webClient = this.webClient.get();
        if (webClient == null && !this.webClient.compareAndSet(null, webClient = MutinyVertxClientFactory.createHttpClient(this.getVertx(), this.vaultConfigHolder.getVaultBootstrapConfig(), this.tlsConfig))) {
            webClient.close();
            return this.webClient.get();
        }
        return webClient;
    }

    private Vertx getVertx() {
        Vertx vertx = this.vertx.get();
        if (vertx == null && !this.vertx.compareAndSet(null, vertx = this.createVertxInstance())) {
            vertx.close().await().indefinitely();
            return this.vertx.get();
        }
        return vertx;
    }

    private Vertx createVertxInstance() {
        Vertx vertx;
        String originalValue = System.getProperty("vertx.disableDnsResolver");
        try {
            System.setProperty("vertx.disableDnsResolver", "true");
            vertx = Vertx.vertx((VertxOptions)new VertxOptions());
        }
        finally {
            if (originalValue == null) {
                System.clearProperty("vertx.disableDnsResolver");
            } else {
                System.setProperty("vertx.disableDnsResolver", originalValue);
            }
        }
        return vertx;
    }

    @Override
    @PreDestroy
    public void close() {
        try {
            WebClient webClient = this.webClient.getAndSet(null);
            if (webClient != null) {
                webClient.close();
            }
        }
        finally {
            Vertx vertx = this.vertx.getAndSet(null);
            if (vertx != null) {
                vertx.closeAndAwait();
            }
        }
    }
}

