/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client.secretengine;

import io.quarkus.vault.runtime.client.VaultClient;
import io.quarkus.vault.runtime.client.VaultInternalBase;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitCreateKeyBody;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitDecrypt;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitDecryptBody;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitEncrypt;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitEncryptBody;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitKeyConfigBody;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitKeyExport;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitListKeysResult;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitReadKeyResult;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitRewrapBody;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitSign;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitSignBody;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitVerify;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitVerifyBody;
import io.smallrye.mutiny.Uni;
import javax.inject.Singleton;

@Singleton
public class VaultInternalTransitSecretEngine
extends VaultInternalBase {
    @Override
    protected String opNamePrefix() {
        return super.opNamePrefix() + " [TRANSIT]";
    }

    public Uni<Void> updateTransitKeyConfiguration(VaultClient vaultClient, String token, String keyName, VaultTransitKeyConfigBody body) {
        return vaultClient.post(this.opName("Configure Key"), "transit/keys/" + keyName + "/config", token, (Object)body, 204);
    }

    public Uni<Void> createTransitKey(VaultClient vaultClient, String token, String keyName, VaultTransitCreateKeyBody body) {
        return vaultClient.post(this.opName("Create Key"), "transit/keys/" + keyName, token, (Object)body, 204);
    }

    public Uni<Void> deleteTransitKey(VaultClient vaultClient, String token, String keyName) {
        return vaultClient.delete(this.opName("Delete Key"), "transit/keys/" + keyName, token, 204);
    }

    public Uni<VaultTransitKeyExport> exportTransitKey(VaultClient vaultClient, String token, String keyType, String keyName, String version) {
        String path = "transit/export/" + keyType + "/" + keyName + (String)(version != null ? "/" + version : "");
        return vaultClient.get(this.opName("Export Key"), path, token, VaultTransitKeyExport.class);
    }

    public Uni<VaultTransitReadKeyResult> readTransitKey(VaultClient vaultClient, String token, String keyName) {
        return vaultClient.get(this.opName("Read Key"), "transit/keys/" + keyName, token, VaultTransitReadKeyResult.class);
    }

    public Uni<VaultTransitListKeysResult> listTransitKeys(VaultClient vaultClient, String token) {
        return vaultClient.list(this.opName("List Keys"), "transit/keys", token, VaultTransitListKeysResult.class);
    }

    public Uni<VaultTransitEncrypt> encrypt(VaultClient vaultClient, String token, String keyName, VaultTransitEncryptBody body) {
        return vaultClient.post(this.opName("Encrypt Key"), "transit/encrypt/" + keyName, token, (Object)body, VaultTransitEncrypt.class);
    }

    public Uni<VaultTransitDecrypt> decrypt(VaultClient vaultClient, String token, String keyName, VaultTransitDecryptBody body) {
        return vaultClient.post(this.opName("Decrypt Key"), "transit/decrypt/" + keyName, token, (Object)body, VaultTransitDecrypt.class);
    }

    public Uni<VaultTransitSign> sign(VaultClient vaultClient, String token, String keyName, String hashAlgorithm, VaultTransitSignBody body) {
        String path = "transit/sign/" + keyName + (String)(hashAlgorithm == null ? "" : "/" + hashAlgorithm);
        return vaultClient.post(this.opName("Sign"), path, token, (Object)body, VaultTransitSign.class);
    }

    public Uni<VaultTransitVerify> verify(VaultClient vaultClient, String token, String keyName, String hashAlgorithm, VaultTransitVerifyBody body) {
        String path = "transit/verify/" + keyName + (String)(hashAlgorithm == null ? "" : "/" + hashAlgorithm);
        return vaultClient.post(this.opName("Verify"), path, token, (Object)body, VaultTransitVerify.class);
    }

    public Uni<VaultTransitEncrypt> rewrap(VaultClient vaultClient, String token, String keyName, VaultTransitRewrapBody body) {
        return vaultClient.post(this.opName("Rewrap"), "transit/rewrap/" + keyName, token, (Object)body, VaultTransitEncrypt.class);
    }
}

