/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.localuser;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.auth.callback.OptionalNameCallback;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.sasl.util.AbstractSaslClient;

public final class LocalUserClient
extends AbstractSaslClient {
    public static final String QUIET_AUTH = "wildfly.sasl.local-user.quiet-auth";
    public static final String LEGACY_QUIET_AUTH = "jboss.sasl.local-user.quiet-auth";
    private static final int INITIAL_CHALLENGE_STATE = 1;
    private static final int CHALLENGE_RESPONSE_STATE = 2;
    private final boolean quietAuth;
    private static final byte UTF8NUL = 0;

    LocalUserClient(String protocol, String serverName, Map<String, ?> props, CallbackHandler callbackHandler, String authorizationId) {
        super("JBOSS-LOCAL-USER", protocol, serverName, callbackHandler, authorizationId, true, ElytronMessages.saslLocal);
        this.quietAuth = props == null ? false : (props.containsKey(QUIET_AUTH) ? Boolean.parseBoolean((String)props.get(QUIET_AUTH)) : (props.containsKey(LEGACY_QUIET_AUTH) ? Boolean.parseBoolean((String)props.get(LEGACY_QUIET_AUTH)) : false));
    }

    @Override
    public void init() {
        this.setNegotiationState(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] evaluateMessage(int state, byte[] message) throws SaslException {
        switch (state) {
            case 1: {
                String authorizationId = this.getAuthorizationId();
                byte[] bytes = authorizationId != null ? CodePointIterator.ofString((String)authorizationId).asUtf8(true).drain() : new byte[]{0};
                this.setNegotiationState(2);
                return bytes;
            }
            case 2: {
                String path = new String(message, StandardCharsets.UTF_8);
                File file = new File(path);
                byte[] challenge = new byte[8];
                try {
                    FileInputStream stream = new FileInputStream(file);
                    try {
                        int r;
                        for (int t = 0; t < 8; t += r) {
                            r = stream.read(challenge, t, 8 - t);
                            if (r >= 0) continue;
                            throw ElytronMessages.saslLocal.mechInvalidServerMessage().toSaslException();
                        }
                    }
                    finally {
                        LocalUserClient.safeClose(stream);
                    }
                }
                catch (IOException e) {
                    throw ElytronMessages.saslLocal.mechFailedToReadChallengeFile(e).toSaslException();
                }
                String authenticationId = this.getAuthorizationId();
                String authenticationRealm = null;
                if (!this.quietAuth) {
                    OptionalNameCallback nameCallback = authenticationId != null && !authenticationId.isEmpty() ? new OptionalNameCallback("User name", authenticationId) : new OptionalNameCallback("User name");
                    RealmCallback realmCallback = new RealmCallback("User realm");
                    try {
                        this.tryHandleCallbacks(nameCallback, realmCallback);
                        authenticationId = nameCallback.getName();
                        authenticationRealm = realmCallback.getText();
                    }
                    catch (UnsupportedCallbackException e) {
                        ElytronMessages.saslLocal.trace("CallbackHandler does not support name or realm callback", e);
                    }
                }
                if (authenticationId == null) {
                    authenticationId = "";
                }
                if (authenticationRealm == null) {
                    authenticationRealm = "";
                }
                ByteStringBuilder b = new ByteStringBuilder();
                b.append(challenge, 0, 8);
                b.append(authenticationId).append((byte)0).append(authenticationRealm);
                byte[] response = b.toArray();
                this.negotiationComplete();
                return response;
            }
        }
        throw Assert.impossibleSwitchCase((int)state);
    }

    private static void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

