/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster.infinispan;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.sessions.infinispan.util.KeycloakMarshallUtil;

@SerializeWith(value=ExternalizerImpl.class)
public class LockEntry
implements Serializable {
    private String node;
    private int timestamp;

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public static class ExternalizerImpl
    implements Externalizer<LockEntry> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, LockEntry obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.node, (ObjectOutput)output);
            KeycloakMarshallUtil.marshall(obj.timestamp, output);
        }

        public LockEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public LockEntry readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            LockEntry entry = new LockEntry();
            entry.setNode(MarshallUtil.unmarshallString((ObjectInput)input));
            entry.setTimestamp(KeycloakMarshallUtil.unmarshallInteger(input));
            return entry;
        }
    }
}

