/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import java.util.List;
import java.util.Locale;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jboss.resteasy.reactive.server.core.EncodedMediaType;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.serialization.EntityWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class FixedProducesHandler
implements ServerRestHandler {
    final EncodedMediaType mediaType;
    final String mediaTypeString;
    final String mediaTypeSubstring;
    final EntityWriter writer;

    public FixedProducesHandler(MediaType mediaType, EntityWriter writer) {
        this.mediaType = new EncodedMediaType(mediaType);
        this.writer = writer;
        this.mediaTypeString = mediaType.getType() + "/" + mediaType.getSubtype();
        this.mediaTypeSubstring = mediaType.getType() + "/*";
    }

    @Override
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        List acceptValues = (List)requestContext.getHeader("Accept", false);
        if (acceptValues.isEmpty()) {
            requestContext.setResponseContentType(this.mediaType);
            requestContext.setEntityWriter(this.writer);
        } else {
            boolean handled = false;
            for (int i = 0; i < acceptValues.size(); ++i) {
                String accept = (String)acceptValues.get(i);
                if (accept.contains(this.mediaTypeString) || accept.contains("*/*") || accept.contains(this.mediaTypeSubstring)) {
                    requestContext.setResponseContentType(this.mediaType);
                    requestContext.setEntityWriter(this.writer);
                    handled = true;
                    break;
                }
                String lowercaseAccept = accept.toLowerCase(Locale.ROOT);
                if (!lowercaseAccept.contains(this.mediaTypeString) && !lowercaseAccept.contains(this.mediaTypeSubstring)) continue;
                requestContext.setResponseContentType(this.mediaType);
                requestContext.setEntityWriter(this.writer);
                handled = true;
                break;
            }
            if (!handled) {
                throw new WebApplicationException(Response.notAcceptable((List)Variant.mediaTypes((MediaType[])new MediaType[]{this.mediaType.getMediaType()}).build()).build());
            }
        }
    }
}

