/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.EnvUtil;
import org.keycloak.common.util.KeystoreUtil;
import org.keycloak.connections.httpclient.HttpClientBuilder;
import org.keycloak.connections.httpclient.HttpClientFactory;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.connections.httpclient.ProxyMappings;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.truststore.TruststoreProvider;
import org.keycloak.utils.StringUtil;

public class DefaultHttpClientFactory
implements HttpClientFactory {
    private static final Logger logger = Logger.getLogger(DefaultHttpClientFactory.class);
    private static final String configScope = "keycloak.connectionsHttpClient.default.";
    private static final String HTTPS_PROXY = "https_proxy";
    private static final String HTTP_PROXY = "http_proxy";
    private static final String NO_PROXY = "no_proxy";
    private volatile CloseableHttpClient httpClient;
    private Config.Scope config;

    public HttpClientProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new HttpClientProvider(){

            public CloseableHttpClient getHttpClient() {
                return DefaultHttpClientFactory.this.httpClient;
            }

            public void close() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive exception aggregation
             */
            public int postText(String uri, String text) throws IOException {
                HttpPost request = new HttpPost(uri);
                request.setEntity(EntityBuilder.create().setText(text).setContentType(ContentType.TEXT_PLAIN).build());
                try (CloseableHttpResponse response = DefaultHttpClientFactory.this.httpClient.execute((HttpUriRequest)request);){
                    int n;
                    try {
                        n = response.getStatusLine().getStatusCode();
                    }
                    catch (Throwable throwable) {
                        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                        throw throwable;
                    }
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                    return n;
                }
                catch (Throwable t) {
                    logger.warn((Object)t.getMessage(), t);
                    throw t;
                }
            }

            public InputStream get(String uri) throws IOException {
                HttpGet request = new HttpGet(uri);
                CloseableHttpResponse response = DefaultHttpClientFactory.this.httpClient.execute((HttpUriRequest)request);
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    return null;
                }
                return entity.getContent();
            }
        };
    }

    public void close() {
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getId() {
        return "default";
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.httpClient == null) {
            DefaultHttpClientFactory defaultHttpClientFactory = this;
            synchronized (defaultHttpClientFactory) {
                if (this.httpClient == null) {
                    boolean disableTruststoreProvider;
                    long socketTimeout = this.config.getLong("socket-timeout-millis", Long.valueOf(5000L));
                    long establishConnectionTimeout = this.config.getLong("establish-connection-timeout-millis", Long.valueOf(-1L));
                    int maxPooledPerRoute = this.config.getInt("max-pooled-per-route", Integer.valueOf(64));
                    int connectionPoolSize = this.config.getInt("connection-pool-size", Integer.valueOf(128));
                    long connectionTTL = this.config.getLong("connection-ttl-millis", Long.valueOf(-1L));
                    boolean reuseConnections = this.config.getBoolean("reuse-connections", Boolean.valueOf(true));
                    long maxConnectionIdleTime = this.config.getLong("max-connection-idle-time-millis", Long.valueOf(900000L));
                    boolean disableCookies = this.config.getBoolean("disable-cookies", Boolean.valueOf(true));
                    String clientKeystore = this.config.get("client-keystore");
                    String clientKeystorePassword = this.config.get("client-keystore-password");
                    String clientPrivateKeyPassword = this.config.get("client-key-password");
                    boolean disableTrustManager = this.config.getBoolean("disable-trust-manager", Boolean.valueOf(false));
                    boolean expectContinueEnabled = this.getBooleanConfigWithSysPropFallback("expect-continue-enabled", false);
                    boolean resuseConnections = this.getBooleanConfigWithSysPropFallback("reuse-connections", true);
                    ProxyMappings proxyMappings = ProxyMappings.valueOf(this.config.getArray("proxy-mappings"));
                    if (proxyMappings == null || proxyMappings.isEmpty()) {
                        logger.debug((Object)"Trying to use proxy mapping from env vars");
                        String httpProxy = this.getEnvVarValue(HTTPS_PROXY);
                        if (StringUtil.isBlank((String)httpProxy)) {
                            httpProxy = this.getEnvVarValue(HTTP_PROXY);
                        }
                        String noProxy = this.getEnvVarValue(NO_PROXY);
                        logger.debugf("httpProxy: %s, noProxy: %s", (Object)httpProxy, (Object)noProxy);
                        proxyMappings = ProxyMappings.withFixedProxyMapping(httpProxy, noProxy);
                    }
                    HttpClientBuilder builder = new HttpClientBuilder();
                    builder.socketTimeout(socketTimeout, TimeUnit.MILLISECONDS).establishConnectionTimeout(establishConnectionTimeout, TimeUnit.MILLISECONDS).maxPooledPerRoute(maxPooledPerRoute).connectionPoolSize(connectionPoolSize).reuseConnections(reuseConnections).connectionTTL(connectionTTL, TimeUnit.MILLISECONDS).maxConnectionIdleTime(maxConnectionIdleTime, TimeUnit.MILLISECONDS).disableCookies(disableCookies).proxyMappings(proxyMappings).expectContinueEnabled(expectContinueEnabled).reuseConnections(resuseConnections);
                    TruststoreProvider truststoreProvider = (TruststoreProvider)session.getProvider(TruststoreProvider.class);
                    boolean bl = disableTruststoreProvider = truststoreProvider == null || truststoreProvider.getTruststore() == null;
                    if (disableTruststoreProvider) {
                        logger.warn((Object)"TruststoreProvider is disabled");
                    } else {
                        builder.hostnameVerification(HttpClientBuilder.HostnameVerificationPolicy.valueOf(truststoreProvider.getPolicy().name()));
                        try {
                            builder.trustStore(truststoreProvider.getTruststore());
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to load truststore", e);
                        }
                    }
                    if (disableTrustManager) {
                        logger.warn((Object)"TrustManager is disabled");
                        builder.disableTrustManager();
                    }
                    if (clientKeystore != null) {
                        clientKeystore = EnvUtil.replace((String)clientKeystore);
                        try {
                            KeyStore clientCertKeystore = KeystoreUtil.loadKeyStore((String)clientKeystore, (String)clientKeystorePassword);
                            builder.keyStore(clientCertKeystore, clientPrivateKeyPassword);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to load keystore", e);
                        }
                    }
                    this.httpClient = builder.build();
                }
            }
        }
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("socket-timeout-millis").type("long").helpText("Socket inactivity timeout.").defaultValue((Object)5000L).add().property().name("establish-connection-timeout-millis").type("long").helpText("When trying to make an initial socket connection, what is the timeout?").defaultValue((Object)-1L).add().property().name("max-pooled-per-route").type("int").helpText("Assigns maximum connection per route value.").defaultValue((Object)64).add().property().name("connection-pool-size").type("int").helpText("Assigns maximum total connection value.").add().property().name("connection-ttl-millis").type("long").helpText("Sets maximum time, in milliseconds, to live for persistent connections.").defaultValue((Object)-1L).add().property().name("reuse-connections").type("boolean").helpText("If connections should be reused.").defaultValue((Object)true).add().property().name("max-connection-idle-time-millis").type("long").helpText("Sets the time, in milliseconds, for evicting idle connections from the pool.").defaultValue((Object)900000).add().property().name("disable-cookies").type("boolean").helpText("Disables state (cookie) management.").defaultValue((Object)true).add().property().name("client-keystore").type("string").helpText("The file path of the key store from where the key material is going to be read from to set-up TLS connections.").add().property().name("client-keystore-password").type("string").helpText("The key store password.").add().property().name("client-key-password").type("string").helpText("The key password.").defaultValue((Object)-1L).add().property().name("disable-trust-manager").type("boolean").helpText("Disable trust management and hostname verification. NOTE this is a security hole, so only set this option if you cannot or do not want to verify the identity of the host you are communicating with.").defaultValue((Object)false).add().property().name("proxy-mappings").type("string").helpText("Denotes the combination of a regex based hostname pattern and a proxy-uri in the form of hostnamePattern;proxyUri.").add().build();
    }

    private boolean getBooleanConfigWithSysPropFallback(String key, boolean defaultValue) {
        String s;
        Boolean value = this.config.getBoolean(key);
        if (value == null && (s = System.getProperty(configScope + key)) != null) {
            value = Boolean.parseBoolean(s);
        }
        return value != null ? value : defaultValue;
    }

    private String getEnvVarValue(String name) {
        String value = System.getenv(name.toLowerCase());
        if (StringUtil.isBlank((String)value)) {
            value = System.getenv(name.toUpperCase());
        }
        return value;
    }
}

