/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;

public final class SortedServerMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private final HttpServerAuthenticationMechanismFactory delegate;
    private final Comparator<String> mechanismNameComparator;

    public SortedServerMechanismFactory(HttpServerAuthenticationMechanismFactory delegate, Comparator<String> mechanismNameComparator) {
        this.delegate = (HttpServerAuthenticationMechanismFactory)Assert.checkNotNullParam((String)"delegate", (Object)delegate);
        this.mechanismNameComparator = (Comparator)Assert.checkNotNullParam((String)"mechanismNameComparator", mechanismNameComparator);
    }

    public String[] getMechanismNames(Map<String, ?> properties) {
        String[] mechanismNames = this.delegate.getMechanismNames(properties);
        Arrays.sort(mechanismNames, this.mechanismNameComparator);
        return mechanismNames;
    }

    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        return this.delegate.createAuthenticationMechanism(mechanismName, properties, callbackHandler);
    }
}

