/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.transport.SSLConfig;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.DockerCompose;
import org.testcontainers.dockerclient.TransportConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.LocalDirectorySSLConfig;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.shaded.com.google.common.base.Splitter;
import org.testcontainers.shaded.com.google.common.collect.Maps;
import org.testcontainers.shaded.org.apache.commons.lang3.SystemUtils;
import org.testcontainers.shaded.org.zeroturnaround.exec.InvalidExitValueException;
import org.testcontainers.shaded.org.zeroturnaround.exec.ProcessExecutor;
import org.testcontainers.shaded.org.zeroturnaround.exec.stream.slf4j.Slf4jStream;
import org.testcontainers.utility.CommandLine;
import org.testcontainers.utility.DockerLoggerFactory;

class LocalDockerCompose
implements DockerCompose {
    private static final String COMPOSE_EXECUTABLE = SystemUtils.IS_OS_WINDOWS ? "docker-compose.exe" : "docker-compose";
    private final List<File> composeFiles;
    private final String identifier;
    private String cmd = "";
    private Map<String, String> env = new HashMap<String, String>();

    public LocalDockerCompose(List<File> composeFiles, String identifier) {
        this.composeFiles = composeFiles;
        this.identifier = identifier;
    }

    @Override
    public DockerCompose withCommand(String cmd) {
        this.cmd = cmd;
        return this;
    }

    @Override
    public DockerCompose withEnv(Map<String, String> env) {
        this.env = env;
        return this;
    }

    @VisibleForTesting
    static boolean executableExists() {
        return CommandLine.executableExists(COMPOSE_EXECUTABLE);
    }

    @Override
    public void invoke() {
        if (!LocalDockerCompose.executableExists()) {
            throw new ContainerLaunchException("Local Docker Compose not found. Is " + COMPOSE_EXECUTABLE + " on the PATH?");
        }
        HashMap<String, String> environment = Maps.newHashMap(this.env);
        environment.put("COMPOSE_PROJECT_NAME", this.identifier);
        TransportConfig transportConfig = DockerClientFactory.instance().getTransportConfig();
        SSLConfig sslConfig = transportConfig.getSslConfig();
        if (sslConfig != null) {
            if (sslConfig instanceof LocalDirectorySSLConfig) {
                environment.put("DOCKER_CERT_PATH", ((LocalDirectorySSLConfig)sslConfig).getDockerCertPath());
                environment.put("DOCKER_TLS_VERIFY", "true");
            } else {
                this.logger().warn("Couldn't set DOCKER_CERT_PATH. `sslConfig` is present but it's not LocalDirectorySSLConfig.");
            }
        }
        String dockerHost = transportConfig.getDockerHost().toString();
        environment.put("DOCKER_HOST", dockerHost);
        Stream<String> absoluteDockerComposeFilePaths = this.composeFiles.stream().map(File::getAbsolutePath).map(Objects::toString);
        String composeFileEnvVariableValue = absoluteDockerComposeFilePaths.collect(Collectors.joining(File.pathSeparator + ""));
        this.logger().debug("Set env COMPOSE_FILE={}", (Object)composeFileEnvVariableValue);
        File pwd = this.composeFiles.get(0).getAbsoluteFile().getParentFile().getAbsoluteFile();
        environment.put("COMPOSE_FILE", composeFileEnvVariableValue);
        this.logger().info("Local Docker Compose is running command: {}", (Object)this.cmd);
        List<String> command = Splitter.onPattern(" ").omitEmptyStrings().splitToList(COMPOSE_EXECUTABLE + " " + this.cmd);
        try {
            new ProcessExecutor().command(command).redirectOutput(Slf4jStream.of(this.logger()).asInfo()).redirectError(Slf4jStream.of(this.logger()).asInfo()).environment(environment).directory(pwd).exitValueNormal().executeNoTimeout();
            this.logger().info("Docker Compose has finished running");
        }
        catch (InvalidExitValueException e) {
            throw new ContainerLaunchException("Local Docker Compose exited abnormally with code " + e.getExitValue() + " whilst running command: " + this.cmd);
        }
        catch (Exception e) {
            throw new ContainerLaunchException("Error running local Docker Compose command: " + this.cmd, e);
        }
    }

    private Logger logger() {
        return DockerLoggerFactory.getLogger(COMPOSE_EXECUTABLE);
    }
}

