/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images.builder;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.Checksum;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;

public interface Transferable {
    public static final int DEFAULT_FILE_MODE = 33188;
    public static final int DEFAULT_DIR_MODE = 16877;

    public static Transferable of(String string) {
        return Transferable.of(string.getBytes(StandardCharsets.UTF_8));
    }

    public static Transferable of(byte[] bytes) {
        return Transferable.of(bytes, 33188);
    }

    public static Transferable of(final byte[] bytes, final int fileMode) {
        return new Transferable(){

            @Override
            public long getSize() {
                return bytes.length;
            }

            @Override
            public byte[] getBytes() {
                return bytes;
            }

            @Override
            public void updateChecksum(Checksum checksum) {
                checksum.update(bytes, 0, bytes.length);
            }

            @Override
            public int getFileMode() {
                return fileMode;
            }
        };
    }

    default public int getFileMode() {
        return 33188;
    }

    public long getSize();

    default public void transferTo(TarArchiveOutputStream tarArchiveOutputStream, String destination) {
        TarArchiveEntry tarEntry = new TarArchiveEntry(destination);
        tarEntry.setSize(this.getSize());
        tarEntry.setMode(this.getFileMode());
        try {
            tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarEntry);
            IOUtils.write(this.getBytes(), (OutputStream)tarArchiveOutputStream);
            tarArchiveOutputStream.closeArchiveEntry();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't transfer " + this.getDescription(), e);
        }
    }

    default public byte[] getBytes() {
        return new byte[0];
    }

    default public String getDescription() {
        return "";
    }

    default public void updateChecksum(Checksum checksum) {
        throw new UnsupportedOperationException("Provide implementation in subclass");
    }
}

