/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.config.Option;
import org.keycloak.config.OptionBuilder;
import org.keycloak.config.OptionCategory;
import org.keycloak.models.map.storage.hotRod.common.AutogeneratedHotRodDescriptors;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDescriptor;

public class StorageOptions {
    public static final Option<StorageType> STORAGE = new OptionBuilder<StorageType>("storage", StorageType.class).category(OptionCategory.STORAGE).description("Sets the default storage mechanism for all areas.").defaultValue((StorageType)((Object)Optional.empty())).buildTime(true).build();
    public static final Option<StorageType> STORAGE_PROVIDER = new OptionBuilder<StorageType>("storage-provider", StorageType.class).category(OptionCategory.STORAGE).buildTime(true).build();
    public static final Option<String> STORAGE_EVENT_STORE_PROVIDER = new OptionBuilder<String>("storage-event-store-provider", String.class).category(OptionCategory.STORAGE).buildTime(true).build();
    public static final Option<StorageType> STORAGE_EVENT_ADMIN_STORE = new OptionBuilder<StorageType>("storage-area-event-admin", StorageType.class).category(OptionCategory.STORAGE).description(StorageOptions.descriptionForStorageAreas("admin events")).buildTime(true).build();
    public static final Option<StorageType> STORAGE_EVENT_AUTH_STORE = new OptionBuilder<StorageType>("storage-area-event-auth", StorageType.class).category(OptionCategory.STORAGE).description(StorageOptions.descriptionForStorageAreas("authentication and authorization events")).buildTime(true).build();
    public static final Option<StorageType> STORAGE_EXCEPTION_CONVERTER = new OptionBuilder<StorageType>("storage-exception-converter", StorageType.class).category(OptionCategory.STORAGE).buildTime(true).build();
    public static final Option<String> STORAGE_REALM_PROVIDER = new OptionBuilder<String>("storage-realm-provider", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<StorageType> STORAGE_REALM_STORE = new OptionBuilder<StorageType>("storage-area-realm", StorageType.class).category(OptionCategory.STORAGE).description(StorageOptions.descriptionForStorageAreas("realms")).buildTime(true).build();
    public static final Option<String> STORAGE_CLIENT_PROVIDER = new OptionBuilder<String>("storage-client-provider", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<StorageType> STORAGE_CLIENT_STORE = new OptionBuilder<StorageType>("storage-area-client", StorageType.class).category(OptionCategory.STORAGE).description(StorageOptions.descriptionForStorageAreas("clients")).buildTime(true).build();
    public static final Option<String> STORAGE_CLIENT_SCOPE_PROVIDER = new OptionBuilder<String>("storage-client-scope-provider", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<StorageType> STORAGE_CLIENT_SCOPE_STORE = new OptionBuilder<StorageType>("storage-area-client-scope", StorageType.class).category(OptionCategory.STORAGE).description(StorageOptions.descriptionForStorageAreas("client scopes")).buildTime(true).build();
    public static final Option<String> STORAGE_GROUP_PROVIDER = new OptionBuilder<String>("storage-group-provider", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<StorageType> STORAGE_GROUP_STORE = new OptionBuilder<StorageType>("storage-area-group", StorageType.class).category(OptionCategory.STORAGE).description(StorageOptions.descriptionForStorageAreas("groups")).buildTime(true).build();
    public static final Option<String> STORAGE_ROLE_PROVIDER = new OptionBuilder<String>("storage-role-provider", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<StorageType> STORAGE_ROLE_STORE = new OptionBuilder<StorageType>("storage-area-role", StorageType.class).category(OptionCategory.STORAGE).description(StorageOptions.descriptionForStorageAreas("roles")).buildTime(true).build();
    public static final Option<String> STORAGE_USER_PROVIDER = new OptionBuilder<String>("storage-user-provider", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<StorageType> STORAGE_USER_STORE = new OptionBuilder<StorageType>("storage-area-user", StorageType.class).category(OptionCategory.STORAGE).description(StorageOptions.descriptionForStorageAreas("users")).buildTime(true).build();
    public static final Option<String> STORAGE_DEPLOYMENT_STATE_PROVIDER = new OptionBuilder<String>("storage-deployment-state-provider", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<String> STORAGE_DEPLOYMENT_STATE_RESOURCES_VERSION_SEED = new OptionBuilder<String>("storage-deployment-state-version-seed", String.class).category(OptionCategory.STORAGE).description("Secret that serves as a seed to mask the version number of Keycloak in URLs. Need to be identical across all servers in the cluster. Will default to a random number generated when starting the server which is secure but will lead to problems when a loadbalancer without sticky sessions is used or nodes are restarted.").buildTime(false).build();
    public static final Option<String> STORAGE_AUTH_SESSION_PROVIDER = new OptionBuilder<String>("storage-auth-session-provider", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<StorageType> STORAGE_AUTH_SESSION_STORE = new OptionBuilder<StorageType>("storage-area-auth-session", StorageType.class).category(OptionCategory.STORAGE).description(StorageOptions.descriptionForStorageAreas("authentication sessions")).buildTime(true).build();
    public static final Option<String> STORAGE_USER_SESSION_PROVIDER = new OptionBuilder<String>("storage-user-session-provider", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<StorageType> STORAGE_USER_SESSION_STORE = new OptionBuilder<StorageType>("storage-area-user-session", StorageType.class).category(OptionCategory.STORAGE).description(StorageOptions.descriptionForStorageAreas("user and client sessions")).buildTime(true).build();
    public static final Option<String> STORAGE_LOGIN_FAILURE_PROVIDER = new OptionBuilder<String>("storage-login-failure-provider", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<StorageType> STORAGE_LOGIN_FAILURE_STORE = new OptionBuilder<StorageType>("storage-area-login-failure", StorageType.class).category(OptionCategory.STORAGE).description(StorageOptions.descriptionForStorageAreas("login failures")).buildTime(true).build();
    public static final Option<String> STORAGE_AUTHORIZATION_PROVIDER = new OptionBuilder<String>("storage-authorization-provider", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<StorageType> STORAGE_AUTHORIZATION_STORE = new OptionBuilder<StorageType>("storage-area-authorization", StorageType.class).category(OptionCategory.STORAGE).description(StorageOptions.descriptionForStorageAreas("authorizations")).buildTime(true).build();
    public static final Option<String> STORAGE_USER_SESSION_PERSISTER = new OptionBuilder<String>("storage-user-session-persister", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<String> STORAGE_GLOBAL_LOCK_PROVIDER = new OptionBuilder<String>("storage-global-lock-provider", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<String> STORAGE_CACHE_REALM_ENABLED = new OptionBuilder<String>("cache-realm-enabled", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<String> STORAGE_CACHE_USER_ENABLED = new OptionBuilder<String>("cache-user-enabled", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<String> STORAGE_ADMIN_CACHE_CLEAR_USER = new OptionBuilder<String>("cache-clear-user", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<String> STORAGE_ADMIN_CACHE_CLEAR_REALM = new OptionBuilder<String>("cache-clear-realm", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<String> STORAGE_ADMIN_CACHE_CLEAR_KEYS = new OptionBuilder<String>("cache-clear-keys", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<String> STORAGE_SINGLE_USE_OBJECT_PROVIDER = new OptionBuilder<String>("storage-single-use-object-provider", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<StorageType> STORAGE_SINGLE_USE_OBJECT_STORE = new OptionBuilder<StorageType>("storage-area-single-use-object", StorageType.class).category(OptionCategory.STORAGE).description(StorageOptions.descriptionForStorageAreas("single use objects")).buildTime(true).expectedValues((StorageType[])((StorageType[])Stream.of(StorageType.values()).filter(Predicate.not(StorageType.file::equals)).toArray(StorageType[]::new))).build();
    public static final Option<String> STORAGE_PUBLIC_KEY_STORAGE_STORE = new OptionBuilder<String>("storage-public-key-storage", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<String> STORAGE_CACHE_AUTHORIZATION_ENABLED = new OptionBuilder<String>("cache-authorization-enabled", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<String> STORAGE_LEGACY_SESSION_SUPPORT = new OptionBuilder<String>("storage-legacy-session-support", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<String> STORAGE_ADMIN_USER_STORAGE = new OptionBuilder<String>("storage-admin-user-storage", String.class).category(OptionCategory.STORAGE).hidden().buildTime(true).build();
    public static final Option<String> STORAGE_HOTROD_HOST = new OptionBuilder<String>("storage-hotrod-host", String.class).category(OptionCategory.STORAGE).description("Sets the host of the Infinispan server.").build();
    public static final Option<Integer> STORAGE_HOTROD_PORT = new OptionBuilder<Integer>("storage-hotrod-port", Integer.class).category(OptionCategory.STORAGE).description("Sets the port of the Infinispan server.").build();
    public static final Option<String> STORAGE_HOTROD_USERNAME = new OptionBuilder<String>("storage-hotrod-username", String.class).category(OptionCategory.STORAGE).description("Sets the username of the Infinispan user.").build();
    public static final Option<String> STORAGE_HOTROD_PASSWORD = new OptionBuilder<String>("storage-hotrod-password", String.class).category(OptionCategory.STORAGE).description("Sets the password of the Infinispan user.").build();
    public static final Option<Boolean> STORAGE_HOTROD_CACHE_CONFIGURE = new OptionBuilder<Boolean>("storage-hotrod-cache-configure", Boolean.class).category(OptionCategory.STORAGE).defaultValue(true).description("When set to true, Keycloak will create and configure Infinispan caches on startup.").hidden().build();
    public static final Option<String> STORAGE_HOTROD_CACHE_REINDEX = new OptionBuilder<String>("storage-hotrod-cache-reindex", String.class).category(OptionCategory.STORAGE).defaultValue((String)((Object)Optional.empty())).expectedValues(StorageOptions::getExpectedCacheNames).description("List of cache names that should be indexed on Keycloak startup. When set to `all`, all caches are reindexed. By default no caches are reindexed.").hidden().build();
    public static final Option<String> STORAGE_FILE_DIR = new OptionBuilder<String>("storage-file-dir", String.class).category(OptionCategory.STORAGE).description("Root directory for file map store.").build();

    private static String descriptionForStorageAreas(String areaAsText) {
        return "Sets a storage mechanism for " + areaAsText + ".";
    }

    private static String storageAreas() {
        return String.join((CharSequence)",", Arrays.stream(StorageType.values()).map(Enum::name).collect(Collectors.joining(", ")));
    }

    private static List<String> getExpectedCacheNames() {
        return Stream.concat(Stream.of("all"), AutogeneratedHotRodDescriptors.ENTITY_DESCRIPTOR_MAP.values().stream().map(HotRodEntityDescriptor::getCacheName).distinct()).collect(Collectors.toList());
    }

    public static enum StorageType {
        jpa("jpa"),
        chm("concurrenthashmap"),
        hotrod("hotrod"),
        file("file");

        private final String provider;

        private StorageType(String provider) {
            this.provider = provider;
        }

        public String getProvider() {
            return this.provider;
        }
    }
}

