/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.statetransfer;

import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.statetransfer.AbstractStateTransferCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.statetransfer.TransactionInfo;
import org.infinispan.util.ByteString;

public class StateTransferGetTransactionsCommand
extends AbstractStateTransferCommand {
    public static final byte COMMAND_ID = 119;

    public StateTransferGetTransactionsCommand() {
        this(null);
    }

    public StateTransferGetTransactionsCommand(ByteString cacheName) {
        super((byte)119, cacheName);
    }

    public StateTransferGetTransactionsCommand(ByteString cacheName, int topologyId, IntSet segments) {
        super((byte)119, cacheName, topologyId, segments);
    }

    public CompletionStage<List<TransactionInfo>> invokeAsync(ComponentRegistry registry) throws Throwable {
        StateProvider stateProvider = registry.getStateTransferManager().getStateProvider();
        return stateProvider.getTransactionsForSegments(this.origin, this.topologyId, this.segments);
    }

    @Override
    public String toString() {
        return "StateTransferGetTransactionsCommand{topologyId=" + this.topologyId + ", segments=" + this.segments + ", cacheName=" + this.cacheName + "}";
    }
}

