/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx.table.functions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.server.hotrod.tx.table.CacheXid;
import org.infinispan.server.hotrod.tx.table.Status;
import org.infinispan.server.hotrod.tx.table.TxState;
import org.infinispan.server.hotrod.tx.table.functions.TxFunction;

public class PreparingDecisionFunction
extends TxFunction {
    public static final AdvancedExternalizer<PreparingDecisionFunction> EXTERNALIZER = new Externalizer();
    private final List<WriteCommand> modifications;

    public PreparingDecisionFunction(List<WriteCommand> modifications) {
        this.modifications = modifications;
    }

    @Override
    public Byte apply(EntryView.ReadWriteEntryView<CacheXid, TxState> view) {
        if (view.find().isPresent()) {
            TxState state = (TxState)view.get();
            switch (state.getStatus()) {
                case ACTIVE: {
                    view.set((Object)state.markPreparing(this.modifications, this.timeService), new MetaParam.Writable[0]);
                }
                case PREPARING: {
                    return Status.OK.value;
                }
            }
            return state.getStatus().value;
        }
        return Status.NO_TRANSACTION.value;
    }

    private static class Externalizer
    implements AdvancedExternalizer<PreparingDecisionFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends PreparingDecisionFunction>> getTypeClasses() {
            return Collections.singleton(PreparingDecisionFunction.class);
        }

        public Integer getId() {
            return 1117;
        }

        public void writeObject(ObjectOutput output, PreparingDecisionFunction object) throws IOException {
            MarshallUtil.marshallCollection(object.modifications, (ObjectOutput)output);
        }

        public PreparingDecisionFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new PreparingDecisionFunction((List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new));
        }
    }
}

