/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.restclient.model.IExecAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.dmr.ModelNode;

public class ExecAction
implements IExecAction {
    private static final String COMMAND = "command";
    private List<String> command;

    private ExecAction(List<String> command) {
        this.command = command;
    }

    @Override
    public List<String> getCommand() {
        return this.command;
    }

    @Override
    public String toJson() {
        ModelNode node = new ModelNode();
        ModelNode commandNode = node.get(COMMAND);
        for (String cmd : this.command) {
            commandNode.add().set(cmd);
        }
        return node.toJSONString(true);
    }

    public static IExecAction fromJson(ModelNode execNode) {
        Builder builder = new Builder();
        if (execNode.has(COMMAND)) {
            ModelNode commandNode = execNode.get(COMMAND);
            commandNode.asList().stream().map(ModelNode::asString).forEach(builder::command);
        }
        return builder.build();
    }

    @Override
    public String getType() {
        return "exec";
    }

    public static class Builder
    implements IExecAction.IBuilder {
        private List<String> commands = new ArrayList<String>();

        @Override
        public IExecAction.IBuilder command(String command) {
            this.commands.add(command);
            return this;
        }

        @Override
        public IExecAction build() {
            return new ExecAction(Collections.unmodifiableList(this.commands));
        }
    }
}

